/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.bluetooth;

import com.sun.kvem.bluetooth.UUID;
import java.util.Vector;

public class DataElement {
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int URL = 64;
    public static final int UUID = 24;
    public static final int BOOL = 40;
    public static final int STRING = 32;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    private int valueType;
    private boolean booleanValue;
    private long longValue;
    private Object miscValue;

    public DataElement(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 48: 
            case 56: {
                this.miscValue = new Vector();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueType for this constructor: " + n);
            }
        }
        this.valueType = n;
    }

    public DataElement(boolean bl) {
        this.valueType = 40;
        this.booleanValue = bl;
    }

    public DataElement(int n, long l) {
        long l2 = 0L;
        long l3 = 0L;
        switch (n) {
            case 8: {
                l3 = 255L;
                break;
            }
            case 9: {
                l3 = 65535L;
                break;
            }
            case 10: {
                l3 = 0xFFFFFFFFL;
                break;
            }
            case 16: {
                l2 = -128L;
                l3 = 127L;
                break;
            }
            case 17: {
                l2 = -32768L;
                l3 = 32767L;
                break;
            }
            case 18: {
                l2 = Integer.MIN_VALUE;
                l3 = Integer.MAX_VALUE;
                break;
            }
            case 19: {
                l2 = Long.MIN_VALUE;
                l3 = Long.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid 'valueType' for this constructor: " + n);
            }
        }
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException("Invalid 'value' for specified type: " + l);
        }
        this.valueType = n;
        this.longValue = l;
    }

    public DataElement(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 32: 
            case 64: {
                bl = object instanceof String;
                break;
            }
            case 24: {
                bl = object instanceof UUID;
                break;
            }
            case 12: 
            case 20: {
                bl = object instanceof byte[] && ((byte[])object).length == 16;
                break;
            }
            case 11: {
                bl = object instanceof byte[] && ((byte[])object).length == 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid 'valueType' for this constructor: " + n);
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid 'value' for specified type: " + object);
        }
        this.valueType = n;
        this.miscValue = object;
    }

    public synchronized void addElement(DataElement dataElement) {
        if (this.valueType != 48 && this.valueType != 56) {
            throw new ClassCastException("Invalid element type for this method: " + this.valueType);
        }
        if (dataElement == null) {
            throw new NullPointerException("Specified element is null");
        }
        ((Vector)this.miscValue).addElement(dataElement);
    }

    public synchronized void insertElementAt(DataElement dataElement, int n) {
        if (this.valueType != 48 && this.valueType != 56) {
            throw new ClassCastException("Invalid element type for this method: " + this.valueType);
        }
        if (dataElement == null) {
            throw new NullPointerException("Specified element is null");
        }
        if (n < 0 || n > ((Vector)this.miscValue).size()) {
            throw new IndexOutOfBoundsException("Specified index is out of range");
        }
        ((Vector)this.miscValue).insertElementAt(dataElement, n);
    }

    public synchronized int getSize() {
        if (this.valueType != 48 && this.valueType != 56) {
            throw new ClassCastException("Invalid element type for this method: " + this.valueType);
        }
        return ((Vector)this.miscValue).size();
    }

    public boolean removeElement(DataElement dataElement) {
        if (this.valueType != 48 && this.valueType != 56) {
            throw new ClassCastException("Invalid element type for this method: " + this.valueType);
        }
        if (dataElement == null) {
            throw new NullPointerException("Specified element is null");
        }
        return ((Vector)this.miscValue).removeElement(dataElement);
    }

    public int getDataType() {
        return this.valueType;
    }

    public long getLong() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                throw new ClassCastException("Invalid element type for this method: " + this.valueType);
            }
        }
        return this.longValue;
    }

    public boolean getBoolean() {
        if (this.valueType != 40) {
            throw new ClassCastException("Invalid element type for this method: " + this.valueType);
        }
        return this.booleanValue;
    }

    public synchronized Object getValue() {
        Object object = this.miscValue;
        switch (this.valueType) {
            case 24: 
            case 32: 
            case 64: {
                break;
            }
            case 48: 
            case 56: {
                object = ((Vector)this.miscValue).elements();
                break;
            }
            case 11: 
            case 12: 
            case 20: {
                int n = ((byte[])this.miscValue).length;
                object = new byte[n];
                System.arraycopy(this.miscValue, 0, object, 0, n);
                break;
            }
            default: {
                throw new ClassCastException("Invalid element type for this method: " + this.valueType);
            }
        }
        return object;
    }
}

