/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.KeyboardHandler;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;

public class SoftButtonManager {
    private static final Debug debug = Debug.create((Class)SoftButtonManager.class);
    private static SoftButtonManager instance = new SoftButtonManager();
    private final int[] softButtonKeys = this.getSoftKeys();

    private SoftButtonManager() {
    }

    public static SoftButtonManager getInstance() {
        return instance;
    }

    public int getKeyForIndex(int n) {
        try {
            return this.softButtonKeys[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
            throw new IllegalArgumentException("No such soft key: " + n);
        }
    }

    public int getIndexForKey(int n) {
        for (int i = 0; i < this.softButtonKeys.length; ++i) {
            if (this.softButtonKeys[i] != n) continue;
            return i;
        }
        throw new IllegalArgumentException("Not a soft key: " + n);
    }

    public boolean isSoftKey(int n) {
        for (int i = 0; i < this.softButtonKeys.length; ++i) {
            if (this.softButtonKeys[i] != n) continue;
            return true;
        }
        return false;
    }

    private int[] getSoftKeys() {
        int n = Screen.getInstance().getSoftButtonCount();
        int[] nArray = new int[n];
        KeyboardHandler keyboardHandler = KeyboardManager.getInstance().getKeyboardHandler();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = keyboardHandler.getKeyCode("SOFT" + (i + 1));
        }
        return nArray;
    }
}

