/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.ColorModelFactory;
import com.sun.kvem.Device;
import com.sun.kvem.Icon;
import com.sun.kvem.IconTable;
import com.sun.kvem.KVMBridge;
import com.sun.kvem.KVMDeviceInterface;
import com.sun.kvem.ObservableGraphics;
import com.sun.kvem.Screen;
import com.sun.kvem.ScreenUpdatePolicy;
import com.sun.kvem.SoftButton;
import com.sun.kvem.environment.Debug;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ScreenImpl
extends Screen {
    private static final Debug debug = Debug.create((Class)ScreenImpl.class);
    private Graphics2D graphics;
    private Graphics componentGraphics;
    private ObservableGraphics faceGraphics;
    private Graphics2D directFaceGraphics;
    private Rectangle faceBounds;
    private Rectangle displayBounds;
    private Rectangle scaledFaceBounds;
    private Rectangle displayBoundsInFace;
    private Dimension pixelSize;
    private Dimension facePixelSize;
    private BufferedImage bufferedFaceImage;
    private BufferedImage visibleFaceImage;
    private SoftButton[] softButtons;
    private IconTable icons;
    private final int scale = Device.getIntegerProperty("scale", 1);
    private boolean dirtyFace = true;
    private int primLatency = 0;
    private Color borderColor;
    ObservableGraphics.Observer latencyObserver = new ObservableGraphics.Observer(){

        public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
            if (ScreenImpl.this.primLatency == 0) {
                return;
            }
            try {
                Thread.sleep(ScreenImpl.this.primLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    ScreenImpl() {
    }

    protected void initialize() {
        this.faceBounds = new Rectangle(Device.getIntegerProperty("screen.x", 0), Device.getIntegerProperty("screen.y", 0), Device.getIntegerProperty("screen.width", 0), Device.getIntegerProperty("screen.height", 0));
        debug.println(1, "Face bounds are {0}", (Object)this.faceBounds);
        this.scaledFaceBounds = new Rectangle(this.faceBounds.x * this.scale, this.faceBounds.y * this.scale, this.faceBounds.width * this.scale, this.faceBounds.height * this.scale);
        this.displayBoundsInFace = new Rectangle(Device.getIntegerProperty("screenPaintableRegion.x", 0), Device.getIntegerProperty("screenPaintableRegion.y", 0), Device.getIntegerProperty("screenPaintableRegion.width", this.faceBounds.width), Device.getIntegerProperty("screenPaintableRegion.height", this.faceBounds.height));
        debug.println(1, "Display bounds (in face) are {0}", (Object)this.displayBoundsInFace);
        this.displayBounds = new Rectangle(this.displayBoundsInFace.x + this.faceBounds.x, this.displayBoundsInFace.y + this.faceBounds.y, this.displayBoundsInFace.width, this.displayBoundsInFace.height);
        this.pixelSize = new Dimension(Device.getIntegerProperty("screenPixelRatio.x", 1), Device.getIntegerProperty("screenPixelRatio.y", 1));
        this.facePixelSize = new Dimension(this.faceBounds.width / this.pixelSize.width, this.faceBounds.height / this.pixelSize.height);
        String string = Device.getProperty("screen.refresh.mode");
        if ("immidiate".equals(string)) {
            this.setScreenUpdatePolicy(new ImmediateDisplayUpdatePolicy());
        } else if ("periodic".equals(string)) {
            this.setScreenUpdatePolicy(new PeriodicFaceUpdatePolicy());
        } else {
            this.setScreenUpdatePolicy(new DefaultDisplayUpdatePolicy());
            Device.getProperties().put("screenDoubleBuffer", "true");
        }
        debug.println(1, "Update policy is {0}", (Object)this.getScreenUpdatePolicy().toString());
        int n = Device.getIntegerProperty("colorCount", 256);
        if (n < 2) {
            Debug.warning((String)"A device must support at least two colors");
            n = 2;
            Device.getProperties().put("colorCount", "2");
            Device.getProperties().put("isColor", "false");
        }
        debug.println(1, "{0} colors", n);
        boolean bl = Device.getBooleanProperty("isColor", false);
        String string2 = Device.getProperty("gamma", "1.0");
        float f = new Float(string2).floatValue();
        debug.println(1, "Gamma correction = {0}", (Object)string2);
        Color color = new Color(Device.getIntegerProperty("screenBGColor", 0xFFFFFF));
        this.borderColor = new Color(Device.getIntegerProperty("screenBorderColor", 0xFFFFFF));
        debug.println(1, "Background color = {0}", (Object)color);
        if (n >= 8 && n < 0x1000000 && (n & n - 1) == 0 && bl) {
            n = 0x1000000;
        }
        ColorModel colorModel = ColorModelFactory.createColorModel(n, bl, 1.0f, Color.white);
        ColorModel colorModel2 = ColorModelFactory.createColorModel(n, bl, f, color);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(this.facePixelSize.width, this.facePixelSize.height);
        this.visibleFaceImage = new BufferedImage(colorModel2, writableRaster, true, null);
        this.bufferedFaceImage = colorModel2 == colorModel ? this.visibleFaceImage : new BufferedImage(colorModel, writableRaster, true, null);
        this.directFaceGraphics = (Graphics2D)this.bufferedFaceImage.getGraphics();
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        if (!Device.getBooleanProperty("enableAlphaChannel", true)) {
            this.directFaceGraphics.setComposite(AlphaComposite.Src);
        }
        this.faceGraphics = new ObservableGraphics(this.directFaceGraphics);
        this.primLatency = Device.getIntegerProperty("screen.graphicsLatency", 0);
        if (this.primLatency > 0) {
            this.faceGraphics.addObserver(this.latencyObserver);
        }
        this.faceGraphics.addObserver((ObservableGraphics.Observer)((Object)this.getScreenUpdatePolicy()));
        this.graphics = (Graphics2D)this.faceGraphics.create(this.displayBoundsInFace.x / this.pixelSize.width, this.displayBoundsInFace.y / this.pixelSize.height, this.displayBoundsInFace.width / this.pixelSize.width, this.displayBoundsInFace.height / this.pixelSize.height);
        this.softButtons = SoftButton.createSoftButtons();
        this.icons = IconTable.create();
        this.faceGraphics.setColor(this.getFaceBackgroundColor());
        this.faceGraphics.fillRect(0, 0, this.faceBounds.width, this.faceBounds.height);
        this.drawFaceBorder();
        this.updateFace();
    }

    private void drawFaceBorder() {
        Object object;
        Object object2;
        Graphics2D graphics2D = this.directFaceGraphics;
        graphics2D.setColor(this.borderColor);
        if (this.displayBoundsInFace.y > 0) {
            graphics2D.fillRect(0, 0, this.faceBounds.width, this.displayBoundsInFace.y);
        }
        if (!this.isFullScreenMode()) {
            if (this.displayBoundsInFace.y + this.displayBoundsInFace.height < this.faceBounds.height) {
                graphics2D.fillRect(0, this.displayBoundsInFace.y + this.displayBoundsInFace.height, this.faceBounds.width, this.faceBounds.height - (this.displayBoundsInFace.y + this.displayBoundsInFace.height));
            }
            if (this.displayBoundsInFace.x > 0) {
                graphics2D.fillRect(0, this.displayBoundsInFace.y, this.displayBoundsInFace.x, this.displayBoundsInFace.height);
            }
            if (this.displayBoundsInFace.x + this.displayBoundsInFace.width < this.faceBounds.width) {
                graphics2D.fillRect(this.displayBoundsInFace.x + this.displayBoundsInFace.width, this.displayBoundsInFace.y, this.faceBounds.width - (this.displayBoundsInFace.x + this.displayBoundsInFace.width), this.displayBoundsInFace.height);
            }
            if (this.faceBounds.height - this.displayBoundsInFace.y - this.displayBoundsInFace.height > 3) {
                graphics2D.setColor(new Color(0x6A6A6A));
                graphics2D.drawLine(0, this.displayBoundsInFace.y + this.displayBoundsInFace.height, this.faceBounds.width, this.displayBoundsInFace.y + this.displayBoundsInFace.height);
                graphics2D.setColor(new Color(0xFFFFFF));
                graphics2D.drawLine(1, this.displayBoundsInFace.y + this.displayBoundsInFace.height + 1, this.faceBounds.width - 1, this.displayBoundsInFace.y + this.displayBoundsInFace.height + 1);
            }
            object2 = graphics2D.getClip();
            object = this.getFaceForegroundColor();
            for (int i = 0; i < this.softButtons.length; ++i) {
                this.softButtons[i].setBackground(this.borderColor);
                this.softButtons[i].setForeground((Color)object);
                this.softButtons[i].paint(graphics2D);
                graphics2D.setClip((Shape)object2);
            }
        }
        object2 = this.icons.icons();
        while (object2.hasMoreElements()) {
            object = (Icon)object2.nextElement();
            ((Icon)object).setBackground(this.borderColor);
            ((Icon)object).paint(graphics2D);
        }
    }

    public Graphics2D getDisplayGraphics() {
        return (Graphics2D)this.graphics.create();
    }

    public Graphics2D getFaceGraphics() {
        return (Graphics2D)this.faceGraphics.create();
    }

    public BufferedImage getFaceImage() {
        return this.bufferedFaceImage;
    }

    public Rectangle getFaceBoundsInImage() {
        return new Rectangle(this.faceBounds);
    }

    public Rectangle getFaceBoundsInComponent() {
        return new Rectangle(this.scaledFaceBounds);
    }

    public Dimension getFaceSize() {
        return new Dimension(this.facePixelSize);
    }

    public Rectangle getDisplayBoundsInFace() {
        return new Rectangle(this.displayBoundsInFace);
    }

    public void setSoftButtonLabel(int n, String string) {
        this.setSoftButtonLabel(n, string, null);
    }

    public void setSoftButtonLabel(int n, String string, String string2) {
        this.softButtons[n].setText(string, string2);
        Graphics2D graphics2D = this.getFaceGraphics();
        this.softButtons[n].paint(graphics2D);
        Rectangle rectangle = this.softButtons[n].getBounds();
        this.updateComponent(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getSoftButtonLabel(int n) {
        return this.softButtons[n].getText();
    }

    public int getSoftButtonCount() {
        return Device.getIntegerProperty("softbutton.count", 0);
    }

    public Dimension getDisplaySize() {
        return new Dimension(this.displayBounds.width / this.pixelSize.width, this.displayBounds.height / this.pixelSize.height);
    }

    public boolean isColor() {
        return Device.getBooleanProperty("isColor", false);
    }

    public int getColorCount() {
        return Device.getIntegerProperty("colorCount", 256);
    }

    public void setVisible(boolean bl) {
        KVMDeviceInterface kVMDeviceInterface = KVMBridge.getBridge().getKVMDeviceInterface();
        if (bl) {
            kVMDeviceInterface.initializeWindowSystem();
        } else {
            kVMDeviceInterface.finalizeWindowSystem();
        }
    }

    public void setIconState(String string, String string2) {
        Icon icon = this.icons.getIcon(string);
        if (icon == null) {
            System.err.println("Warning: no icon named '" + string + "'");
            return;
        }
        icon.setState(string2, this.faceGraphics);
        Rectangle rectangle = icon.getBounds();
        this.updateComponent(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void updateDisplay(int n, int n2, int n3, int n4) {
        this.getScreenUpdatePolicy().updateFace(n + this.displayBoundsInFace.x / this.pixelSize.width, n2 + this.displayBoundsInFace.y / this.pixelSize.height, n3, n4);
    }

    public void updateDisplay() {
        this.getScreenUpdatePolicy().updateFace(this.displayBoundsInFace.x / this.pixelSize.width, this.displayBoundsInFace.y / this.pixelSize.height, this.displayBoundsInFace.width / this.pixelSize.width, this.displayBoundsInFace.height / this.pixelSize.height);
    }

    public void updateFace(int n, int n2, int n3, int n4) {
        this.getScreenUpdatePolicy().updateFace(n, n2 + this.displayBoundsInFace.y / this.pixelSize.height, n3, n4);
    }

    public void updateFace() {
        this.getScreenUpdatePolicy().updateFace(0, 0, this.facePixelSize.width, this.facePixelSize.height);
    }

    public int getGraphicsPrimLatency() {
        return this.primLatency;
    }

    public void setGraphicsPrimLatency(int n) {
        if (n >= 0) {
            this.primLatency = n;
        }
    }

    private void updateComponent(int n, int n2, int n3, int n4) {
        Graphics graphics;
        if (n3 < 0 || n4 < 0 || n + n3 < 0 || n2 + n4 < 0 || n >= this.facePixelSize.width || n2 >= this.facePixelSize.height) {
            return;
        }
        if (this.componentGraphics == null && (graphics = this.getComponent().getGraphics()) != null) {
            this.componentGraphics = graphics.create();
        }
        if (this.componentGraphics != null) {
            boolean bl;
            this.componentGraphics.setClip((this.faceBounds.x + (n *= this.pixelSize.width)) * this.scale, (this.faceBounds.y + (n2 *= this.pixelSize.height)) * this.scale, (n3 *= this.pixelSize.width) * this.scale, (n4 *= this.pixelSize.height) * this.scale);
            boolean bl2 = bl = n2 < this.displayBoundsInFace.y;
            if (!bl && !this.isFullScreenMode()) {
                boolean bl3 = bl = bl || n < this.displayBoundsInFace.x || n + n3 > this.displayBoundsInFace.x + this.displayBoundsInFace.width || n2 + n4 > this.displayBoundsInFace.y + this.displayBoundsInFace.height;
            }
            if (bl) {
                this.drawFaceBorder();
            }
            this.paint(this.componentGraphics);
        }
    }

    protected void paint(Graphics graphics) {
        graphics.drawImage(this.visibleFaceImage, this.faceBounds.x * this.scale, this.faceBounds.y * this.scale, (this.faceBounds.x + this.faceBounds.width) * this.scale, (this.faceBounds.y + this.displayBoundsInFace.y + this.faceBounds.height) * this.scale, 0, 0, this.facePixelSize.width, this.displayBoundsInFace.y / this.pixelSize.height + this.facePixelSize.height, null);
    }

    private void flushFace(int n, int n2, int n3, int n4) {
        this.setFaceDirty(true);
        this.updateFace(n, n2, n3, n4);
    }

    public void setFaceForegroundColor(Color color) {
        super.setFaceForegroundColor(color);
        this.updateFace();
    }

    public void setFaceBackgroundColor(Color color) {
        super.setFaceBackgroundColor(color);
        this.updateFace();
    }

    private synchronized boolean isFaceDirty() {
        return this.dirtyFace;
    }

    private synchronized void setFaceDirty(boolean bl) {
        this.dirtyFace = bl;
        if (debug.level(4)) {
            debug.println(4, "faceDirty := {0}", (Object)String.valueOf(bl));
        }
    }

    static /* synthetic */ Dimension access$600(ScreenImpl screenImpl) {
        return screenImpl.pixelSize;
    }

    public class PeriodicFaceUpdatePolicy
    implements ScreenUpdatePolicy,
    ObservableGraphics.Observer {
        private int faceRefreshRate;
        private int[] faceRefreshRateRange = new int[2];
        private int sleepTime;
        private final Rectangle updateClip = new Rectangle();

        public PeriodicFaceUpdatePolicy() {
            String string = Device.getProperty("screen.refresh.rateRange", "1,30");
            try {
                this.faceRefreshRateRange[0] = Integer.parseInt(string.substring(0, string.indexOf(44)).trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.faceRefreshRateRange[0] = 1;
            }
            try {
                this.faceRefreshRateRange[1] = Integer.parseInt(string.substring(string.indexOf(44) + 1, string.length()).trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.faceRefreshRateRange[1] = 30;
            }
            this.setFaceRefreshRate(Device.getIntegerProperty("screen.refresh.rate", this.faceRefreshRateRange[1]));
            new Thread(new Runnable(this){
                private final /* synthetic */ PeriodicFaceUpdatePolicy this$1;
                {
                    this.this$1 = periodicFaceUpdatePolicy;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(PeriodicFaceUpdatePolicy.access$300(this.this$1));
                                Rectangle rectangle = PeriodicFaceUpdatePolicy.access$400(this.this$1);
                                synchronized (rectangle) {
                                    if (PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).width > 0 && PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).height > 0) {
                                        ScreenImpl.access$100(PeriodicFaceUpdatePolicy.access$500(this.this$1), PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).x * ScreenImpl.access$600((ScreenImpl)PeriodicFaceUpdatePolicy.access$500((PeriodicFaceUpdatePolicy)this.this$1)).width, PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).y * ScreenImpl.access$600((ScreenImpl)PeriodicFaceUpdatePolicy.access$500((PeriodicFaceUpdatePolicy)this.this$1)).height, PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).width * ScreenImpl.access$600((ScreenImpl)PeriodicFaceUpdatePolicy.access$500((PeriodicFaceUpdatePolicy)this.this$1)).width, PeriodicFaceUpdatePolicy.access$400((PeriodicFaceUpdatePolicy)this.this$1).height * ScreenImpl.access$600((ScreenImpl)PeriodicFaceUpdatePolicy.access$500((PeriodicFaceUpdatePolicy)this.this$1)).height);
                                        PeriodicFaceUpdatePolicy.access$400(this.this$1).setBounds(0, 0, 0, 0);
                                        PeriodicFaceUpdatePolicy.access$400(this.this$1).notifyAll();
                                    }
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            ScreenImpl.access$700().exception(1, (Throwable)interruptedException);
                            continue;
                        }
                        break;
                    }
                }
            }, "Periodic Display Updater").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateFace(int n, int n2, int n3, int n4) {
            Rectangle rectangle = this.updateClip;
            synchronized (rectangle) {
                if (this.updateClip.width == 0 || this.updateClip.height == 0) {
                    this.updateClip.setBounds(n, n2, n3, n4);
                } else {
                    Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
                    this.updateClip.setBounds(this.updateClip.union(rectangle2));
                }
                try {
                    this.updateClip.wait();
                }
                catch (InterruptedException interruptedException) {
                    debug.exception(1, (Throwable)interruptedException);
                }
            }
        }

        public void updateFace() {
        }

        public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
        }

        public int[] getFaceRefreshRateRange() {
            return this.faceRefreshRateRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setFaceRefreshRate(int n) {
            if (n >= this.faceRefreshRateRange[0] && n <= this.faceRefreshRateRange[1]) {
                Rectangle rectangle = this.updateClip;
                synchronized (rectangle) {
                    this.faceRefreshRate = n;
                    this.sleepTime = 1000 / n;
                }
            }
            return this.faceRefreshRate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFaceRefreshRate() {
            int n;
            Rectangle rectangle = this.updateClip;
            synchronized (rectangle) {
                n = this.faceRefreshRate;
            }
            return n;
        }

        public String toString() {
            return "[PeriodicFaceUpdatePolicy, refresh rate = " + this.faceRefreshRate + "rateRange = (" + this.faceRefreshRateRange[0] + " - " + this.faceRefreshRateRange[1] + ")]";
        }

        static /* synthetic */ int access$300(PeriodicFaceUpdatePolicy periodicFaceUpdatePolicy) {
            return periodicFaceUpdatePolicy.sleepTime;
        }

        static /* synthetic */ Rectangle access$400(PeriodicFaceUpdatePolicy periodicFaceUpdatePolicy) {
            return periodicFaceUpdatePolicy.updateClip;
        }

        static /* synthetic */ ScreenImpl access$500(PeriodicFaceUpdatePolicy periodicFaceUpdatePolicy) {
            return periodicFaceUpdatePolicy.ScreenImpl.this;
        }
    }

    public class ImmediateDisplayUpdatePolicy
    implements ScreenUpdatePolicy,
    ObservableGraphics.Observer {
        public void updateFace(int n, int n2, int n3, int n4) {
        }

        public void updateFace() {
        }

        public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
            ScreenImpl.this.updateComponent(n, n2, n3, n4);
        }

        public String toString() {
            return "[ImmediateDisplayUpdatePolicy]";
        }
    }

    public class DefaultDisplayUpdatePolicy
    implements ScreenUpdatePolicy,
    ObservableGraphics.Observer {
        public synchronized void updateFace(int n, int n2, int n3, int n4) {
            ScreenImpl.this.updateComponent(n, n2, n3, n4);
        }

        public void updateFace() {
            ScreenImpl.this.updateComponent(0, 0, ((ScreenImpl)ScreenImpl.this).facePixelSize.width, ((ScreenImpl)ScreenImpl.this).facePixelSize.height);
        }

        public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
        }

        public String toString() {
            return "[DefaultDisplayUpdatePolicy]";
        }
    }
}

