/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.ScreenImpl;
import com.sun.kvem.ScreenUpdatePolicy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public abstract class Screen {
    private ScreenUpdatePolicy updatePolicy = new NoScreenUpdatePolicy();
    private static Screen instance;
    private static JComponent component;
    private Color foreground = Color.black;
    private Color background = Color.white;
    private boolean fullScreenMode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Screen getInstance() {
        if (instance == null) {
            Class clazz = Screen.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new ScreenImpl();
                    instance.initialize();
                }
            }
        }
        return instance;
    }

    static void setComponent(JComponent jComponent) {
        component = jComponent;
    }

    protected Screen() {
    }

    protected abstract void initialize();

    public abstract Graphics2D getDisplayGraphics();

    public abstract Graphics2D getFaceGraphics();

    public abstract BufferedImage getFaceImage();

    public abstract void setSoftButtonLabel(int var1, String var2);

    public abstract void setSoftButtonLabel(int var1, String var2, String var3);

    public abstract String getSoftButtonLabel(int var1);

    public abstract int getSoftButtonCount();

    public abstract Dimension getDisplaySize();

    public JComponent getComponent() {
        return component;
    }

    public abstract Rectangle getFaceBoundsInComponent();

    public abstract Dimension getFaceSize();

    public abstract Rectangle getDisplayBoundsInFace();

    public abstract boolean isColor();

    public abstract int getColorCount();

    public abstract void setVisible(boolean var1);

    public abstract void setIconState(String var1, String var2);

    public abstract void updateDisplay(int var1, int var2, int var3, int var4);

    public abstract void updateDisplay();

    public abstract void updateFace();

    public abstract void updateFace(int var1, int var2, int var3, int var4);

    protected abstract void paint(Graphics var1);

    public Color getFaceBackgroundColor() {
        return this.background;
    }

    public void setFaceBackgroundColor(Color color) {
        this.background = color;
    }

    public Color getFaceForegroundColor() {
        return this.foreground;
    }

    public void setFaceForegroundColor(Color color) {
        this.foreground = color;
    }

    public void setScreenUpdatePolicy(ScreenUpdatePolicy screenUpdatePolicy) {
        this.updatePolicy = screenUpdatePolicy;
        this.updateDisplay();
    }

    public ScreenUpdatePolicy getScreenUpdatePolicy() {
        return this.updatePolicy;
    }

    public int getGraphicsPrimLatency() {
        return 0;
    }

    public void setGraphicsPrimLatency(int n) {
    }

    public void setFullScreenMode(boolean bl) {
        this.fullScreenMode = bl;
    }

    protected boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    class NoScreenUpdatePolicy
    implements ScreenUpdatePolicy {
        NoScreenUpdatePolicy() {
        }

        public void updateFace(int n, int n2, int n3, int n4) {
        }

        public void updateFace() {
        }
    }
}

