/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class ObservableGraphics
extends Graphics2D {
    public Graphics2D g;
    ObserverList observers = new ObserverList();
    private int offsetX = 0;
    private int offsetY = 0;

    public ObservableGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    private void update(int n, int n2, int n3, int n4) {
        this.observers.update(this, n + this.offsetX, n2 + this.offsetY, n3, n4);
    }

    private void update(Shape shape) {
        this.update(shape.getBounds());
    }

    private void update(Rectangle rectangle) {
        this.update(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void updateFontArea(String string, int n, int n2) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getHeight();
        this.update(n, n2 - n3, n4, n5);
    }

    private void updateFontArea(char[] cArray, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.charsWidth(cArray, n, n2);
        int n7 = fontMetrics.getHeight();
        this.update(n3, n4 - n5, n6, n7);
    }

    public void addObserver(Observer observer) {
        this.observers.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.removeObserver(observer);
    }

    public void addRenderingHints(Map map) {
        this.g.addRenderingHints(map);
    }

    public void clip(Shape shape) {
        this.g.clip(shape);
    }

    public void draw(Shape shape) {
        this.g.draw(shape);
        this.update(shape);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.g.draw3DRect(n, n2, n3, n4, bl);
        this.update(n, n2, n3, n4);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.g.drawGlyphVector(glyphVector, f, f2);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.g.drawImage(image, affineTransform, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.g.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.g.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.g.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawString(String string, float f, float f2) {
        this.g.drawString(string, f, f2);
        this.updateFontArea(string, (int)f, (int)f2);
    }

    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2);
        this.updateFontArea(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.g.drawString(attributedCharacterIterator, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g.drawString(attributedCharacterIterator, n, n2);
    }

    public void fill(Shape shape) {
        this.g.fill(shape);
        this.update(shape);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.g.fill3DRect(n, n2, n3, n4, bl);
        this.update(n, n2, n3, n4);
    }

    public Color getBackground() {
        return this.g.getBackground();
    }

    public Composite getComposite() {
        return this.g.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    public Paint getPaint() {
        return this.g.getPaint();
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.g.getRenderingHints();
    }

    public Stroke getStroke() {
        return this.g.getStroke();
    }

    public AffineTransform getTransform() {
        return this.g.getTransform();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.g.hit(rectangle, shape, bl);
    }

    public void rotate(double d) {
        this.g.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.g.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.g.scale(d, d2);
    }

    public void setBackground(Color color) {
        this.g.setBackground(color);
    }

    public void setComposite(Composite composite) {
        this.g.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        this.g.setPaint(paint);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.g.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.g.setTransform(affineTransform);
    }

    public void shear(double d, double d2) {
        this.g.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.g.transform(affineTransform);
    }

    public void translate(double d, double d2) {
        this.g.translate(d, d2);
        this.offsetX += (int)d;
        this.offsetY += (int)d2;
    }

    public void translate(int n, int n2) {
        this.g.translate(n, n2);
        this.offsetX += n;
        this.offsetY += n2;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.g.clearRect(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        ObservableGraphics observableGraphics = new ObservableGraphics((Graphics2D)this.g.create());
        observableGraphics.observers = this.observers;
        observableGraphics.offsetX = this.offsetX;
        observableGraphics.offsetY = this.offsetY;
        return observableGraphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        ObservableGraphics observableGraphics = new ObservableGraphics((Graphics2D)this.g.create(n, n2, n3, n4));
        observableGraphics.observers = this.observers;
        observableGraphics.offsetX = this.offsetX + n;
        observableGraphics.offsetY = this.offsetY + n2;
        return observableGraphics;
    }

    public void dispose() {
        this.g.dispose();
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.g.drawChars(cArray, n, n2, n3, n4);
        this.updateFontArea(cArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        this.update(n, n2, n3 - n, n4 - n2);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        this.update(n, n2, n3 - n, n4 - n2);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, color, imageObserver);
        this.update(n, n2, n3 + 1, n4 + 1);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, imageObserver);
        this.update(n, n2, n3 + 1, n4 + 1);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, imageObserver);
        this.update(n, n2, image.getWidth(null), image.getHeight(null));
        return bl;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
        this.update(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void drawPolygon(Polygon polygon) {
        this.g.drawPolygon(polygon);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolyline(nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    public void fillPolygon(Polygon polygon) {
        this.g.fillPolygon(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
        this.update(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3, n4);
    }

    public void finalize() {
        super.finalize();
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.g.getClipBounds(rectangle);
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.g.hitClip(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public void setClip(Shape shape) {
        this.g.setClip(shape);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    public String toString() {
        return this.getClass().toString() + "[" + this.g.toString() + "]";
    }

    private static class ObserverList {
        Observer head;
        ObserverList tail;

        private ObserverList() {
        }

        void addObserver(Observer observer) {
            if (this.head == null) {
                this.head = observer;
            } else if (!this.head.equals(observer)) {
                if (this.tail == null) {
                    this.tail = new ObserverList();
                }
                this.tail.addObserver(observer);
            }
        }

        void removeObserver(Observer observer) {
            if (this.head != null && !this.head.equals(observer)) {
                this.tail.removeObserver(observer);
            }
        }

        void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
            if (this.head != null) {
                this.head.update(observableGraphics, n, n2, n3, n4);
                if (this.tail != null) {
                    this.tail.update(observableGraphics, n, n2, n3, n4);
                }
            }
        }
    }

    public static interface Observer {
        public void update(ObservableGraphics var1, int var2, int var3, int var4, int var5);
    }
}

