/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.KeyEventHandler;
import com.sun.kvem.KeyboardHandler;
import com.sun.kvem.environment.Debug;
import java.awt.event.InputEvent;

public class KeyboardManager
implements KeyEventHandler {
    private static final Debug debug = Debug.create((Class)KeyboardManager.class);
    public static KeyboardManager instance = new KeyboardManager();
    KeyboardHandler handler;

    protected KeyboardManager() {
    }

    public static KeyboardManager getInstance() {
        return instance;
    }

    public KeyboardHandler getKeyboardHandler() {
        return this.handler;
    }

    public void setKeyboardHandler(KeyboardHandler keyboardHandler) {
        this.handler = keyboardHandler;
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        debug.println(3, "Key {0} pressed", n);
        try {
            if (this.handler != null && n != Short.MIN_VALUE) {
                return this.handler.keyPressed(n, inputEvent);
            }
            return false;
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            return false;
        }
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        try {
            if (this.handler != null && n != Short.MIN_VALUE) {
                return this.handler.keyReleased(n, inputEvent);
            }
            return false;
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            return false;
        }
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        try {
            if (this.handler != null) {
                return this.handler.keyTyped(c, inputEvent);
            }
            return false;
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
            return false;
        }
    }

    static {
        String string = Device.getProperty("keyboard.handler", "com.sun.kvem.midp.QwertyKeyboardHandler");
        debug.println(1, "Loading keyboard handler\n  {0}", (Object)string);
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            KeyboardHandler keyboardHandler = (KeyboardHandler)obj;
            KeyboardManager.getInstance().setKeyboardHandler(keyboardHandler);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Keyboard handler class '" + string + "' not found");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access no-argument constructorfor keyboard handler class '" + string + "'");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate keyboard handler class '" + string + "'");
        }
        catch (ClassCastException classCastException) {
            System.err.println("Class '" + string + "' does not implement " + KeyboardHandler.class);
        }
    }
}

