/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.EMBitmapFont;
import com.sun.kvem.EMFont;
import com.sun.kvem.EMSystemFont;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import java.awt.Font;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FontManager {
    private static final Debug debug = Debug.create((Class)FontManager.class);
    private static FontManager instance = new FontManager();
    private Hashtable fonts = new Hashtable();
    private static final String fontKeyDefault = "default";
    private Vector fontList = new Vector();

    public static FontManager getInstance() {
        return instance;
    }

    private FontManager() {
    }

    private EMFont getFont(Object object) {
        return (EMFont)this.fonts.get(object);
    }

    private void putFont(Object object, EMFont eMFont) {
        this.fonts.put(object, eMFont);
    }

    public EMFont getBitmapFont(String string) throws IOException {
        Properties properties;
        string = "font." + string;
        String string2 = Device.getProperty(string);
        if (string2 == null) {
            string = "font.default";
            string2 = Device.getProperty(string);
        }
        EMFont eMFont = null;
        if (string2 == null) {
            Debug.warning((String)"No font definition found in device property file.");
        } else {
            eMFont = this.getFont(string2);
        }
        if (eMFont == null && (properties = Device.getPropertiesResource(string)) != null) {
            eMFont = new EMBitmapFont(properties, Screen.getInstance().getComponent());
            this.putFont(Device.getProperty(string), eMFont);
        }
        return eMFont;
    }

    private EMFont getSystemFont(String string) {
        string = "font." + string;
        String string2 = Device.getProperty(string, Device.getProperty("font.default"));
        EMFont eMFont = null;
        if (string2 == null) {
            Debug.warning((String)"No font definition found in device property file.");
        } else {
            eMFont = this.getFont(string2);
        }
        if (eMFont == null) {
            eMFont = new EMSystemFont(string2, Screen.getInstance().getComponent());
            this.putFont(string2, eMFont);
        }
        return eMFont;
    }

    private EMFont getSystemFont(Font font) {
        EMFont eMFont = this.getFont(font);
        if (eMFont == null) {
            eMFont = new EMSystemFont(font, Screen.getInstance().getComponent());
            this.putFont(font, eMFont);
        }
        return eMFont;
    }

    public int getSystemFontID(Font font) {
        EMFont eMFont = this.getSystemFont(font);
        return this.getFontID(eMFont);
    }

    public int getFontID(String string) {
        EMFont eMFont;
        try {
            eMFont = this.getBitmapFont(string);
        }
        catch (IOException iOException) {
            eMFont = this.getSystemFont(string);
        }
        return this.getFontID(eMFont);
    }

    private int getFontID(EMFont eMFont) {
        int n = this.fontList.indexOf(eMFont);
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.addElement(eMFont);
        }
        return n;
    }

    public EMFont getFont(int n) {
        return (EMFont)this.fontList.elementAt(n);
    }
}

