/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.EMFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class EMSystemFont
implements EMFont {
    private Font font;
    private FontMetrics fontMetrics;
    private int underlineHeight;
    private int underlineOffset;
    private boolean underlineOn = false;

    public EMSystemFont(String string, JComponent jComponent) {
        this(Font.decode(string), jComponent);
    }

    public EMSystemFont(Font font, JComponent jComponent) {
        this.font = font;
        this.fontMetrics = jComponent.getFontMetrics(font);
    }

    public void setUnderlineStyle(boolean bl, int n, int n2) {
        this.underlineHeight = n;
        this.underlineOffset = n2;
        this.underlineOn = bl;
    }

    public void setUnderlineStyle(boolean bl) {
        this.underlineOn = bl;
    }

    public int getAscent() {
        return this.fontMetrics.getAscent();
    }

    public int getHeight() {
        return this.fontMetrics.getHeight();
    }

    public int getDescent() {
        return this.fontMetrics.getDescent();
    }

    public int getLeading() {
        return this.fontMetrics.getLeading();
    }

    public int stringWidth(String string) {
        return this.fontMetrics.stringWidth(string);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.fontMetrics.charsWidth(cArray, n, n2);
    }

    public int charWidth(char c) {
        return this.fontMetrics.charWidth(c);
    }

    public Rectangle drawString(Graphics graphics, String string, int n, int n2) {
        int n3 = this.stringWidth(string);
        graphics.setFont(this.font);
        graphics.drawString(string, n, n2 + this.fontMetrics.getAscent());
        Rectangle rectangle = new Rectangle(n, n2, n3, this.getHeight());
        if (this.underlineOn) {
            graphics.fillRect(n, n2 + this.fontMetrics.getAscent() + this.underlineOffset, n3, this.underlineHeight);
            rectangle = rectangle.union(new Rectangle(n, n2 + this.getAscent() + this.underlineOffset, n3, this.underlineHeight));
        }
        return rectangle;
    }

    public Rectangle drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = this.charsWidth(cArray, n, n2);
        graphics.setFont(this.font);
        graphics.drawChars(cArray, n, n2, n3, n4 + this.fontMetrics.getAscent());
        Rectangle rectangle = new Rectangle(n3, n4, n5, this.getHeight());
        if (this.underlineOn) {
            graphics.fillRect(n3, n4 + this.fontMetrics.getAscent() + this.underlineOffset, n5, this.underlineHeight);
            rectangle = rectangle.union(new Rectangle(n3, n4 + this.getAscent() + this.underlineOffset, n5, this.underlineHeight));
        }
        return rectangle;
    }

    public Font getAwtFont() {
        return this.font;
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.font + "]";
    }
}

