/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.KeyCode;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class EMDevice
extends JPanel
implements KeyListener {
    private static final Debug debug = Debug.create((Class)EMDevice.class);
    private static final Cursor baseCursor = Cursor.getPredefinedCursor(0);
    private DeviceInput[] controls;
    private BufferedImage defaultSkin;
    private BufferedImage pressedSkin;
    private BufferedImage highlightedSkin;
    private Rectangle screenRegion = new Rectangle();
    private Point screenPixelRatio = new Point();
    private final int scale = Device.getIntegerProperty("scale", 1);
    private boolean active = false;
    private Image currentSkin;
    private Image indicatorImage;
    private int indicatorX;
    private int indicatorY;
    private int indicatorWidth;
    private int indicatorHeight;
    private boolean lastLightMode = false;
    private boolean lastNetworkIndicatorMode = false;
    private static final String MIDLET_SUSPEND_ALL_KEY = "midlet.SUSPEND_ALL";
    private static final String MIDLET_RESUME_ALL_KEY = "midlet.RESUME_ALL";
    private static final String MIDLET_SUSPEND_ALL_VALUE_DEFAULT = "VK_F6";
    private static final String MIDLET_RESUME_ALL_VALUE_DEFAULT = "VK_F7";
    private static final String MIDLET_SUSPEND_ALL_VALUE = Device.getProperty("midlet.SUSPEND_ALL", "VK_F6");
    private static final String MIDLET_RESUME_ALL_VALUE = Device.getProperty("midlet.RESUME_ALL", "VK_F7");

    public EMDevice() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        Object object4;
        MediaTracker mediaTracker = new MediaTracker(this);
        Screen.setComponent(this);
        URL uRL = Device.getResource("default_image");
        if (uRL == null) {
            throw new MissingResourceException(ToolkitResources.getString((String)"MISSING_PROPERTY"), "", "default_image");
        }
        try {
            object4 = Toolkit.getDefaultToolkit().getImage(uRL);
            mediaTracker.addImage((Image)object4, 0);
            mediaTracker.waitForID(0);
            n2 = ((Image)object4).getWidth(this);
            n = ((Image)object4).getHeight(this);
            this.defaultSkin = new BufferedImage(n2, n, 2);
            object3 = this.defaultSkin.createGraphics();
            ((Graphics)object3).drawImage((Image)object4, 0, 0, null);
        }
        catch (Exception exception) {
            Debug.warning((String)"Error in loading the default skin image");
            debug.exception(1, (Throwable)exception);
            throw new MissingResourceException(ToolkitResources.getString((String)"MISSING_PROPERTY"), "", "default_image");
        }
        object4 = Device.getResource("pressed_buttons_image");
        if (object4 == null) {
            this.pressedSkin = this.defaultSkin;
        } else {
            try {
                object3 = Toolkit.getDefaultToolkit().getImage((URL)object4);
                mediaTracker.addImage((Image)object3, 0);
                mediaTracker.waitForID(0);
                this.pressedSkin = new BufferedImage(n2, n, 2);
                object2 = this.pressedSkin.createGraphics();
                ((Graphics)object2).drawImage((Image)object3, 0, 0, null);
            }
            catch (Exception exception) {
                Debug.warning((String)"Error in loading the pressed skin image");
                debug.exception(1, (Throwable)exception);
                this.pressedSkin = this.defaultSkin;
            }
        }
        object3 = Device.getResource("highlighted_image");
        if (object3 == null) {
            this.highlightedSkin = this.defaultSkin;
        } else {
            try {
                object2 = Toolkit.getDefaultToolkit().getImage((URL)object3);
                mediaTracker.addImage((Image)object2, 0);
                mediaTracker.waitForID(0);
                this.highlightedSkin = new BufferedImage(n2, n, 2);
                object = this.highlightedSkin.createGraphics();
                ((Graphics)object).drawImage((Image)object2, 0, 0, null);
            }
            catch (Exception exception) {
                Debug.warning((String)"Error in loading the highlighted skin image");
                debug.exception(1, (Throwable)exception);
                this.highlightedSkin = this.defaultSkin;
            }
        }
        object2 = Device.getResource("netindicator.image");
        this.indicatorImage = object2 == null ? null : this.getToolkit().createImage((URL)object2);
        try {
            object = new MediaTracker(this);
            ((MediaTracker)object).addImage(this.defaultSkin, 0);
            if (this.pressedSkin != this.defaultSkin) {
                ((MediaTracker)object).addImage(this.pressedSkin, 0);
            }
            if (this.highlightedSkin != this.defaultSkin) {
                ((MediaTracker)object).addImage(this.highlightedSkin, 0);
            }
            if (this.indicatorImage != null) {
                ((MediaTracker)object).addImage(this.indicatorImage, 0);
            }
            ((MediaTracker)object).waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.currentSkin = this.defaultSkin;
        object = Device.getProperty("netindicator.bounds");
        if (object != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
            try {
                if (stringTokenizer.hasMoreTokens()) {
                    this.indicatorX = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.indicatorY = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.indicatorWidth = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.indicatorHeight = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.indicatorImage = null;
                    Debug.warning((String)"Error in network indicator location value");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.indicatorImage = null;
                Debug.warning((String)"Error in network indicator location value");
                debug.exception(1, (Throwable)numberFormatException);
            }
        } else if (this.indicatorImage != null) {
            this.indicatorImage = null;
            Debug.warning((String)"Missing network indicator coordinates");
        }
        this.controls = DeviceInput.Builder.createInputs(this, Device.getProperties());
        this.enableEvents(56L);
        this.screenPixelRatio = new Point(Device.getIntegerProperty("screenPixelRatio.x", 1), Device.getIntegerProperty("screenPixelRatio.y", 1));
        this.screenRegion = Screen.getInstance().getFaceBoundsInComponent();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.checkCursor(mouseEvent.getX() / this.scale, mouseEvent.getY() / this.scale);
        this.delegateMouseEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.delegateMouseEvent(mouseEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.delegateKeyEvent(keyEvent);
        }
    }

    private void delegateMouseEvent(MouseEvent mouseEvent) {
        if (this.isActive()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (int i = 0; i < this.controls.length && !this.controls[i].accept(mouseEvent, n / this.scale, n2 / this.scale); ++i) {
            }
        }
    }

    private void delegateKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == KeyCode.decode(MIDLET_RESUME_ALL_VALUE)) {
            this.setActive(true);
        }
        if (this.isActive()) {
            debug.println(2, "Key {0} pressed", (int)keyEvent.getKeyChar());
            for (int i = 0; i < this.controls.length; ++i) {
                if (!this.controls[i].accept(keyEvent)) continue;
                return;
            }
            if (keyEvent.getID() == 401) {
                if (keyEvent.getKeyCode() == KeyCode.decode(MIDLET_SUSPEND_ALL_VALUE)) {
                    DeviceEventManager.getInstance().getEventDispatcher().keyPressed(KeyboardManager.getInstance().getKeyboardHandler().getKeyCode("SUSPEND"), keyEvent);
                    this.setActive(false);
                    return;
                }
                if (keyEvent.getKeyCode() == KeyCode.decode(MIDLET_RESUME_ALL_VALUE)) {
                    DeviceEventManager.getInstance().getEventDispatcher().keyPressed(KeyboardManager.getInstance().getKeyboardHandler().getKeyCode("RESUME"), keyEvent);
                    return;
                }
                debug.println(2, "Key {0} pressed", Short.MIN_VALUE);
                DeviceEventManager.getInstance().getEventDispatcher().keyPressed(Short.MIN_VALUE, keyEvent);
            } else if (keyEvent.getID() == 402) {
                debug.println(2, "Key {0} released", (int)keyEvent.getKeyChar());
                DeviceEventManager.getInstance().getEventDispatcher().keyReleased(Short.MIN_VALUE, keyEvent);
            } else if (keyEvent.getID() == 400) {
                debug.println(2, "Key {0} typed", (int)keyEvent.getKeyChar());
                DeviceEventManager.getInstance().getEventDispatcher().keyTyped(keyEvent.getKeyChar(), keyEvent);
            }
        }
    }

    private void checkCursor(int n, int n2) {
        if (this.isActive()) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (!this.controls[i].inActiveRegion(n, n2)) continue;
                this.setCursor(this.controls[i].getActiveCursor());
                return;
            }
        }
        this.setCursor(baseCursor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.defaultSkin.getWidth(this) * this.scale, this.defaultSkin.getHeight(this) * this.scale);
    }

    private void drawSkin(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        graphics.drawImage(image, n, n2, n + n3, n2 + n4, n / this.scale, n2 / this.scale, (n + n3) / this.scale, (n2 + n4) / this.scale, null);
    }

    public void repaintNow(int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        graphics.setClip(n * this.scale, n2 * this.scale, n3 * this.scale, n4 * this.scale);
        this.paint(graphics);
        graphics.dispose();
    }

    public void repaintNow(Shape shape) {
        Graphics graphics = this.getGraphics();
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            graphics.setClip(rectangle.x * this.scale, rectangle.y * this.scale, rectangle.width * this.scale, rectangle.height * this.scale);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            int[] nArray3 = new int[nArray.length];
            int[] nArray4 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray3[i] = nArray[i] * this.scale;
                nArray4[i] = nArray2[i] * this.scale;
            }
            graphics.setClip(new Polygon(nArray3, nArray4, nArray.length));
        }
        this.paint(graphics);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        debug.println(3, "Clipping area {0}", (Object)rectangle);
        if (rectangle.x < this.screenRegion.x || rectangle.y < this.screenRegion.y || rectangle.x + rectangle.width > this.screenRegion.x + this.screenRegion.width || rectangle.y + rectangle.height > this.screenRegion.y + this.screenRegion.height) {
            int n = this.screenRegion.x + this.screenRegion.width;
            int n2 = this.screenRegion.y + this.screenRegion.height;
            debug.println(3, "Redrawing screen border");
            this.drawSkin(graphics, this.currentSkin, rectangle.x, rectangle.y, rectangle.width, this.screenRegion.y - rectangle.y);
            this.drawSkin(graphics, this.currentSkin, rectangle.x, n2, rectangle.width, rectangle.y + rectangle.height - n2);
            this.drawSkin(graphics, this.currentSkin, rectangle.x, this.screenRegion.y, this.screenRegion.x - rectangle.x, this.screenRegion.height);
            this.drawSkin(graphics, this.currentSkin, n, this.screenRegion.y, rectangle.x + rectangle.width - n, this.screenRegion.height);
            if (this.indicatorImage != null && this.lastNetworkIndicatorMode) {
                graphics.drawImage(this.indicatorImage, this.indicatorX * this.scale, this.indicatorY * this.scale, this.indicatorWidth * this.scale, this.indicatorHeight * this.scale, this);
            }
            debug.println(3, "Redrawing input controls");
            for (int i = 0; i < this.controls.length; ++i) {
                this.controls[i].paint(graphics);
            }
        }
        Screen.getInstance().paint(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Point getLocationInScreen(int n, int n2) {
        return new Point((n - this.screenRegion.x / this.scale) / this.screenPixelRatio.x, (n2 - this.screenRegion.y / this.scale) / this.screenPixelRatio.y);
    }

    public boolean isInScreen(int n, int n2) {
        return this.screenRegion.contains(n * this.scale, n2 * this.scale);
    }

    public Image getPressedImage() {
        return this.pressedSkin;
    }

    public Image getHighlightedImage() {
        return this.highlightedSkin;
    }

    public synchronized Image getCurrentSkinImage() {
        return this.currentSkin;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.delegateKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.delegateKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.delegateKeyEvent(keyEvent);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void setBacklight(boolean bl) {
        if (this.lastLightMode != bl) {
            this.lastLightMode = bl;
            this.currentSkin = bl ? this.highlightedSkin : this.defaultSkin;
            this.repaintNow(0, 0, this.defaultSkin.getWidth(this) * this.scale, this.defaultSkin.getHeight(this) * this.scale);
        }
    }

    public void setNetworkIndicator(boolean bl) {
        if (this.lastNetworkIndicatorMode != bl) {
            this.lastNetworkIndicatorMode = bl;
            this.repaintNow(this.indicatorX, this.indicatorY, this.indicatorWidth, this.indicatorHeight);
        }
    }
}

