/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.EMFont;
import com.sun.kvem.environment.DevicePropertyManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.util.Properties;
import javax.swing.JComponent;

public class EMBitmapFont
implements EMFont {
    private Image fontImage;
    private int[] fontCoords;
    private int fontHeight;
    private int fontAscent;
    private int fontDescent;
    private int fontLeading;
    private Renderer renderer = new Renderer();
    private int underlineHeight;
    private int underlineOffset;
    private boolean underlineOn = false;

    public EMBitmapFont(Properties properties, JComponent jComponent) {
        String string = properties.getProperty("font_image");
        URL uRL = DevicePropertyManager.getResource((Properties)properties, (String)string);
        this.fontImage = jComponent.getToolkit().getImage(uRL);
        jComponent.prepareImage(this.fontImage, null);
        this.fontCoords = new int[257];
        for (int i = 0; i < 257; ++i) {
            this.fontCoords[i] = Integer.parseInt(properties.getProperty("ascii_x-" + i));
        }
        this.fontHeight = Integer.parseInt(properties.getProperty("font_height"));
        this.fontAscent = Integer.parseInt(properties.getProperty("font_ascent"));
        this.fontDescent = Integer.parseInt(properties.getProperty("font_descent"));
        this.fontLeading = Integer.parseInt(properties.getProperty("font_leading"));
    }

    public void setUnderlineStyle(boolean bl, int n, int n2) {
        this.underlineHeight = n;
        this.underlineOffset = n2;
        this.underlineOn = bl;
    }

    public void setUnderlineStyle(boolean bl) {
        this.underlineOn = bl;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public int stringWidth(String string) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        return this.charsWidth(cArray, 0, cArray.length);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        if (cArray.length == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n4 = this.fontCoords[cArray[i] + '\u0001'] - this.fontCoords[cArray[i]];
            n3 += n4;
        }
        return n3;
    }

    public int charWidth(char c) {
        return this.fontCoords[c + '\u0001'] - this.fontCoords[c];
    }

    public int getAscent() {
        return this.fontAscent;
    }

    public int getDescent() {
        return this.fontDescent;
    }

    public int getLeading() {
        return this.fontLeading;
    }

    public Rectangle drawString(Graphics graphics, String string, int n, int n2) {
        int n3 = 0;
        int n4 = this.stringWidth(string);
        Color color = graphics.getColor();
        Rectangle rectangle = new Rectangle();
        this.renderer.render(graphics, string, n, n2, color, rectangle);
        if (this.underlineOn) {
            n3 = this.getAscent() + this.underlineOffset + this.underlineHeight;
            graphics.fillRect(n, n2 + this.getAscent() + this.underlineOffset, n4, this.underlineHeight);
            rectangle = rectangle.union(new Rectangle(n, n2 + this.getAscent() + this.underlineOffset, n4, this.underlineHeight));
        }
        return rectangle;
    }

    public Rectangle drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        return this.drawString(graphics, new String(cArray, n, n2), n3, n4);
    }

    private class Renderer {
        private WritableRaster raster;
        private Image lastImage;
        private Color lastColor;
        byte[] buffer = new byte[]{0, 0, 0, -1, 0, 0, 0, 0};

        private Renderer() {
        }

        private void init() {
            byte[] byArray = new byte[]{0, 0, 0, -1, -1, -1};
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, 0, false);
            BufferedImage bufferedImage = new BufferedImage(EMBitmapFont.this.fontCoords[256], EMBitmapFont.this.fontHeight, 13, indexColorModel);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, EMBitmapFont.this.fontCoords[256], EMBitmapFont.this.fontHeight);
            graphics.drawImage(EMBitmapFont.this.fontImage, 0, 0, null);
            graphics.dispose();
            this.raster = bufferedImage.getRaster();
        }

        synchronized void render(Graphics graphics, String string, int n, int n2, Color color, Rectangle rectangle) {
            if (string == null) {
                return;
            }
            if (this.raster == null) {
                this.init();
            }
            Image image = this.lastImage;
            if (!color.equals(this.lastColor)) {
                this.buffer[0] = (byte)color.getRed();
                this.buffer[1] = (byte)color.getGreen();
                this.buffer[2] = (byte)color.getBlue();
                IndexColorModel indexColorModel = new IndexColorModel(1, 2, this.buffer, 0, true);
                this.lastImage = image = new BufferedImage(indexColorModel, this.raster, false, null);
                this.lastColor = color;
            }
            int n3 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n4 = EMBitmapFont.this.fontCoords[c + '\u0001'] - EMBitmapFont.this.fontCoords[c];
                graphics.drawImage(image, n + n3, n2, n + n3 + n4, n2 + EMBitmapFont.this.fontHeight, EMBitmapFont.this.fontCoords[c], 0, EMBitmapFont.this.fontCoords[c + '\u0001'], EMBitmapFont.this.fontHeight, null);
                n3 += n4;
            }
            if (rectangle != null) {
                rectangle.setBounds(n, n2, n3, EMBitmapFont.this.fontHeight);
            }
        }
    }
}

