/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.DeviceEventListener;
import com.sun.kvem.KVMBridge;
import com.sun.kvem.environment.Debug;

public class DeviceEventManager {
    public static final int NO_KEY = Short.MIN_VALUE;
    private static DeviceEventManager instance = new DeviceEventManager();
    private static final Debug debug = Debug.create((Class)DeviceEventManager.class);
    private DeviceEventListener.List listeners = DeviceEventListener.List.Nil;
    private Queue queue = new Queue();

    private DeviceEventManager() {
    }

    public static DeviceEventManager getInstance() {
        return instance;
    }

    public void addListener(DeviceEventListener deviceEventListener) {
        this.listeners = this.listeners.cons(deviceEventListener);
    }

    public void removeListener(DeviceEventListener deviceEventListener) {
        this.listeners = this.listeners.without(deviceEventListener);
    }

    public DeviceEventListener getEventDispatcher() {
        return this.listeners;
    }

    public void queueEvent(Object object) {
        this.queue.queue(object);
        debug.println(3, "Queuing event {0}", object);
        KVMBridge.getBridge().incrementEventCount();
    }

    public Object dequeueEvent(long l) {
        Object object = this.queue.dequeue(l, true);
        if (object != null) {
            debug.println(3, "Serving event {0}", object);
        }
        return object;
    }

    public Object peekEvent(long l) {
        return this.queue.dequeue(l, false);
    }

    private static class Queue {
        int start = 0;
        int end = 0;
        int count = 0;
        Object[] buffer = new Object[4];

        private Queue() {
        }

        synchronized void queue(Object object) {
            if (this.count == this.buffer.length) {
                Object[] objectArray = new Object[this.buffer.length * 2];
                System.arraycopy(this.buffer, this.start, objectArray, 0, this.buffer.length - this.start);
                System.arraycopy(this.buffer, 0, objectArray, this.buffer.length - this.start, this.start);
                this.start = 0;
                this.end = this.buffer.length;
                this.buffer = objectArray;
            }
            this.buffer[this.end++] = object;
            this.end %= this.buffer.length;
            ++this.count;
            this.notifyAll();
        }

        synchronized Object dequeue(long l, boolean bl) {
            long l2 = System.currentTimeMillis();
            if (l <= 0L) {
                l = Long.MAX_VALUE;
            }
            while (this.count == 0 && l2 < l) {
                try {
                    this.wait(l - l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis();
            }
            if (this.count == 0) {
                return null;
            }
            Object object = this.buffer[this.start];
            if (bl) {
                ++this.start;
                this.start %= this.buffer.length;
                --this.count;
            }
            return object;
        }
    }
}

