/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import java.awt.event.InputEvent;

public interface DeviceEventListener {
    public void keyPressed(int var1, InputEvent var2);

    public void keyReleased(int var1, InputEvent var2);

    public void keyTyped(char var1, InputEvent var2);

    public void penDown(int var1, int var2);

    public void penUp(int var1, int var2);

    public void penMove(int var1, int var2);

    public static class List
    implements DeviceEventListener {
        private final DeviceEventListener head;
        private final List tail;
        static final List Nil = new List();

        private List() {
            this.head = null;
            this.tail = null;
        }

        private List(DeviceEventListener deviceEventListener, List list) {
            this.head = deviceEventListener;
            this.tail = list;
        }

        List cons(DeviceEventListener deviceEventListener) {
            return new List(deviceEventListener, this);
        }

        List without(DeviceEventListener deviceEventListener) {
            if (this == Nil) {
                return Nil;
            }
            if (this.head.equals(deviceEventListener)) {
                return this.tail;
            }
            return new List(this.head, this.tail.without(deviceEventListener));
        }

        public void keyPressed(int n, InputEvent inputEvent) {
            List list = this;
            while (list.head != null) {
                list.head.keyPressed(n, inputEvent);
                list = list.tail;
            }
        }

        public void keyReleased(int n, InputEvent inputEvent) {
            List list = this;
            while (list.head != null) {
                list.head.keyReleased(n, inputEvent);
                list = list.tail;
            }
        }

        public void keyTyped(char c, InputEvent inputEvent) {
            List list = this;
            while (list.head != null) {
                list.head.keyTyped(c, inputEvent);
                list = list.tail;
            }
        }

        public void penDown(int n, int n2) {
            List list = this;
            while (list.head != null) {
                list.head.penDown(n, n2);
                list = list.tail;
            }
        }

        public void penUp(int n, int n2) {
            List list = this;
            while (list.head != null) {
                list.head.penUp(n, n2);
                list = list.tail;
            }
        }

        public void penMove(int n, int n2) {
            List list = this;
            while (list.head != null) {
                list.head.penMove(n, n2);
                list = list.tail;
            }
        }
    }

    public static class Adapter
    implements DeviceEventListener {
        public void keyPressed(int n, InputEvent inputEvent) {
        }

        public void keyReleased(int n, InputEvent inputEvent) {
        }

        public void keyTyped(char c, InputEvent inputEvent) {
        }

        public void penDown(int n, int n2) {
        }

        public void penUp(int n, int n2) {
        }

        public void penMove(int n, int n2) {
        }
    }
}

