/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.DevicePropertyManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Device {
    public static final String KVM_EXECUTABLE_PATH = "kvm.executable.path";
    public static final String KVM_USE_LIBRARY = "kvm.use_library";
    public static final String BASE_IMAGE = "default_image";
    public static final String PRESSED_IMAGE = "pressed_buttons_image";
    public static final String HIGHLIGHTED_IMAGE = "highlighted_image";
    public static final String INDICATOR_ICON = "netindicator.image";
    public static final String INDICATOR_LOCATION = "netindicator.bounds";
    public static final String WEBEMUL_ENABLED = "kvem.webemulator";
    public static final String WEBEMUL_FRAME_ALIGNMENT = "kvem.webemulator.frame.alignment";
    public static final String WEBEMUL_FRAME_TITLE = "kvem.webemulator.frame.title";
    public static final String FACE_X = "screen.x";
    public static final String FACE_Y = "screen.y";
    public static final String FACE_WIDTH = "screen.width";
    public static final String FACE_HEIGHT = "screen.height";
    public static final String PIXEL_RATIO_X = "screenPixelRatio.x";
    public static final String PIXEL_RATIO_Y = "screenPixelRatio.y";
    public static final String COLOR_COUNT = "colorCount";
    public static final String COLOR = "isColor";
    public static final String BACKGROUND_COLOR = "screenBGColor";
    public static final String BORDER_COLOR = "screenBorderColor";
    public static final String GAMMA = "gamma";
    public static final String SCALE = "scale";
    public static final String DISPLAY_X = "screenPaintableRegion.x";
    public static final String DISPLAY_Y = "screenPaintableRegion.y";
    public static final String DISPLAY_WIDTH = "screenPaintableRegion.width";
    public static final String DISPLAY_HEIGHT = "screenPaintableRegion.height";
    public static final String DISPLAY_DOUBLEBUFFER = "screenDoubleBuffer";
    public static final String SCREEN_PRIMLATENCY = "screen.graphicsLatency";
    public static final String SCREEN_PRIMLATENCY_MAX = "screen.maxGraphicsLatency";
    public static final String DISPLAY_REFRESH_MODE = "screen.refresh.mode";
    public static final String DISPLAY_REFRESH_RATE = "screen.refresh.rate";
    public static final String DISPLAY_REFRESH_RATE_RANGE = "screen.refresh.rateRange";
    public static final String VM_SPEED_ENABLE = "vmspeed.enableEmulation";
    public static final String VM_SPEED = "vmspeed.bytecodespermilli";
    public static final String RMS_SPEED_ENABLE = "rmsspeed.enableEmulation";
    public static final String RMS_SPEED = "rmsspeed.bytecodespermilli";
    public static final String VM_SPEED_RANGE = "vmspeed.range";
    public static final String NETWORK_SPEED_ENABLE = "netspeed.enableSpeedEmulation";
    public static final String NETWORK_SPEED = "netspeed.bitpersecond";
    public static final String NETWORK_PRIMLATENCY_MAX = "netspeed.maxNetLatency";
    public static final String SOFT_BUTTON_COUNT = "softbutton.count";
    public static final String SOFT_BUTTON_PREFIX = "softbutton.";
    public static final String FONT_IMAGE = "font_image";
    public static final String FONT_ASCII_PREFIX = "ascii_x-";
    public static final String FONT_HEIGHT = "font_height";
    public static final String FONT_ASCENT = "font_ascent";
    public static final String FONT_DESCENT = "font_descent";
    public static final String FONT_LEADING = "font_leading";
    public static final String TOUCH_SCREEN = "touch_screen";
    public static final String FONT_PREFIX = "font.";
    public static final String FONT_SOFT_BUTTON = "softButton";
    public static final String FONT_UNDERLINE_WIDTH_SUF = ".underline.width";
    public static final String FONT_UNDERLINE_OFFSET_SUF = ".underline.offset";
    public static final String FONT_UNDERLINE_ENABLED_SUF = ".underline.enabled";
    public static final String ICON_PREFIX = "icon.";
    public static final String SUPPORTED_ENCODINGS = "microedition.encoding.supported";
    public static final String ENABLE_ALPHA_COMPOSITING = "enableAlphaChannel";
    public static final String[] netSpeedList = new String[]{"1200", "2400", "9600", "14400", "19200", "28800", "33600", "56000", "112000"};
    private static Properties properties = System.getProperties();
    private static final Debug debug = Debug.create((Class)Device.class);

    public static void setProperties(Properties properties) {
        Device.properties = properties;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String string) {
        return Device.getPropertyImpl(string, null);
    }

    private static String getPropertyNameFromIdentifier(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = string.startsWith("ProfileConfiguration.") ? "com.sun.kvem.environment.ProfileConfiguration" : (string.startsWith("Device.") ? "com.sun.kvem.Device" : string.substring(0, n));
        try {
            Class<?> clazz = Class.forName(string2);
            String string3 = string.substring(n + 1);
            Field field = clazz.getField(string3);
            int n2 = field.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isStatic(n2)) {
                return field.get(null).toString();
            }
            Debug.warning((String)("The identifier " + string + " is not public static."));
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.exception(1, (Throwable)classNotFoundException);
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            debug.exception(1, (Throwable)noSuchFieldException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(1, (Throwable)illegalAccessException);
            return null;
        }
    }

    public static String getPropertyByIdentifier(String string) {
        String string2 = Device.getPropertyNameFromIdentifier(string);
        if (string2 != null) {
            return Device.getProperty(string2);
        }
        return null;
    }

    public static String getProperty(String string, String string2) {
        return Device.getPropertyImpl(string, string2);
    }

    private static String getPropertyImpl(String string, String string2) {
        String string3 = System.getProperty(string, string2);
        return properties.getProperty(string, string3);
    }

    public static int getIntegerProperty(String string, int n) {
        String string2 = Device.getProperty(string);
        if (string2 == null || "".equals(string2)) {
            return n;
        }
        return Integer.decode(string2.trim());
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = Device.getProperty(string);
        if (string2 == null || "".equals(string2)) {
            return bl;
        }
        return Boolean.valueOf(string2.trim());
    }

    public static Enumeration propertyKeys(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            vector.addElement(string2);
        }
        return vector.elements();
    }

    public static URL getResource(String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            debug.println(2, "There is no property named {0} that identifies a resource", (Object)string);
            return null;
        }
        debug.println(2, "Looking for resource {0} identified by {1}", (Object)string2, (Object)string);
        return DevicePropertyManager.getResource((Properties)properties, (String)string2);
    }

    public static Properties getPropertiesResource(String string) throws IOException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return DevicePropertyManager.getPropertiesResource((Properties)properties, (String)string2);
    }
}

