/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.ButtonSoundImpl;
import com.sun.kvem.Decode;
import com.sun.kvem.Device;
import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.EMDevice;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.environment.Debug;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;

public class Button
implements DeviceInput {
    private static final Debug debug = Debug.create((Class)Button.class);
    private static final int scale = Device.getIntegerProperty("scale", 1);
    private ButtonSoundImpl beep;
    private String buttonName;
    private Properties properties;
    private static boolean activeStickyButton = false;
    private ButtonState state = ButtonState.DEFAULT;
    private ButtonState[] states = ButtonState.regularStates;
    private boolean pointerInRegion;
    private Shape activeRegion;
    private Shape displayedRegion;
    private int keyCode;
    private EMDevice device;
    private int[] keyTriggers;
    private int[] charTriggers;
    private boolean stickyButton = false;

    public Button(EMDevice eMDevice, String string, Properties properties) {
        this.properties = properties;
        this.device = eMDevice;
        if (string.startsWith("button_")) {
            String string2 = properties.getProperty(string);
            int[] nArray = null;
            try {
                nArray = Decode.parseIntList(string2, null);
                if (nArray.length == 4) {
                    this.activeRegion = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
                } else if (nArray.length > 4 && nArray.length % 2 == 0) {
                    int[] nArray2 = new int[nArray.length / 2];
                    int[] nArray3 = new int[nArray.length / 2];
                    int n = nArray.length / 2;
                    for (int i = 0; i < nArray.length; i += 2) {
                        nArray2[i / 2] = nArray[i];
                        nArray3[i / 2] = nArray[i + 1];
                    }
                    this.activeRegion = new Polygon(nArray2, nArray3, n);
                }
                this.displayedRegion = this.activeRegion;
                this.keyCode = nArray[4];
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
                System.err.println("Bad number definition in property file:");
                System.out.println("'" + string2 + "'");
            }
        } else if (string.startsWith("button.")) {
            if (string.startsWith("button.sticky.")) {
                this.buttonName = string.substring("button.sticky.".length());
                this.stickyButton = true;
            } else {
                this.buttonName = string.substring("button.".length());
            }
            String string3 = properties.getProperty(string);
            int[] nArray = null;
            try {
                nArray = Decode.parseIntList(string3, null);
                if (nArray.length == 4) {
                    this.activeRegion = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
                } else if (nArray.length > 4 && nArray.length % 2 == 0) {
                    int[] nArray4 = new int[nArray.length / 2];
                    int[] nArray5 = new int[nArray.length / 2];
                    int n = nArray.length / 2;
                    for (int i = 0; i < nArray.length; i += 2) {
                        nArray4[i / 2] = nArray[i];
                        nArray5[i / 2] = nArray[i + 1];
                    }
                    this.activeRegion = new Polygon(nArray4, nArray5, n);
                }
                this.displayedRegion = this.activeRegion;
                this.keyCode = KeyboardManager.getInstance().getKeyboardHandler().getKeyCode(this.buttonName);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
                System.err.println("Bad number definition in property file:");
                System.out.println("'" + string3 + "'");
            }
        }
    }

    private void keyPressed(InputEvent inputEvent) {
        DeviceEventManager.getInstance().getEventDispatcher().keyPressed(this.keyCode, inputEvent);
        if (this.beep == null) {
            this.beep = new ButtonSoundImpl(this.buttonName, this.properties);
        }
        this.beep.play("press");
    }

    private void keyReleased(InputEvent inputEvent) {
        DeviceEventManager.getInstance().getEventDispatcher().keyReleased(this.keyCode, inputEvent);
        if (this.beep == null) {
            this.beep = new ButtonSoundImpl(this.buttonName, this.properties);
        }
        this.beep.play("release");
    }

    private void setState(ButtonState buttonState) {
        this.state = buttonState;
        this.repaint();
    }

    private void setStates(ButtonState[] buttonStateArray) {
        this.states = buttonStateArray;
    }

    private ButtonState[] getStates() {
        return this.states;
    }

    private boolean getStickyButton() {
        return this.stickyButton;
    }

    private void setActiveStickyButton(boolean bl) {
        activeStickyButton = bl;
    }

    public void paint(Graphics graphics) {
        this.state.paint(this, graphics);
    }

    private void repaint() {
        this.device.repaintNow(this.displayedRegion);
    }

    public int getButtonID() {
        return this.keyCode;
    }

    private static int[] addInt(int[] nArray, int n) {
        if (nArray == null) {
            return new int[]{n};
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return nArray;
        }
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    public void addKeyCodeTrigger(int n) {
        this.keyTriggers = Button.addInt(this.keyTriggers, n);
    }

    public void addKeyCharTrigger(char c) {
        this.charTriggers = Button.addInt(this.charTriggers, c);
    }

    private static boolean containsTrigger(int[] nArray, int n) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public boolean inActiveRegion(int n, int n2) {
        return this.activeRegion.contains(n, n2);
    }

    public Cursor getActiveCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public boolean accept(KeyEvent keyEvent) {
        debug.println(3, "Event {0} received by {1}", (Object)keyEvent, (Object)this);
        return this.state.accept(this, keyEvent);
    }

    public boolean accept(MouseEvent mouseEvent, int n, int n2) {
        debug.println(4, "Event {0} received by {1}", (Object)mouseEvent, (Object)this);
        this.pointerInRegion = this.inActiveRegion(n, n2);
        return this.state.accept(this, mouseEvent);
    }

    private static String rect(Rectangle rectangle) {
        return "(" + rectangle.x + ", " + rectangle.y + ")" + ", " + rectangle.width + "x" + rectangle.height;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.keyCode + ", displayed at " + Button.rect(this.activeRegion.getBounds()) + ", state=" + this.state + "]";
    }

    private static class ArmedKeyState
    extends ArmedState {
        private ArmedKeyState() {
        }

        public boolean accept(Button button, MouseEvent mouseEvent) {
            return false;
        }

        public boolean accept(Button button, KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 402) {
                if (Button.containsTrigger(button.keyTriggers, n)) {
                    button.keyReleased(keyEvent);
                    if (button.pointerInRegion) {
                        button.setState(button.states[1]);
                    } else {
                        button.setState(button.states[0]);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class ArmedMouseState
    extends ArmedState {
        private ArmedMouseState() {
        }

        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 502: {
                    if (button.getStates() == stickyStates) {
                        return false;
                    }
                    button.keyReleased(mouseEvent);
                    if (button.pointerInRegion) {
                        button.setState(button.states[1]);
                    } else {
                        button.setState(button.states[0]);
                    }
                    return true;
                }
                case 503: 
                case 506: {
                    if (button.getStates() == stickyStates) {
                        return true;
                    }
                    if (button.pointerInRegion) break;
                    button.keyReleased(mouseEvent);
                    button.setState(button.states[0]);
                    return true;
                }
                case 501: {
                    if (!button.pointerInRegion) break;
                    button.keyPressed(mouseEvent);
                    button.setStates(ArmedMouseState.regularStates);
                    button.setActiveStickyButton(false);
                    button.setState(button.states[2]);
                    return true;
                }
            }
            return false;
        }

        public boolean accept(Button button, KeyEvent keyEvent) {
            return false;
        }
    }

    static abstract class ArmedState
    implements ButtonState {
        ArmedState() {
        }

        public void paint(Button button, Graphics graphics) {
            debug.println(3, "Drawing armed {0}", (Object)button);
            graphics = graphics.create();
            Rectangle rectangle = button.displayedRegion.getBounds();
            if (button.displayedRegion instanceof Rectangle) {
                Rectangle rectangle2 = (Rectangle)button.displayedRegion;
                graphics.setClip(rectangle2.x * scale, rectangle2.y * scale, rectangle2.width * scale, rectangle2.height * scale);
            } else if (button.displayedRegion instanceof Polygon) {
                Polygon polygon = (Polygon)button.displayedRegion;
                int[] nArray = polygon.xpoints;
                int[] nArray2 = polygon.ypoints;
                int[] nArray3 = new int[nArray.length];
                int[] nArray4 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray3[i] = nArray[i] * scale;
                    nArray4[i] = nArray2[i] * scale;
                }
                graphics.setClip(new Polygon(nArray3, nArray4, nArray.length));
            }
            graphics.drawImage(button.device.getPressedImage(), rectangle.x * scale, rectangle.y * scale, (rectangle.width + rectangle.x) * scale, (rectangle.height + rectangle.y) * scale, rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.height + rectangle.y, button.device);
        }

        public String toString() {
            return "ButtonState.ARMED";
        }
    }

    private static class HighlightedButtonState
    implements ButtonState {
        private HighlightedButtonState() {
        }

        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    return DEFAULT.accept(button, mouseEvent);
                }
                case 503: {
                    if (button.pointerInRegion) break;
                    button.setState(button.states[0]);
                }
            }
            return false;
        }

        public boolean accept(Button button, KeyEvent keyEvent) {
            return DEFAULT.accept(button, keyEvent);
        }

        public void paint(Button button, Graphics graphics) {
            graphics = graphics.create();
            debug.println(3, "Drawing highlighted {0}", (Object)button);
            Rectangle rectangle = button.displayedRegion.getBounds();
            if (button.displayedRegion instanceof Rectangle) {
                Rectangle rectangle2 = (Rectangle)button.displayedRegion;
                graphics.setClip(rectangle2.x * scale, rectangle2.y * scale, rectangle2.width * scale, rectangle2.height * scale);
            } else if (button.displayedRegion instanceof Polygon) {
                Polygon polygon = (Polygon)button.displayedRegion;
                int[] nArray = polygon.xpoints;
                int[] nArray2 = polygon.ypoints;
                int[] nArray3 = new int[nArray.length];
                int[] nArray4 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray3[i] = nArray[i] * scale;
                    nArray4[i] = nArray2[i] * scale;
                }
                graphics.setClip(new Polygon(nArray3, nArray4, nArray.length));
            }
            graphics.drawImage(button.device.getHighlightedImage(), rectangle.x * scale, rectangle.y * scale, (rectangle.width + rectangle.x) * scale, (rectangle.height + rectangle.y) * scale, rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.height + rectangle.y, button.device);
        }

        public String toString() {
            return "ButtonState.HIGHLIGHT";
        }
    }

    private static class DefaultButtonState
    implements ButtonState {
        private DefaultButtonState() {
        }

        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!button.pointerInRegion) break;
                    if (button.getStickyButton()) {
                        if (activeStickyButton) {
                            return false;
                        }
                        button.setStates(DefaultButtonState.stickyStates);
                        button.setActiveStickyButton(true);
                    }
                    button.keyPressed(mouseEvent);
                    button.setState(button.states[2]);
                    return true;
                }
                case 503: {
                    if (!button.pointerInRegion) break;
                    button.setState(button.states[1]);
                }
            }
            return false;
        }

        public boolean accept(Button button, KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 401) {
                if (Button.containsTrigger(button.keyTriggers, n)) {
                    button.keyPressed(keyEvent);
                    button.setState(button.states[3]);
                    return true;
                }
            }
            return false;
        }

        public void paint(Button button, Graphics graphics) {
        }

        public String toString() {
            return "ButtonState.DEFAULT";
        }
    }

    private static interface ButtonState {
        public static final ButtonState DEFAULT = new DefaultButtonState();
        public static final ButtonState HIGHLIGHTED = new HighlightedButtonState();
        public static final ButtonState ARMED_MOUSE = new ArmedMouseState();
        public static final ButtonState ARMED_KEY = new ArmedKeyState();
        public static final ButtonState[] regularStates = new ButtonState[]{DEFAULT, HIGHLIGHTED, ARMED_MOUSE, ARMED_KEY};
        public static final ButtonState[] stickyStates = new ButtonState[]{ARMED_MOUSE, ARMED_MOUSE, ARMED_MOUSE, ARMED_MOUSE};

        public boolean accept(Button var1, KeyEvent var2);

        public boolean accept(Button var1, MouseEvent var2);

        public void paint(Button var1, Graphics var2);
    }
}

