/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.irdaobex;

import com.sun.j2se.io.gcf.irdaobex.DeviceCache;
import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.Utilites;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

final class IRDAOBEXControl {
    private static final boolean DEBUG = false;
    private static final String cn = "IRDAOBEXControl";
    private static final String OBEX_IRDA_MAX_PACKET_LENGTH = "irdaobex.packetLength";
    private static final String OBEX_IRDA_DISCOVERY_TIMEOUT = "irdaobex.discoveryTimeout";
    private static final int DISCOVERING_RETRY_TIME = 50;
    private static final int MIN_PACKET_SIZE = 64;
    private static final int CACHE_SIZE = 10;
    private static final String COMMAND_REGISTER_DEVICE = "registerIrDADevice";
    private static final String COMMAND_REGISTER_SERVICE = "registerIrDAService";
    private static final String COMMAND_UNREGISTER_SERVICE = "unregisterIrDAService";
    private static final String COMMAND_GET_ADDRESSES = "getIrDADevicesAddresses";
    private static final String COMMAND_GET_CONNECTION = "getIrDAConnection";
    private static boolean isCreated;
    private JSR082Controller finalizerObj;
    private static boolean isInitialized;
    private String address = "unspecified";
    private int maxPacketLength;
    private int discoveryTimeout;
    private DeviceCache deviceCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRDAOBEXControl() {
        Class clazz = IRDAOBEXControl.class;
        synchronized (clazz) {
            if (isCreated) {
                throw new RuntimeException("IRDAOBEXControl is created already.");
            }
            isCreated = true;
        }
    }

    String getAddress() {
        return this.address;
    }

    int getMaximumPacketSize() {
        return this.maxPacketLength;
    }

    int getDiscoveryTimeout() {
        return this.discoveryTimeout;
    }

    synchronized void initialize() throws Exception {
        if (isInitialized) {
            throw new RuntimeException("IRDAOBEXControl is initialized already.");
        }
        try {
            String string = JSR082Controller.getDeviceInfo(1, 17);
            Hashtable hashtable = new Hashtable();
            Utilites.parseInfo(string, hashtable);
            this.extractFromProperties(hashtable);
            this.deviceCache = new DeviceCache(10);
            StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_DEVICE);
            stringBuffer.append('\n').append(this.address).append('\n');
            this.address = JSR082Controller.processCommand(1, stringBuffer.toString());
            this.finalizerObj = JSR082Controller.getInstance();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.toString());
        }
        isInitialized = true;
    }

    String[] findDevices(boolean bl) throws IOException {
        String[] stringArray = null;
        if (bl) {
            stringArray = this.discoverDevices();
            if (stringArray != null && this.deviceCache != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.deviceCache.addToCache(stringArray[i]);
                }
            }
        } else if (this.deviceCache != null) {
            stringArray = this.deviceCache.getCachedDevices();
        }
        return stringArray;
    }

    int[] getDevicePortsForConnection(String string, int n, String string2) throws IOException {
        int n2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_CONNECTION);
        stringBuffer.append('\n').append(string).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        stringBuffer.append(string2).append('\n');
        String string3 = JSR082Controller.processCommand(1, stringBuffer.toString());
        if (string3 == null) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        while (!bl) {
            object = string3;
            n2 = ((String)object).indexOf(44);
            if (n2 != -1) {
                object = ((String)object).substring(0, n2);
                string3 = string3.substring(n2 + 1);
            } else {
                bl = true;
            }
            try {
                Integer n3 = new Integer(Integer.parseInt((String)object));
                vector.addElement(n3);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Internal Error: unexpected port:" + (String)object);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new int[vector.size()];
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            object[n2] = (Integer)vector.elementAt(n2);
        }
        return object;
    }

    synchronized void registerIrDAObexService(int n, String string, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_REGISTER_SERVICE);
        stringBuffer.append('\n').append(this.address).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        stringBuffer.append(string).append('\n');
        stringBuffer.append(Integer.toString(n2)).append('\n');
        JSR082Controller.processCommand(1, stringBuffer.toString());
    }

    synchronized void unregisterIrDAObexService(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(COMMAND_UNREGISTER_SERVICE);
        stringBuffer.append('\n').append(this.address).append('\n');
        stringBuffer.append(Integer.toString(n)).append('\n');
        JSR082Controller.processCommand(1, stringBuffer.toString());
    }

    private String[] discoverDevices() throws IOException {
        long l = System.currentTimeMillis();
        String string = null;
        do {
            StringBuffer stringBuffer = new StringBuffer(COMMAND_GET_ADDRESSES);
            stringBuffer.append('\n').append(this.address).append('\n');
            string = JSR082Controller.processCommand(1, stringBuffer.toString());
            if (string != null) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - l < (long)this.discoveryTimeout) continue;
            throw new IOException("No devices in range.");
        } while (string == null);
        return Utilites.splitString(string, ',');
    }

    private void extractFromProperties(Hashtable hashtable) {
        this.maxPacketLength = Utilites.getIntProperty(cn, hashtable, OBEX_IRDA_MAX_PACKET_LENGTH, 64);
        this.discoveryTimeout = Utilites.getIntProperty(cn, hashtable, OBEX_IRDA_DISCOVERY_TIMEOUT, 0);
    }
}

