/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.btspp;

import com.sun.j2se.io.gcf.btspp.BTSPPConnection;
import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.ServiceRegistrationException;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTNetmonNotifier;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class BTSPPNotifier
extends BTNotifierBase
implements StreamConnectionNotifier,
BTNetmonNotifier {
    private static final boolean DEBUG = false;
    private static final String cn = "BTSPPNotifier";
    private Integer cid;
    public BTNetmonNotifier btNetmonNotifier = this;

    protected BTSPPNotifier(boolean bl) {
        this.isSystemUse = bl;
    }

    protected void initServerNotifier(JSR082Notifier jSR082Notifier, int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, BluetoothConnectionException {
        DataElement[] dataElementArray;
        int[] nArray;
        this.notif = jSR082Notifier;
        this.mode = n;
        this.master = bl;
        this.authorize = bl2;
        this.authenticate = bl3;
        this.encrypt = bl4;
        this.cid = IDAllocator.getID();
        this.control.registerBTSPPNotifier(this.cid, jSR082Notifier.getServerPort());
        DataElement dataElement = new DataElement(48);
        dataElement.addElement(new DataElement(24, this.serverUUID));
        dataElement.addElement(DE_SERIAL_PORT_UUID);
        DataElement dataElement2 = new DataElement(48);
        DataElement dataElement3 = new DataElement(48);
        dataElement3.addElement(DE_L2CAP_UUID);
        dataElement2.addElement(dataElement3);
        dataElement3 = new DataElement(48);
        dataElement3.addElement(DE_RFCOMM_UUID);
        dataElement3.addElement(new DataElement(8, this.cid.intValue()));
        dataElement2.addElement(dataElement3);
        if (this.isSystemUse) {
            dataElement3 = new DataElement(48);
            dataElement3.addElement(DE_OBEX_UUID);
            dataElement2.addElement(dataElement3);
        }
        if (string == null) {
            nArray = new int[]{1, 4};
            dataElementArray = new DataElement[]{dataElement, dataElement2};
        } else {
            DataElement dataElement4 = new DataElement(32, string);
            nArray = new int[]{1, 4, 256};
            dataElementArray = new DataElement[]{dataElement, dataElement2, dataElement4};
        }
        this.serRec = new ServiceRecordImpl(this, nArray, dataElementArray);
        this.protocolListMC = this.serRec.getAttributeValue(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamConnection acceptAndOpen() throws IOException {
        Object object;
        if (this.isClosed) {
            throw new IOException("Notifier is closed");
        }
        if (!this.control.isDeviceConnectable()) {
            throw new BluetoothStateException("Device is not connectable");
        }
        Object object2 = this.serRecLock;
        synchronized (object2) {
            try {
                if (this.serRec.getHandle() == -1) {
                    object = SDDBImpl.getSDDBInstance();
                    this.serRec.setHandle(SDDBImpl.getFreeID());
                    this.updateServiceRecord();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ServiceRegistrationException(illegalArgumentException.getMessage());
            }
        }
        while (true) {
            object2 = null;
            try {
                object2 = this.notif.acceptAndOpen();
            }
            catch (IOException iOException) {
                throw new IOException("Notifier is closed");
            }
            object = this.createBTSPPConnection();
            try {
                ((BTSPPConnection)object).initServerConnection((JSR082Connection)object2, this, this.mode, this.master, this.authorize, this.authenticate, this.encrypt);
            }
            catch (IOException iOException) {
                try {
                    ((JSR082Connection)object2).close();
                }
                catch (IOException iOException2) {}
                continue;
            }
            break;
        }
        return object;
    }

    protected BTSPPConnection createBTSPPConnection() throws IOException {
        return new BTSPPConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.notif;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        IDAllocator.freeID(this.cid);
        this.control.unregisterBTSPPNotifier(this.notif.getServerPort());
        object = SDDBImpl.getSDDBInstance();
        ((SDDBImpl)object).removeServiceRecord(this.serRec);
        this.serRec.removeHandle();
        this.notif.close();
    }

    public ServiceRecord getServiceRecord() {
        if (this.isClosed) {
            throw new IllegalArgumentException("notifier is closed");
        }
        return this.serRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord() {
        Object object = this.serRecLock;
        synchronized (object) {
            if (this.serRec.getHandle() == -1) {
                return;
            }
            ServiceRecordImpl serviceRecordImpl = BTSPPNotifier.copyRecord(this, this.serRec);
            BTSPPNotifier.checkRecord(serviceRecordImpl, this.protocolListMC);
            SDDBImpl sDDBImpl = SDDBImpl.getSDDBInstance();
            sDDBImpl.updateServiceRecord(serviceRecordImpl);
            this.btNetmonNotifier.netmonUpdate(serviceRecordImpl);
        }
    }

    public void netmonUpdate(ServiceRecord serviceRecord) {
    }

    private static class IDAllocator {
        private static Vector ids = new Vector(30);
        private static int busyCount;

        private IDAllocator() {
        }

        static synchronized Integer getID() throws IOException {
            if (busyCount == ids.size()) {
                throw new IOException("no free channels left");
            }
            return (Integer)ids.elementAt(busyCount++);
        }

        static synchronized void freeID(Integer n) {
            ids.removeElement(n);
            ids.addElement(n);
            --busyCount;
        }

        static {
            for (int i = 1; i <= 30; ++i) {
                ids.addElement(new Integer(i));
            }
        }
    }
}

