/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.btspp;

import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;

public class BTSPPConnection
extends BTConnectionBase
implements StreamConnection {
    private boolean isOpened;
    private boolean osOpened;
    private int objects = 1;

    protected BTSPPConnection() {
    }

    protected int clientConnectionGetTransportPort(String string, int n) throws IOException {
        int n2 = n;
        return this.control.getBTSPPNotifierPort(string, n2);
    }

    public final DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public final DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("connection closed");
        }
        if ((this.mode & 1) == 0) {
            throw new IOException("permission denied");
        }
        JSR082Connection jSR082Connection = this.conn;
        synchronized (jSR082Connection) {
            if (this.isOpened) {
                throw new IOException("no more input streams");
            }
            this.isOpened = true;
            ++this.objects;
        }
        return new SPPInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("connection closed");
        }
        if ((this.mode & 2) == 0) {
            throw new IOException("permission denied");
        }
        JSR082Connection jSR082Connection = this.conn;
        synchronized (jSR082Connection) {
            if (this.osOpened) {
                throw new IOException("no more output streams");
            }
            this.osOpened = true;
            ++this.objects;
        }
        return new SPPOutputStream();
    }

    protected void initServerConnection(JSR082Connection jSR082Connection, BTNotifierBase bTNotifierBase, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws BluetoothConnectionException, IOException {
        super.initServerConnection(jSR082Connection, bTNotifierBase, n, bl, bl2, bl3, bl4);
    }

    protected void write(byte[] byArray, int n, int n2) throws IOException {
        this.conn.write(byArray, n, n2);
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        return this.conn.read(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        JSR082Connection jSR082Connection = this.conn;
        synchronized (jSR082Connection) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            --this.objects;
            if (this.objects == 0) {
                this.finish();
            }
        }
    }

    private final class SPPOutputStream
    extends OutputStream {
        private boolean isClosed;

        SPPOutputStream() {
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n});
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.isClosed) {
                throw new IOException("stream closed");
            }
            BTSPPConnection.this.waitSecurityExchange();
            BTSPPConnection.this.write(byArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            JSR082Connection jSR082Connection = BTSPPConnection.this.conn;
            synchronized (jSR082Connection) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                BTSPPConnection.this.objects--;
                if (BTSPPConnection.this.objects == 0) {
                    BTSPPConnection.this.finish();
                }
            }
        }
    }

    private final class SPPInputStream
    extends InputStream {
        private boolean isClosed;

        SPPInputStream() {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.isClosed) {
                throw new IOException("stream closed");
            }
            BTSPPConnection.this.waitSecurityExchange();
            return BTSPPConnection.this.read(byArray, n, n2);
        }

        public int available() throws IOException {
            if (this.isClosed) {
                throw new IOException("stream closed");
            }
            return BTSPPConnection.this.conn.ready();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            JSR082Connection jSR082Connection = BTSPPConnection.this.conn;
            synchronized (jSR082Connection) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                BTSPPConnection.this.objects--;
                if (BTSPPConnection.this.objects == 0) {
                    BTSPPConnection.this.finish();
                }
            }
        }
    }
}

