/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.btl2cap;

import com.sun.j2se.io.ConnectionBaseInterface;
import com.sun.j2se.io.gcf.btl2cap.BTL2CAPConnection;
import com.sun.j2se.io.gcf.btl2cap.BTL2CAPNotifier;
import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothProtocolBase;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connection;

public class Protocol
extends BluetoothProtocolBase
implements ConnectionBaseInterface {
    private static final boolean DEBUG = false;
    private static final String cn = "btl2cap.Protocol";
    private static int free_psm = 4097;
    private static final UUID UUID_SDP = new UUID(1L);

    public Protocol() {
        super("btl2cap:");
    }

    protected BTConnectionBase createConnection() throws IOException {
        return new BTL2CAPConnection();
    }

    protected BTNotifierBase createNotifier() throws IOException {
        return new BTL2CAPNotifier(this.isSystemUse);
    }

    protected void setUUID(BTNotifierBase bTNotifierBase) {
        super.setUUID(bTNotifierBase);
        BTL2CAPNotifier bTL2CAPNotifier = (BTL2CAPNotifier)bTNotifierBase;
        bTL2CAPNotifier.psm = this.isSystemUse && bTL2CAPNotifier.getServerUUID().equals(UUID_SDP) ? 1 : Protocol.getNextPSM();
    }

    protected void getParameters(Hashtable hashtable, Connection connection, boolean bl) throws BluetoothConnectionException {
        super.getParameters(hashtable, connection, bl);
        int n = 0;
        int n2 = 0;
        if (hashtable != null) {
            n = this.extractPositiveInt("receivemtu", hashtable);
            n2 = this.extractPositiveInt("transmitmtu", hashtable);
        }
        if (n == 0) {
            n = Math.min(672, BTL2CAPConnection.MAX_RECEIVE_MTU);
        } else if (n < 48 || n > BTL2CAPConnection.MAX_RECEIVE_MTU) {
            throw new IllegalArgumentException("receiveMTU is out of range");
        }
        if (n2 != 0 && n2 > BTL2CAPConnection.MAX_RECEIVE_MTU) {
            throw new IllegalArgumentException("transmitMTU is out of range");
        }
        if (bl) {
            BTL2CAPNotifier bTL2CAPNotifier = (BTL2CAPNotifier)connection;
            bTL2CAPNotifier.receiveMTU = n;
            bTL2CAPNotifier.transmitMTU = n2;
        } else {
            BTL2CAPConnection bTL2CAPConnection = (BTL2CAPConnection)connection;
            bTL2CAPConnection.receiveMTU = n;
            bTL2CAPConnection.transmitMTU = n2;
        }
    }

    protected int getChannelOrPSM() {
        int n = 0;
        if (this.numberStr.length() != 4 || this.numberStr.indexOf(45) != -1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        try {
            n = Integer.parseInt(this.numberStr, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if ((n & 1) == 0 || (n & 0x100) != 0) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if (n < 4097 && !this.isSystemUse) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        return n;
    }

    private int extractPositiveInt(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.remove(string);
        if (string2 == null) {
            return 0;
        }
        if (string2.startsWith("-")) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        try {
            int n = Integer.parseInt(string2);
            if (n == 0) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.errorMsg);
        }
    }

    private static synchronized int getNextPSM() {
        int n = free_psm;
        free_psm += 2;
        free_psm = (free_psm + 256 >>> 9 << 9) + (free_psm & 0xFF);
        return n;
    }
}

