/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.btl2cap;

import com.sun.j2se.io.gcf.btl2cap.BTL2CAPConnection;
import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.BluetoothStateException;
import com.sun.kvem.bluetooth.DataElement;
import com.sun.kvem.bluetooth.L2CAPConnection;
import com.sun.kvem.bluetooth.L2CAPConnectionNotifier;
import com.sun.kvem.bluetooth.ServiceRecord;
import com.sun.kvem.bluetooth.ServiceRegistrationException;
import com.sun.kvem.bluetooth.UUID;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;

public class BTL2CAPNotifier
extends BTNotifierBase
implements L2CAPConnectionNotifier {
    int psm;
    int receiveMTU;
    int transmitMTU;
    private static final boolean DEBUG = false;
    private static final String cn = "BTL2CAPNotifier";

    protected BTL2CAPNotifier(boolean bl) {
        this.isSystemUse = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CAPConnection acceptAndOpen() throws IOException {
        Object object;
        Object object2;
        if (this.isClosed) {
            throw new IOException("Notifier is closed");
        }
        if (!this.control.isDeviceConnectable()) {
            throw new BluetoothStateException("Device is not connectable");
        }
        if (!this.isSystemUse) {
            object2 = this.serRecLock;
            synchronized (object2) {
                try {
                    if (this.serRec.getHandle() == -1) {
                        object = SDDBImpl.getSDDBInstance();
                        this.serRec.setHandle(SDDBImpl.getFreeID());
                        this.updateServiceRecord();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ServiceRegistrationException(illegalArgumentException.getMessage());
                }
            }
        }
        while (true) {
            object2 = null;
            try {
                object2 = this.notif.acceptAndOpen();
            }
            catch (IOException iOException) {
                throw new IOException("Notifier is closed");
            }
            object = this.createBTL2CAPConnection();
            try {
                ((BTL2CAPConnection)object).initServerConnection((JSR082Connection)object2, this, this.mode, this.master, this.authorize, this.authenticate, this.encrypt);
            }
            catch (IOException iOException) {
                try {
                    ((JSR082Connection)object2).close();
                }
                catch (IOException iOException2) {}
                continue;
            }
            break;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = BTL2CAPNotifier.class;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.control.unregisterBTL2CAPNotifier(this.notif.getServerPort());
        if (!this.isSystemUse) {
            object = SDDBImpl.getSDDBInstance();
            ((SDDBImpl)object).removeServiceRecord(this.serRec);
            this.serRec.removeHandle();
        }
        this.notif.close();
    }

    protected BTL2CAPConnection createBTL2CAPConnection() {
        return new BTL2CAPConnection();
    }

    protected void initServerNotifier(JSR082Notifier jSR082Notifier, int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, BluetoothConnectionException {
        DataElement[] dataElementArray;
        int[] nArray;
        this.notif = jSR082Notifier;
        this.mode = n;
        this.master = bl;
        this.authorize = bl2;
        this.authenticate = bl3;
        this.encrypt = bl4;
        this.control.registerBTL2CAPNotifier(this.psm, jSR082Notifier.getServerPort());
        if (this.isSystemUse) {
            return;
        }
        DataElement dataElement = new DataElement(48);
        DataElement dataElement2 = new DataElement(24, this.serverUUID);
        dataElement.addElement(dataElement2);
        DataElement dataElement3 = new DataElement(48);
        DataElement dataElement4 = new DataElement(48);
        dataElement4.addElement(DE_L2CAP_UUID);
        dataElement4.addElement(new DataElement(9, this.psm));
        dataElement3.addElement(dataElement4);
        if (string == null) {
            nArray = new int[]{1, 4};
            dataElementArray = new DataElement[]{dataElement, dataElement3};
        } else {
            DataElement dataElement5 = new DataElement(32, string);
            nArray = new int[]{1, 4, 256};
            dataElementArray = new DataElement[]{dataElement, dataElement3, dataElement5};
        }
        this.serRec = new ServiceRecordImpl(this, nArray, dataElementArray);
        this.protocolListMC = this.serRec.getAttributeValue(4);
    }

    public ServiceRecord getServiceRecord() {
        if (this.isClosed) {
            throw new IllegalArgumentException("notifier is closed");
        }
        return this.serRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord() {
        if (this.isSystemUse) {
            return;
        }
        Object object = this.serRecLock;
        synchronized (object) {
            if (this.serRec.getHandle() == -1) {
                return;
            }
            ServiceRecordImpl serviceRecordImpl = BTL2CAPNotifier.copyRecord(this, this.serRec);
            BTL2CAPNotifier.checkRecord(serviceRecordImpl, this.protocolListMC);
            SDDBImpl sDDBImpl = SDDBImpl.getSDDBInstance();
            sDDBImpl.updateServiceRecord(serviceRecordImpl);
            this.netmonUpdate(serviceRecordImpl);
        }
    }

    protected void netmonUpdate(ServiceRecord serviceRecord) {
    }

    UUID getServerUUID() {
        return this.serverUUID;
    }
}

