/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.btl2cap;

import com.sun.j2se.io.gcf.btl2cap.BTL2CAPNotifier;
import com.sun.kvem.bluetooth.BluetoothConnectionException;
import com.sun.kvem.bluetooth.L2CAPConnection;
import com.sun.kvem.bluetooth.LocalDevice;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import java.io.IOException;

public class BTL2CAPConnection
extends BTConnectionBase
implements L2CAPConnection {
    static final int MAX_RECEIVE_MTU;
    int receiveMTU;
    int transmitMTU;
    private static final boolean DEBUG = false;
    private static final String cn = "BTL2CAPConnection";
    private static final byte[] skipData;

    protected BTL2CAPConnection() {
    }

    public final int getReceiveMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.receiveMTU;
    }

    public final int getTransmitMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.transmitMTU;
    }

    public void send(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        if (byArray == null) {
            throw new NullPointerException("null data.");
        }
        int n = byArray.length < this.transmitMTU ? byArray.length : this.transmitMTU;
        this.waitSecurityExchange();
        this.sendInt(n);
        this.conn.write(byArray, 0, n);
    }

    public int receive(byte[] byArray) throws IOException {
        int n;
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        if (byArray == null) {
            throw new NullPointerException("null inBuf.");
        }
        int n2 = this.receiveInt();
        int n3 = byArray.length < n2 ? byArray.length : n2;
        this.waitSecurityExchange();
        this.readFully(byArray, n3);
        for (int i = byArray.length < n2 ? n2 - byArray.length : 0; i != 0; i -= n) {
            n = i < skipData.length ? i : skipData.length;
            this.readFully(skipData, n);
        }
        return n3;
    }

    public boolean ready() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.conn.ready() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Class clazz = BTL2CAPConnection.class;
        synchronized (clazz) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.finish();
    }

    protected void initClientConnection(JSR082Connection jSR082Connection, int n, boolean bl, boolean bl2, boolean bl3) throws BluetoothConnectionException, IOException {
        this.conn = jSR082Connection;
        this.negotiateReceiveMTU();
        this.negotiateTransmitMTU();
        super.initClientConnection(jSR082Connection, n, bl, bl2, bl3);
    }

    protected void initServerConnection(JSR082Connection jSR082Connection, BTNotifierBase bTNotifierBase, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws BluetoothConnectionException, IOException {
        this.conn = jSR082Connection;
        BTL2CAPNotifier bTL2CAPNotifier = (BTL2CAPNotifier)bTNotifierBase;
        this.receiveMTU = bTL2CAPNotifier.receiveMTU;
        this.transmitMTU = bTL2CAPNotifier.transmitMTU;
        this.negotiateTransmitMTU();
        this.negotiateReceiveMTU();
        super.initServerConnection(jSR082Connection, bTNotifierBase, n, bl, bl2, bl3, bl4);
    }

    protected void negotiateReceiveMTU() throws IOException {
        this.sendInt(this.receiveMTU);
        if (this.receiveInt() == 0) {
            throw new BluetoothConnectionException(6, "Can't negotiate receiveMTU: " + this.receiveMTU);
        }
    }

    protected void negotiateTransmitMTU() throws IOException {
        int n = this.receiveInt();
        if (this.transmitMTU > n) {
            this.sendInt(0);
            throw new BluetoothConnectionException(6, "Can't negotiate transmitMTU: " + this.transmitMTU);
        }
        this.sendInt(1);
        if (this.transmitMTU == 0) {
            this.transmitMTU = Math.min(MAX_RECEIVE_MTU, n);
        }
    }

    protected int clientConnectionGetTransportPort(String string, int n) throws IOException {
        int n2 = n;
        return this.control.getBTL2CAPNotifierPort(string, n2);
    }

    private void sendInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        this.conn.write(byArray);
    }

    private int receiveInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray, byArray.length);
        int n = (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        return n |= byArray[3] & 0xFF;
    }

    private void readFully(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n != 0) {
            int n3 = this.conn.read(byArray, n2, n);
            if (n3 == -1) {
                throw new IOException("Connection is closed");
            }
            n2 += n3;
            n -= n3;
        }
    }

    static {
        int n;
        skipData = new byte[672];
        try {
            n = Integer.parseInt(LocalDevice.getProperty("bluetooth.l2cap.receiveMTU.max"));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Internal error: BTL2CAPBase: improper receiveMTU.max value");
            n = 672;
        }
        MAX_RECEIVE_MTU = n;
    }
}

