/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.SkinnedMesh;

public abstract class Object3D {
    int swerveHandle;
    Object uo = null;
    boolean ii = false;

    Object3D() {
    }

    Object3D(int handle) {
        this.swerveHandle = handle;
    }

    public native int getUserID();

    public native int getAnimationTrackCount();

    public native void setUserID(int var1);

    public AnimationTrack getAnimationTrack(int index) {
        AnimationTrack __res = (AnimationTrack)Engine.instantiateJavaPeer(this.getAnimationTrackImpl(index));
        return __res;
    }

    private native int getAnimationTrackImpl(int var1);

    public void addAnimationTrack(AnimationTrack animationTrack) {
        this.addAnimationTrackImpl(animationTrack);
        Engine.addXOT(animationTrack);
    }

    private native void addAnimationTrackImpl(AnimationTrack var1);

    public native void removeAnimationTrack(AnimationTrack var1);

    public final native int animate(int var1);

    public Object3D find(int userID) {
        Object3D __res = (Object3D)Engine.instantiateJavaPeer(this.findImpl(userID));
        return __res;
    }

    private native int findImpl(int var1);

    private native int getReferencesImpl(int[] var1);

    public int getReferences(Object3D[] references) {
        int cReferences = this.getReferencesImpl(null);
        if (references == null) {
            return cReferences;
        }
        if (references.length < cReferences) {
            throw new IllegalArgumentException();
        }
        int[] handles = new int[references.length];
        int len = this.getReferencesImpl(handles);
        if (len > cReferences) {
            len = cReferences;
        }
        for (int i = 0; i < len; ++i) {
            references[i] = (Object3D)Engine.instantiateJavaPeer(handles[i]);
        }
        return len;
    }

    native void removeUserParameters();

    native int getUserParameterID(int var1);

    native int getUserParameterValue(int var1, byte[] var2);

    private native int duplicateImpl();

    public final Object3D duplicate() {
        Object3D duplicate = (Object3D)Engine.instantiateJavaPeer(this.duplicateImpl());
        Object3D.duplicateHelper(duplicate, this);
        return duplicate;
    }

    private static void duplicateHelper(Object3D dst, Object3D src) {
        dst.setUserObject(src.uo);
        if (src instanceof Group) {
            Group srcGroup = (Group)src;
            Group dstGroup = (Group)dst;
            int children = srcGroup.getChildCount();
            for (int child = 0; child < children; ++child) {
                try {
                    Object3D.duplicateHelper(dstGroup.getChild(child), srcGroup.getChild(child));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
        } else if (src instanceof SkinnedMesh) {
            Object3D.duplicateHelper(((SkinnedMesh)dst).getSkeleton(), ((SkinnedMesh)src).getSkeleton());
        }
    }

    public Object getUserObject() {
        return this.uo;
    }

    public void setUserObject(Object userObject) {
        this.uo = userObject;
        if (this.uo != null) {
            Engine.addXOT(this);
        }
    }

    static {
        try {
            Engine.cacheFID(Class.forName("javax.microedition.m3g.Object3D"), 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

