/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Object3D;

public class Loader {
    int swerveHandle;
    static final int ERROR_NONE = -1;
    static final int ERROR_ABORT = -2;
    static final int ERROR_NOTFOUND = -3;
    static final int ERROR_READ = -4;
    static final int ERROR_UNABLETOCREATE = -5;
    static final int ERROR_UNABLETOFREE = -6;
    static final int ERROR_INVALIDHEADER = -7;
    static final int ERROR_INVALIDBODY = -8;
    static final int ERROR_INVALIDCHECKSUM = -9;
    static final int ERROR_UNKNOWN = -10;
    static final int ERROR_DATAPASTEOF = -11;
    static int m3gIdentifierLength;
    static int BLOCK_SIZE;

    private native void finalize();

    Loader() {
    }

    Loader(int handle) {
        this.swerveHandle = handle;
    }

    private static native int createImpl();

    native boolean getbContainsExtensions();

    native int onDataStart(boolean var1);

    native int onDataEnd();

    native int onData(byte[] var1, int var2, int var3);

    native void onError(int var1);

    native int getRootCount();

    private native int getRootImpl(int var1);

    native int getXREFName(byte[] var1);

    native void resolveXREF(Object3D var1);

    public static Object3D[] load(byte[] data, int offset) throws IOException {
        if (offset < 0 || offset >= data.length) {
            throw new IndexOutOfBoundsException();
        }
        return Loader.loadHelper(data, offset, true);
    }

    private static Object3D[] loadHelper(byte[] data, int offset, boolean bPermitExtensions) throws IOException {
        try {
            int error;
            Loader loader = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            try {
                error = loader.onDataStart(bPermitExtensions);
                int length = data.length - offset;
                if (error == -1 && length > m3gIdentifierLength) {
                    error = loader.onData(data, offset, m3gIdentifierLength);
                    length -= m3gIdentifierLength;
                    offset += m3gIdentifierLength;
                }
                if (error == -1) {
                    error = loader.onData(data, offset, length);
                }
                if (error >= 0) {
                    loader.processXREFs(null);
                    offset += error;
                    length -= error;
                    error = loader.onData(data, offset, length);
                }
                if (error == -11) {
                    error = -1;
                }
                if (error == -1) {
                    error = loader.onDataEnd();
                }
            }
            catch (SecurityException e) {
                loader.onError(-10);
                if (e.getMessage() != null) {
                    throw new SecurityException(e.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception e) {
                loader.onError(-10);
                if (e.getMessage() != null) {
                    throw new IOException(e.getMessage());
                }
                throw new IOException();
            }
            if (error == -1) {
                Object3D[] roots = loader.createRoots();
                return roots;
            }
            Image img = Loader.createImage(data, 0, data.length);
            if (img != null) {
                int format = Loader.isOpaque(img) ? 99 : 100;
                Object3D[] roots = new Object3D[]{new Image2D(format, img)};
                return roots;
            }
            return null;
        }
        catch (SecurityException e) {
            if (e.getMessage() != null) {
                throw new SecurityException(e.getMessage());
            }
            throw new SecurityException();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            throw new IOException();
        }
    }

    public static Object3D[] load(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        return Loader.loadHelper(name, true);
    }

    private static Object3D[] loadHelper(String name, boolean bPermitExtensions) throws IOException {
        InputStream is = null;
        try {
            Image img;
            int error;
            Loader loader = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            try {
                int length;
                is = loader.getClass().getResourceAsStream(name);
                if (is == null) {
                    is = Loader.openInputStream(name);
                }
                error = loader.onDataStart(bPermitExtensions);
                byte[] data = new byte[BLOCK_SIZE];
                if (error == -1 && (length = is.read(data, 0, m3gIdentifierLength)) != -1) {
                    error = loader.onData(data, 0, m3gIdentifierLength);
                }
                while (error == -1 && (length = is.read(data, 0, BLOCK_SIZE)) != -1) {
                    error = loader.onData(data, 0, length);
                    if (error < 0) continue;
                    loader.processXREFs(name);
                    error = loader.onData(data, error, length - error);
                }
                if (error == -1) {
                    error = loader.onDataEnd();
                }
            }
            catch (SecurityException e) {
                loader.onError(-10);
                if (e.getMessage() != null) {
                    throw new SecurityException(e.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception e) {
                loader.onError(-10);
                if (e.getMessage() != null) {
                    throw new IOException(e.getMessage());
                }
                throw new IOException();
            }
            if (error == -1) {
                Object3D[] roots;
                Object3D[] length = roots = loader.createRoots();
                return length;
            }
            if (is != null) {
                is.close();
                is = null;
            }
            if ((img = Loader.createImage(name)) != null) {
                Object3D[] roots;
                int format = Loader.isOpaque(img) ? 99 : 100;
                Object3D[] object3DArray = roots = new Object3D[]{new Image2D(format, img)};
                return object3DArray;
            }
            Object3D[] object3DArray = null;
            return object3DArray;
        }
        catch (SecurityException e) {
            if (e.getMessage() != null) {
                throw new SecurityException(e.getMessage());
            }
            throw new SecurityException();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            throw new IOException();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void processXREFs(String name) throws IOException {
        int len;
        byte[] xrefNameUTF8 = null;
        do {
            Object3D[] xrefs;
            if ((len = this.getXREFName(null)) == -1) continue;
            if (xrefNameUTF8 == null || xrefNameUTF8.length != len) {
                xrefNameUTF8 = new byte[len];
            }
            this.getXREFName(xrefNameUTF8);
            String xrefName = new String(xrefNameUTF8, "UTF-8");
            if (Loader.isRelative(xrefName)) {
                if (name == null) {
                    throw new IOException("XREF resource [" + xrefName + "] has relative URI.");
                }
                xrefName = Loader.resolveURI(name, xrefName);
            }
            if ((xrefs = Loader.loadHelper(xrefName, this.getbContainsExtensions())) == null) {
                throw new IOException("XREF resource [" + xrefName + "] contained no roots.");
            }
            this.resolveXREF(xrefs[0]);
        } while (len != -1);
    }

    private static boolean isRelative(String URI) {
        char c;
        int len = URI.length();
        if (len == 0 || URI.startsWith("//")) {
            return true;
        }
        if (URI.startsWith("/")) {
            return false;
        }
        int i = 0;
        while ((c = URI.charAt(i)) != ':' && c != '/' && c != '?' && c != '#' && ++i != len) {
        }
        return c != ':';
    }

    private static String resolveURI(String baseURI, String relativeURI) {
        int baseURILength;
        int relativeURILength = relativeURI.length();
        for (baseURILength = baseURI.length(); baseURILength > 0 && baseURI.charAt(baseURILength - 1) != '/'; --baseURILength) {
        }
        if (baseURILength > 0) {
            return baseURI.substring(0, baseURILength) + relativeURI;
        }
        return '/' + relativeURI;
    }

    private Object3D[] createRoots() {
        int rootCount = this.getRootCount();
        if (rootCount == 0) {
            return null;
        }
        Object3D[] roots = new Object3D[rootCount];
        while (rootCount-- > 0) {
            roots[rootCount] = (Object3D)Engine.instantiateJavaPeer(this.getRootImpl(rootCount));
        }
        return roots;
    }

    static InputStream openInputStream(String name) throws IOException {
        return Connector.openInputStream((String)name);
    }

    static int getImageWidth(Image img) {
        return img.getWidth();
    }

    static int getImageHeight(Image img) {
        return img.getHeight();
    }

    static void getImageRGB(Image img, int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        img.getRGB(rgbData, offset, scanlength, x, y, width, height);
    }

    static boolean isOpaque(Image img) {
        int height;
        boolean opaque = true;
        int width = Loader.getImageWidth(img);
        if (width <= (height = Loader.getImageHeight(img))) {
            int[] pels = new int[width];
            block0: for (int row = 0; opaque && row < height; ++row) {
                Loader.getImageRGB(img, pels, 0, width, 0, row, width, 1);
                for (int col = 0; col < width; ++col) {
                    if ((pels[col] >> 24 & 0xFF) >= 255) continue;
                    opaque = false;
                    continue block0;
                }
            }
        } else {
            int[] pels = new int[height];
            block2: for (int col = 0; opaque && col < width; ++col) {
                Loader.getImageRGB(img, pels, 0, 1, col, 0, 1, height);
                for (int row = 0; row < height; ++row) {
                    if ((pels[row] >> 24 & 0xFF) >= 255) continue;
                    opaque = false;
                    continue block2;
                }
            }
        }
        return opaque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image createImage(String name) throws IOException {
        InputStream is = null;
        try {
            Image image = Image.createImage((String)name);
            return image;
        }
        catch (IOException io) {
            is = Loader.openInputStream(name);
            Image image = Image.createImage((InputStream)is);
            return image;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    static Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        return Image.createImage((byte[])imageData, (int)imageOffset, (int)imageLength);
    }

    static {
        try {
            Engine.cacheFID(Class.forName("javax.microedition.m3g.Loader"), 2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        m3gIdentifierLength = 12;
        BLOCK_SIZE = 4096;
    }
}

