/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class Graphics3D {
    int swerveHandle;
    public static final int ANTIALIAS = 2;
    public static final int DITHER = 4;
    public static final int TRUE_COLOR = 8;
    static final int SUPPORTANTIALIASING = 0;
    static final int SUPPORTTRUECOLOR = 0;
    static final int SUPPORTDITHERING = 0;
    static final int SUPPORTMIPMAP = 0;
    static final int SUPPORTPERSPECTIVECORRECTION = 1;
    static final int SUPPORTLOCALCAMERALIGHTING = 1;
    static final int MAXLIGHTS = 256;
    static final int MAXVIEWPORTDIMENSION = 1024;
    static final int MAXTEXTUREDIMENSION = 1024;
    static final int MAXSPRITECROPDIMENSION = 1024;
    static final int NUMTEXTUREUNITS = 2;
    static final int MAXTRANSFORMSPERVERTEX = 2;
    private Object boundTarget = null;
    private boolean isGraphics = true;
    private static Hashtable properties;

    private native void finalize();

    Graphics3D() {
    }

    Graphics3D(int handle) {
        this.swerveHandle = handle;
    }

    public static final Graphics3D getInstance() {
        Graphics3D __res = (Graphics3D)Engine.instantiateJavaPeer(Graphics3D.getInstanceImpl());
        return __res;
    }

    private static native int getInstanceImpl();

    private native void setBackBufferImage2D(Image2D var1);

    private native void setHints(boolean var1, int var2);

    public synchronized void bindTarget(Object target, boolean depthBuffer, int hints) {
        if ((hints & 0xFFFFFFF1) != 0) {
            throw new IllegalArgumentException();
        }
        this.bindTarget(target);
        this.setHints(depthBuffer, hints);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void bindTarget(Object target) {
        if (this.boundTarget != null) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (target instanceof Graphics) {
            this.boundTarget = target;
            this.isGraphics = true;
            try {
                this.bindTarget((Graphics)target);
                return;
            }
            catch (Exception e) {
                this.boundTarget = null;
            }
            return;
        } else {
            if (!(target instanceof Image2D)) throw new IllegalArgumentException();
            Image2D i = (Image2D)target;
            int format = i.getFormat();
            if (!i.isMutable() || format != 99 && format != 100) throw new IllegalArgumentException();
            this.boundTarget = target;
            this.isGraphics = false;
            try {
                this.setBackBufferImage2D((Image2D)target);
                return;
            }
            catch (Exception e) {
                this.boundTarget = null;
            }
        }
    }

    private void bindTarget(Graphics g) {
        this.bindTargetGraphics(g, g.getTranslateX() + g.getClipX(), g.getTranslateY() + g.getClipY(), g.getClipWidth(), g.getClipHeight());
    }

    private native void bindTargetGraphics(Graphics var1, int var2, int var3, int var4, int var5);

    public synchronized void releaseTarget() {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        if (this.isGraphics) {
            this.releaseTargetGraphics((Graphics)this.boundTarget);
        }
        this.boundTarget = null;
    }

    private native void releaseTargetGraphics(Graphics var1);

    public void setViewport(int x, int y, int width, int height) {
        if (this.boundTarget != null && this.boundTarget instanceof Graphics) {
            Graphics g = (Graphics)this.boundTarget;
            x += g.getTranslateX();
            y += g.getTranslateY();
        }
        this.setViewportImpl(x, y, width, height);
    }

    private native void setViewportImpl(int var1, int var2, int var3, int var4);

    public native void setDepthRange(float var1, float var2);

    public synchronized void clear(Background background) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.clearImpl(background);
    }

    private native void clearImpl(Background var1);

    public void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform) {
        this.render(vertices, triangles, appearance, transform, -1);
    }

    public synchronized void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform, int scope) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.renderPrimitive(vertices, triangles, appearance, transform, scope);
    }

    private native void renderPrimitive(VertexBuffer var1, IndexBuffer var2, Appearance var3, Transform var4, int var5);

    public synchronized void render(Node node, Transform transform) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.renderNode(node, transform);
    }

    private native void renderNode(Node var1, Transform var2);

    public synchronized void render(World world) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.renderWorld(world);
    }

    private native void renderWorld(World var1);

    public native void setCamera(Camera var1, Transform var2);

    public native void setLight(int var1, Light var2, Transform var3);

    public native int addLight(Light var1, Transform var2);

    public native void resetLights();

    public static final synchronized Hashtable getProperties() {
        if (properties == null) {
            properties = new Hashtable();
            properties.put(new String("supportAntialiasing"), new Boolean(false));
            properties.put(new String("supportTrueColor"), new Boolean(false));
            properties.put(new String("supportDithering"), new Boolean(false));
            properties.put(new String("supportMipmapping"), new Boolean(false));
            properties.put(new String("supportPerspectiveCorrection"), new Boolean(true));
            properties.put(new String("supportLocalCameraLighting"), new Boolean(true));
            properties.put(new String("maxLights"), new Integer(256));
            properties.put(new String("maxViewportDimension"), new Integer(1024));
            properties.put(new String("maxTextureDimension"), new Integer(1024));
            properties.put(new String("maxSpriteCropDimension"), new Integer(1024));
            properties.put(new String("numTextureUnits"), new Integer(2));
            properties.put(new String("maxTransformsPerVertex"), new Integer(2));
            properties.put(new String("C3A458D3-2015-41f5-8338-66A2D3014335"), new Integer(1));
        }
        return properties;
    }

    static {
        try {
            Engine.cacheFID(Class.forName("javax.microedition.m3g.Graphics3D"), 1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        properties = null;
    }
}

