/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Key;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.MorphingMesh;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

class Engine {
    static final int ANIMATIONCONTROLLER = 0;
    static final int ANIMATIONTRACK = 1;
    static final int APPEARANCE = 2;
    static final int BACKGROUND = 3;
    static final int CAMERA = 4;
    static final int COMPOSITINGMODE = 5;
    static final int FOG = 6;
    static final int GRAPHICS3D = 7;
    static final int GROUP = 8;
    static final int IMAGE2D = 9;
    static final int KEYFRAMESEQUENCE = 10;
    static final int LIGHT = 11;
    static final int LOADER = 12;
    static final int MATERIAL = 13;
    static final int MESH = 14;
    static final int MORPHINGMESH = 15;
    static final int PLASMAIMAGE = 16;
    static final int POLYGONMODE = 17;
    static final int RAYINTERSECTION = 18;
    static final int SKINNEDMESH = 19;
    static final int SPRITE3D = 20;
    static final int STAGESET = 21;
    static final int TEXTURE2D = 22;
    static final int TRANSFORM = 23;
    static final int TRIANGLESTRIPARRAY = 24;
    static final int VERTEXARRAY = 25;
    static final int VERTEXBUFFER = 26;
    static final int WORLD = 27;
    static final int UNKNOWN = 28;
    static final int OBJECT3D_FID = 0;
    static final int GRAPHICS3D_FID = 1;
    static final int LOADER_FID = 2;
    static final int RAYINTERSECTION_FID = 3;
    static final int TRANSFORM_FID = 4;
    static Hashtable peerTable = new Hashtable();
    static Object3D[] XOT = new Object3D[0];
    static int XOTlength = 0;
    private static Object3D[] tmpXOT = null;
    private static boolean cleanPeerTable = false;
    private static Key lookup = new Key(0);

    Engine() {
    }

    static native void releaseHandle(int var0);

    static native int getHandleType(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object instantiateJavaPeer(int handle) {
        if (handle == 0) {
            return null;
        }
        boolean success = false;
        try {
            Object peer = Engine.getJavaPeer(handle);
            if (peer != null) {
                Object object = peer;
                return object;
            }
            switch (Engine.getHandleType(handle)) {
                case 0: {
                    peer = new AnimationController(handle);
                    break;
                }
                case 1: {
                    peer = new AnimationTrack(handle);
                    break;
                }
                case 2: {
                    peer = new Appearance(handle);
                    break;
                }
                case 3: {
                    peer = new Background(handle);
                    break;
                }
                case 4: {
                    peer = new Camera(handle);
                    break;
                }
                case 5: {
                    peer = new CompositingMode(handle);
                    break;
                }
                case 6: {
                    peer = new Fog(handle);
                    break;
                }
                case 7: {
                    peer = new Graphics3D(handle);
                    break;
                }
                case 8: {
                    peer = new Group(handle);
                    break;
                }
                case 9: 
                case 16: 
                case 21: {
                    peer = new Image2D(handle);
                    break;
                }
                case 10: {
                    peer = new KeyframeSequence(handle);
                    break;
                }
                case 11: {
                    peer = new Light(handle);
                    break;
                }
                case 12: {
                    peer = new Loader(handle);
                    break;
                }
                case 13: {
                    peer = new Material(handle);
                    break;
                }
                case 14: {
                    peer = new Mesh(handle);
                    break;
                }
                case 15: {
                    peer = new MorphingMesh(handle);
                    break;
                }
                case 17: {
                    peer = new PolygonMode(handle);
                    break;
                }
                case 18: {
                    peer = new RayIntersection(handle);
                    break;
                }
                case 19: {
                    peer = new SkinnedMesh(handle);
                    break;
                }
                case 20: {
                    peer = new Sprite3D(handle);
                    break;
                }
                case 22: {
                    peer = new Texture2D(handle);
                    break;
                }
                case 23: {
                    peer = new Transform(handle);
                    break;
                }
                case 24: {
                    peer = new TriangleStripArray(handle);
                    break;
                }
                case 25: {
                    peer = new VertexArray(handle);
                    break;
                }
                case 26: {
                    peer = new VertexBuffer(handle);
                    break;
                }
                case 27: {
                    peer = new World(handle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (peer instanceof Object3D) {
                int len;
                Object3D o3d = (Object3D)peer;
                Hashtable<Integer, byte[]> params = null;
                int index = 0;
                while ((len = o3d.getUserParameterValue(index, null)) != -1) {
                    if (params == null) {
                        params = new Hashtable<Integer, byte[]>();
                    }
                    Integer id = new Integer(o3d.getUserParameterID(index));
                    byte[] buffer = new byte[len];
                    o3d.getUserParameterValue(index, buffer);
                    params.put(id, buffer);
                    ++index;
                }
                if (params != null) {
                    o3d.removeUserParameters();
                    o3d.setUserObject(params);
                }
            }
            Engine.addJavaPeer(handle, peer);
            success = true;
            Object object = peer;
            return object;
        }
        finally {
            if (!success) {
                Engine.releaseHandle(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addJavaPeer(int handle, Object peer) {
        Hashtable hashtable = peerTable;
        synchronized (hashtable) {
            peerTable.put(new Key(handle), new WeakReference<Object>(peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getJavaPeer(int handle) {
        Object entry;
        Hashtable hashtable = peerTable;
        synchronized (hashtable) {
            if (cleanPeerTable) {
                Enumeration keys = peerTable.keys();
                while (keys.hasMoreElements()) {
                    Key key = (Key)keys.nextElement();
                    WeakReference ref = (WeakReference)peerTable.get(key);
                    if (ref.get() != null) continue;
                    peerTable.remove(key);
                }
                cleanPeerTable = false;
            }
            lookup.setKey(handle);
            entry = peerTable.get(lookup);
            if (entry != null) {
                entry = ((WeakReference)entry).get();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int[] getJavaPeerArrayHandles(Object[] peers) {
        if (peers == null) {
            return null;
        }
        Object[] objectArray = peers;
        synchronized (peers) {
            int[] handles = new int[peers.length];
            for (int i = 0; i < peers.length; ++i) {
                if (peers[i] == null) {
                    handles[i] = 0;
                    continue;
                }
                if (peers[i] instanceof Object3D) {
                    handles[i] = ((Object3D)peers[i]).swerveHandle;
                    continue;
                }
                throw new IllegalArgumentException(peers[i] + "is not instanceof Object3D");
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return handles;
        }
    }

    static native void cacheFID(Class var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addXOT(Object3D obj) {
        if (obj == null || !obj.ii && obj.uo == null) return;
        Object3D[] object3DArray = XOT;
        synchronized (XOT) {
            for (int i = 0; i < XOTlength; ++i) {
                if (XOT[i] != obj) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (XOTlength == XOT.length) {
                tmpXOT = new Object3D[XOT.length == 0 ? 2 : XOT.length * 2];
                System.arraycopy(XOT, 0, tmpXOT, 0, XOT.length);
                XOT = tmpXOT;
                tmpXOT = null;
            }
            Engine.XOT[Engine.XOTlength++] = obj;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void addXOT(Object3D[] obj) {
        if (obj != null) {
            for (int i = 0; i < obj.length; ++i) {
                Engine.addXOT(obj[i]);
            }
        }
    }
}

