/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class MessageImpl
extends SOAPMessage
implements SOAPConstants {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected static final int PLAIN_XML_FLAG = 1;
    protected static final int MIME_MULTIPART_FLAG = 2;
    protected static final int SOAP1_1_FLAG = 4;
    protected static final int SOAP1_2_FLAG = 8;
    protected MimeHeaders headers;
    protected SOAPPartImpl soapPart;
    protected Vector attachments;
    protected boolean saved;
    protected byte[] messageBytes;
    protected int messageByteCount;
    protected HashMap properties;
    private static final Iterator nullIter = new Iterator(){

        public void remove() {
            throw new IllegalStateException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };

    public int countAttachments() {
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    protected MessageImpl() {
        this.saved = false;
        this.properties = new HashMap();
        this.headers = new MimeHeaders();
    }

    private void initXMLDecl() throws SOAPException {
        String write = (String)this.getProperty("javax.xml.soap.write-xml-declaration");
        if ("true".equalsIgnoreCase(write)) {
            ((EnvelopeImpl)this.getSOAPPart().getEnvelope()).setOmitXmlDecl("no");
        } else if ("false".equalsIgnoreCase(write)) {
            ((EnvelopeImpl)this.getSOAPPart().getEnvelope()).setOmitXmlDecl("yes");
        }
    }

    private final void needsSave() {
        this.saved = false;
    }

    public void removeAllAttachments() {
        if (this.attachments != null) {
            this.attachments.removeAllElements();
            this.needsSave();
        }
    }

    public synchronized void saveChanges() throws SOAPException {
        String charset = this.initCharset();
        this.initXMLDecl();
        if (this.countAttachments() == 0) {
            ByteInputStream in = null;
            try {
                in = this.getHeaderBytes();
            }
            catch (IOException ex) {
                log.severe("SAAJ0539.soap.cannot.get.header.stream");
                throw new SOAPExceptionImpl("Unable to get header stream in saveChanges: ", ex);
            }
            this.messageBytes = in.getBytes();
            this.messageByteCount = in.getCount();
            this.headers.setHeader("Content-Type", "text/xml; charset=\"" + charset + "\"");
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        } else {
            ByteOutputStream out = new ByteOutputStream();
            try {
                this.getMimeMessage().writeTo((OutputStream)out);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                log.severe("SAAJ0540.soap.err.saving.multipart.msg");
                throw new SOAPExceptionImpl("Error during saving a multipart message", ex);
            }
            this.messageBytes = out.getBytes();
            this.messageByteCount = out.getCount();
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        }
        String[] soapAction = this.headers.getHeader("SOAPAction");
        if (soapAction == null || soapAction.length == 0) {
            this.headers.setHeader("SOAPAction", "\"\"");
        }
        this.saved = true;
    }

    public synchronized boolean saveRequired() {
        return !this.saved;
    }

    protected abstract boolean isCorrectSoapVersion(int var1);

    private final ByteInputStream getHeaderBytes() throws SOAPException, IOException {
        SOAPPartImpl sp = (SOAPPartImpl)this.getSOAPPart();
        return sp.getContentAsStream();
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        if (this.saveRequired()) {
            this.saveChanges();
        }
        out.write(this.messageBytes, 0, this.messageByteCount);
        this.messageBytes = null;
        this.needsSave();
    }

    public String getAction() {
        return this.ContentType().getParameter("action");
    }

    public String getBaseType() {
        return this.ContentType().getBaseType();
    }

    public String getCharset() {
        return this.ContentType().getParameter("charset");
    }

    public String getContentDescription() {
        String[] values = this.headers.getHeader("Content-Description");
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getContentType() {
        return MessageImpl.getContentType(this.headers);
    }

    protected abstract String getExpectedContentType();

    private String initCharset() throws SOAPException {
        String charset = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        if (charset != null) {
            ((EnvelopeImpl)this.getSOAPPart().getEnvelope()).setCharsetEncoding(charset);
            return charset;
        }
        return "utf-8";
    }

    public void setAction(String action) {
        ContentType ct = this.ContentType();
        ct.setParameter("action", action);
        this.headers.setHeader("Content-Type", ct.toString());
        this.needsSave();
    }

    public void setBaseType(String type) {
        ContentType ct = this.ContentType();
        ct.setParameter("type", type);
        this.headers.setHeader("Content-Type", ct.toString());
        this.needsSave();
    }

    public void setCharset(String charset) {
        ContentType ct = this.ContentType();
        ct.setParameter("charset", charset);
        this.headers.setHeader("Content-Type", ct.toString());
        this.needsSave();
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
        this.needsSave();
    }

    public void setContentType(String type) {
        this.headers.setHeader("Content-Type", type);
        this.needsSave();
    }

    protected static boolean isEqualToSoap1_1Type(String type) {
        return type.toLowerCase().startsWith("text/xml");
    }

    protected static boolean isEqualToSoap1_2Type(String type) {
        return type.toLowerCase().startsWith("application/soap+xml");
    }

    public Iterator getAttachments() {
        if (this.attachments == null) {
            return nullIter;
        }
        return this.attachments.iterator();
    }

    private ContentType ContentType() {
        ContentType ct = null;
        try {
            ct = new ContentType(this.getContentType());
        }
        catch (Exception e) {}
        return ct;
    }

    private static int identifyContentType(ContentType contentType) throws SOAPException {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (primary.equalsIgnoreCase("multipart")) {
            if (sub.equalsIgnoreCase("related")) {
                if (MessageImpl.isEqualToSoap1_1Type(contentType.getParameter("type"))) {
                    return 6;
                }
                if (MessageImpl.isEqualToSoap1_2Type(contentType.getParameter("type"))) {
                    return 10;
                }
                log.severe("SAAJ0536.soap.content-type.mustbe.multipart");
                throw new SOAPExceptionImpl("Content-Type needs to be Multipart/Related and with \"type=text/xml\" or \"type=application/soap+xml\"");
            }
            log.severe("SAAJ0537.soap.invalid.content-type");
            throw new SOAPExceptionImpl("Invalid Content-Type: " + primary + "/" + sub);
        }
        if (MessageImpl.isSoap1_1Type(primary, sub)) {
            return 5;
        }
        if (MessageImpl.isSoap1_2Type(primary, sub)) {
            return 9;
        }
        log.severe("SAAJ0537.soap.invalid.content-type");
        throw new SOAPExceptionImpl("Invalid Content-Type:" + primary + "/" + sub + ". Is this an error message instead of a SOAP response?");
    }

    protected static boolean isSoap1_1Content(ContentType contentType) throws SOAPException {
        return (MessageImpl.identifyContentType(contentType) & 4) != 0;
    }

    protected static boolean isSoap1_2Content(ContentType contentType) throws SOAPException {
        return (MessageImpl.identifyContentType(contentType) & 8) != 0;
    }

    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            MimeMultipart headerAndBody = new MimeMultipart();
            SOAPPartImpl soapPart = (SOAPPartImpl)this.getSOAPPart();
            headerAndBody.addBodyPart((BodyPart)soapPart.getMimePart());
            Iterator eachAttachement = this.getAttachments();
            while (eachAttachement.hasNext()) {
                headerAndBody.addBodyPart((BodyPart)((AttachmentPartImpl)((Object)eachAttachement.next())).getMimePart());
            }
            ContentType contentType = new ContentType(headerAndBody.getContentType());
            ParameterList l = contentType.getParameterList();
            l.set("type", this.getExpectedContentType());
            l.set("boundary", contentType.getParameter("boundary"));
            ContentType nct = new ContentType("multipart", "related", l);
            this.headers.setHeader("Content-Type", nct.toString());
            return headerAndBody;
        }
        catch (SOAPException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            log.severe("SAAJ0538.soap.cannot.convert.msg.to.multipart.obj");
            throw new SOAPExceptionImpl("Unable to convert SOAP message into a MimeMultipart object", ex);
        }
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public void addAttachmentPart(AttachmentPart attachment) {
        if (this.attachments == null) {
            this.attachments = new Vector();
        }
        this.attachments.addElement(attachment);
        this.needsSave();
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.getSOAPPart().getEnvelope().getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.getSOAPPart().getEnvelope().getHeader();
    }

    protected MessageImpl(SOAPMessage msg) {
        this.saved = false;
        this.properties = new HashMap();
        if (!(msg instanceof MessageImpl)) {
            // empty if block
        }
        MessageImpl src = (MessageImpl)msg;
        this.headers = src.headers;
        this.soapPart = src.soapPart;
        this.attachments = src.attachments;
        this.saved = src.saved;
        this.messageBytes = src.messageBytes;
        this.messageByteCount = src.messageByteCount;
        this.properties = src.properties;
    }

    public abstract SOAPPart getSOAPPart();

    protected MessageImpl(MimeHeaders headers, final InputStream in) throws IOException, SOAPExceptionImpl {
        block7: {
            this.saved = false;
            this.properties = new HashMap();
            this.headers = headers;
            final String ct = MessageImpl.getContentType(headers);
            if (ct == null) {
                log.severe("SAAJ0532.soap.no.Content-Type");
                throw new SOAPExceptionImpl("Absent Content-Type");
            }
            try {
                ContentType contentType = new ContentType(ct);
                int contentTypeId = MessageImpl.identifyContentType(contentType);
                if (!this.isCorrectSoapVersion(contentTypeId)) {
                    log.log(Level.SEVERE, "SAAJ0533.soap.incorrect.Content-Type", new String[]{contentType.toString(), this.getExpectedContentType()});
                    throw new SOAPVersionMismatchException("Cannot create message: incorrect content-type for SOAP version. Got: " + contentType + " Expected: " + this.getExpectedContentType());
                }
                if ((contentTypeId & 1) != 0) {
                    this.getSOAPPart().setContent((Source)new StreamSource(in));
                    break block7;
                }
                if ((contentTypeId & 2) != 0) {
                    DataSource ds = new DataSource(){

                        public InputStream getInputStream() {
                            return in;
                        }

                        public OutputStream getOutputStream() {
                            return null;
                        }

                        public String getContentType() {
                            return ct;
                        }

                        public String getName() {
                            return "";
                        }
                    };
                    MimeMultipart multiPart = new MimeMultipart(ds);
                    MimeBodyPart soapMessagePart = (MimeBodyPart)multiPart.getBodyPart(0);
                    this.getSOAPPart().setContent((Source)new StreamSource(soapMessagePart.getInputStream()));
                    int i = 1;
                    while (i < multiPart.getCount()) {
                        MimeBodyPart currentBodyPart = (MimeBodyPart)multiPart.getBodyPart(i);
                        AttachmentPartImpl attachmentPart = new AttachmentPartImpl();
                        DataHandler attachmentHandler = currentBodyPart.getDataHandler();
                        attachmentPart.setDataHandler(attachmentHandler);
                        AttachmentPartImpl.copyMimeHeaders(currentBodyPart, attachmentPart);
                        this.addAttachmentPart(attachmentPart);
                        ++i;
                    }
                    break block7;
                }
                log.severe("SAAJ0534.soap.unknown.Content-Type");
                throw new SOAPExceptionImpl("Unrecognized Content-Type");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                log.severe("SAAJ0535.soap.cannot.internalize.message");
                throw new SOAPExceptionImpl("Unable to internalize message", ex);
            }
        }
        this.needsSave();
    }

    public Object getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        this.verify(property, value);
        this.properties.put(property, value);
    }

    private void verify(String property, Object value) {
        if (property.equalsIgnoreCase("javax.xml.soap.write-xml-declaration") && !"true".equals(value) && !"false".equals(value)) {
            throw new RuntimeException(property + " must have value false or true");
        }
    }

    protected static boolean isSoap1_1Type(String primary, String sub) {
        return primary.equalsIgnoreCase("text") && sub.equalsIgnoreCase("xml");
    }

    protected static boolean isSoap1_2Type(String primary, String sub) {
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("soap+xml");
    }

    static final String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public Iterator getAttachments(MimeHeaders headers) {
        if (this.attachments == null) {
            return nullIter;
        }
        return new MimeMatchingIterator(headers);
    }

    private class MimeMatchingIterator
    implements Iterator {
        private Iterator iter;
        private MimeHeaders headers;
        private Object nextAttachment;

        public void remove() {
            this.iter.remove();
        }

        public boolean hasNext() {
            if (this.nextAttachment == null) {
                this.nextAttachment = this.nextMatch();
            }
            return this.nextAttachment != null;
        }

        public Object next() {
            if (this.nextAttachment != null) {
                Object ret = this.nextAttachment;
                this.nextAttachment = null;
                return ret;
            }
            if (this.hasNext()) {
                return this.nextAttachment;
            }
            return null;
        }

        Object nextMatch() {
            while (this.iter.hasNext()) {
                AttachmentPartImpl ap = (AttachmentPartImpl)((Object)this.iter.next());
                if (!ap.hasAllHeaders(this.headers)) continue;
                return ap;
            }
            return null;
        }

        public MimeMatchingIterator(MimeHeaders headers) {
            this.headers = headers;
            this.iter = MessageImpl.this.attachments.iterator();
        }
    }
}

