/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.InputModeClient;
import com.sun.midp.lcdui.InputModeHelper;
import javax.microedition.lcdui.Policy;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

class TextBasic {
    char[] buffer;
    int numChars;
    int curPos;
    int constraints;
    Policy policy;
    String defaultMode;
    String[] allowedMode;

    TextBasic(int constraints, int maxSize, String text) {
        if (text == null) {
            this.buffer = new char[0];
        } else {
            this.buffer = text.toCharArray();
            this.numChars = this.curPos = text.length();
        }
        this.policy = Policy.getPolicy(constraints);
        this.constraints = constraints;
        if (!this.policy.validateContent(this.buffer, 0, this.numChars)) {
            this.curPos = 0;
            this.numChars = 0;
            throw new IllegalArgumentException();
        }
        if (this.numChars > maxSize) {
            throw new IllegalArgumentException();
        }
        this.setMaxSize(maxSize);
    }

    int setConstraints(int constraints) {
        if (constraints == this.constraints) {
            return 0;
        }
        this.constraints = constraints;
        int w = this.policy.width;
        int h = this.policy.height;
        this.policy = Policy.getPolicy(constraints);
        if (!this.policy.validateContent(this.buffer, 0, this.numChars)) {
            this.curPos = 0;
            this.numChars = 0;
        }
        if (w == -1) {
            return 0;
        }
        return h - this.policy.setWidth(w, this.buffer, this.numChars, this.curPos);
    }

    int setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        if ((maxSize = this.policy.constrainedSize(maxSize, this.buffer)) != this.buffer.length) {
            char[] newbuf = new char[maxSize];
            if (maxSize < this.numChars) {
                this.numChars = maxSize;
                if (this.curPos > this.numChars) {
                    this.curPos = this.numChars;
                }
            }
            System.arraycopy(this.buffer, 0, newbuf, 0, this.numChars);
            this.buffer = newbuf;
        }
        return this.policy.contentChanged(this.buffer, this.numChars, 0, this.curPos);
    }

    int insert(String src, int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.numChars) {
            position = this.numChars;
        }
        int length = src.length();
        if (this.numChars + length > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.buffer, position, this.buffer, position + length, this.numChars - position);
        src.getChars(0, length, this.buffer, position);
        this.numChars += length;
        if (!this.policy.validateContent(this.buffer, position, length)) {
            this.numChars -= length;
            System.arraycopy(this.buffer, position + length, this.buffer, position, this.numChars - position);
            throw new IllegalArgumentException();
        }
        if (position <= this.curPos) {
            this.curPos += length;
        }
        return this.policy.contentChanged(this.buffer, this.numChars, position, this.curPos);
    }

    int insert(char[] data, int offset, int length, int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.numChars) {
            position = this.numChars;
        }
        if (this.numChars + length > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, position, this.buffer, position + length, this.numChars - position);
        System.arraycopy(data, offset, this.buffer, position, length);
        this.numChars += length;
        if (!this.policy.validateContent(this.buffer, position, length)) {
            this.numChars -= length;
            System.arraycopy(this.buffer, position + length, this.buffer, position, this.numChars - position);
            throw new IllegalArgumentException();
        }
        if (position <= this.curPos) {
            this.curPos += length;
        }
        return this.policy.contentChanged(this.buffer, this.numChars, position, this.curPos);
    }

    int deleteChars(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.numChars) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, offset + length, this.buffer, offset, this.numChars - offset - length);
        this.numChars -= length;
        if (offset < this.curPos) {
            this.curPos -= length;
        } else if (this.curPos > this.numChars) {
            this.curPos = this.numChars;
        }
        return this.policy.contentChanged(this.buffer, this.numChars, offset, this.curPos);
    }

    int setChars(char[] data, int offset, int length) {
        if (data == null) {
            this.curPos = 0;
            this.numChars = 0;
            return this.policy.contentChanged(this.buffer, this.numChars, 0, this.curPos);
        }
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        if (!this.policy.validateContent(data, offset, length)) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(data, offset, this.buffer, 0, length);
        this.curPos = this.numChars = length;
        return this.policy.contentChanged(this.buffer, this.numChars, 0, this.curPos);
    }

    int setString(String text) {
        if (text == null) {
            this.numChars = 0;
            this.curPos = 0;
        } else {
            int length = text.length();
            if (length > this.buffer.length) {
                throw new IllegalArgumentException();
            }
            text.getChars(0, length, this.buffer, 0);
            if (!this.policy.validateContent(this.buffer, 0, length)) {
                throw new IllegalArgumentException();
            }
            this.numChars = length;
            this.curPos = length;
        }
        return this.policy.contentChanged(this.buffer, this.numChars, 0, this.curPos);
    }

    int getChars(char[] data) {
        if (this.numChars > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.buffer != null && this.numChars > 0) {
            System.arraycopy(this.buffer, 0, data, 0, this.numChars);
            return this.numChars;
        }
        return 0;
    }

    int traverse(int dir, int top, int bottom) {
        if (this.numChars == 0 || dir != 1 && dir != 6 && dir != 2 && dir != 5) {
            return -1;
        }
        int oldCurPos = this.curPos;
        this.curPos = this.policy.moveCursor(dir, this.curPos, this.buffer, this.numChars);
        if (this.curPos != oldCurPos) {
            int cursorY1 = this.policy.cursorY;
            int cursorY2 = cursorY1 + this.policy.lineHeight;
            if (top <= cursorY1 && bottom >= cursorY2) {
                return 0;
            }
            int t1 = cursorY2 - bottom;
            int t2 = top - cursorY1;
            return t1 >= t2 ? t1 : t2;
        }
        return -1;
    }

    int setWidth(int width) {
        return this.policy.setWidth(width, this.buffer, this.numChars, this.curPos);
    }

    void setHorizontalScroll(Screen parent) {
        if (parent instanceof TextBox) {
            if (this.numChars == 0) {
                parent.setHorizontalScroll(0, 100);
            } else {
                parent.setHorizontalScroll(this.curPos * 100 / this.numChars, 100 / (this.numChars + 1));
            }
        }
    }

    int getMaxWidth(int allowedWidth) {
        return this.policy.getMaxWidth(allowedWidth, this.buffer.length);
    }

    static {
        InputModeClient imc = new InputModeClient(){

            public void setMode(TextBox tb, String defaultMode) {
                tb.sD.defaultMode = defaultMode;
            }

            public String getMode(TextBox tb) {
                return tb.sD.defaultMode;
            }

            public void setAllowedModes(TextBox tb, String[] allowedMode) {
                tb.sD.allowedMode = allowedMode;
            }

            public String[] getAllowedModes(TextBox tb) {
                return tb.sD.allowedMode;
            }

            public void setMode(TextField tf, String defaultMode) {
                tf.sD.defaultMode = defaultMode;
            }

            public String getMode(TextField tf) {
                return tf.sD.defaultMode;
            }

            public void setAllowedModes(TextField tf, String[] allowedMode) {
                tf.sD.allowedMode = allowedMode;
            }

            public String[] getAllowedModes(TextField tf) {
                return tf.sD.allowedMode;
            }
        };
        InputModeHelper.setInputModeHelper(imc);
    }
}

