/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.OutputStorage;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.PublicKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class PublicKeyStoreBuilderBase
extends PublicKeyStore {
    private Vector keyList = new Vector();

    public PublicKeyStoreBuilderBase() {
        this.initPublicKeyStore(this.keyList);
    }

    public PublicKeyStoreBuilderBase(InputStream in) throws IOException {
        this.initPublicKeyStore(in, this.keyList);
    }

    public void serialize(OutputStream out) throws IOException {
        OutputStorage storage = new OutputStorage(out);
        Enumeration e = this.keyList.elements();
        while (e.hasMoreElements()) {
            PublicKeyInfo keyInfo = (PublicKeyInfo)e.nextElement();
            keyInfo.putKeyInStorage(storage);
        }
    }

    public synchronized boolean addKey(PublicKeyInfo keyInfo) {
        if (keyInfo == null) {
            return false;
        }
        if (this.findKey(keyInfo.getOwner()) != null) {
            return false;
        }
        this.keyList.addElement(keyInfo);
        return true;
    }

    public synchronized boolean updateKey(String owner, PublicKeyInfo newKeyInfo) {
        PublicKeyInfo oldKeyInfo = this.findKey(owner);
        if (oldKeyInfo == null) {
            return false;
        }
        int index = this.keyList.indexOf(oldKeyInfo);
        newKeyInfo.setDomain(oldKeyInfo.getDomain());
        this.keyList.setElementAt(newKeyInfo, index);
        return true;
    }

    public boolean deleteKey(String owner) {
        PublicKeyInfo keyInfo = this.findKey(owner);
        if (keyInfo == null) {
            return false;
        }
        this.keyList.removeElement(keyInfo);
        return true;
    }
}

