/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import socket.Sender;
import socket.SocketMIDlet;

public class Server
implements Runnable,
CommandListener {
    private SocketMIDlet parent;
    private Display display;
    private Form f;
    private StringItem si;
    private TextField tf;
    private boolean stop;
    private Command sendCommand = new Command("Send", 8, 1);
    private Command exitCommand = new Command("Exit", 7, 1);
    InputStream is;
    OutputStream os;
    SocketConnection sc;
    ServerSocketConnection scn;
    Sender sender;

    public Server(SocketMIDlet socketMIDlet) {
        this.parent = socketMIDlet;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.f = new Form("Socket Server");
        this.si = new StringItem("Status:", " ");
        this.tf = new TextField("Send:", "", 30, 0);
        this.f.append((Item)this.si);
        this.f.append((Item)this.tf);
        this.f.addCommand(this.exitCommand);
        this.f.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.f);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.si.setText("Waiting for connection");
            this.scn = (ServerSocketConnection)Connector.open((String)"socket://:5000");
            this.sc = (SocketConnection)this.scn.acceptAndOpen();
            this.si.setText("Connection accepted");
            this.is = this.sc.openInputStream();
            this.os = this.sc.openOutputStream();
            this.sender = new Sender(this.os);
            this.f.addCommand(this.sendCommand);
            while (true) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while ((n = this.is.read()) != 10 && n != -1) {
                    stringBuffer.append((char)n);
                }
                if (n == -1) break;
                this.si.setText("Message received - " + stringBuffer.toString());
            }
            this.stop();
            this.si.setText("Connection is closed");
            this.f.removeCommand(this.sendCommand);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("ServerSocket Open")) {
                Alert alert = new Alert("Server", "Port 5000 is already taken.", null, AlertType.ERROR);
                alert.setTimeout(-2);
                alert.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)alert);
            } else if (!this.stop) {
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.sendCommand && !this.parent.isPaused()) {
            this.sender.send(this.tf.getString());
        }
        if (command == Alert.DISMISS_COMMAND || command == this.exitCommand) {
            this.parent.notifyDestroyed();
            this.parent.destroyApp(true);
        }
    }

    public void stop() {
        try {
            this.stop = true;
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.sc != null) {
                this.sc.close();
            }
            if (this.scn != null) {
                this.scn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

