/*
 * Decompiled with CFR 0.152.
 */
package datagram;

import datagram.DatagramMIDlet;
import datagram.Sender;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Server
implements Runnable,
CommandListener {
    private DatagramMIDlet parent;
    private Display display;
    private Form f;
    private StringItem si;
    private TextField tf;
    private Command sendCommand = new Command("Send", 8, 1);
    Sender sender;
    private String address;

    public Server(DatagramMIDlet datagramMIDlet) {
        this.parent = datagramMIDlet;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.f = new Form("Datagram Server");
        this.si = new StringItem("Status:", " ");
        this.tf = new TextField("Send:", "", 30, 0);
        this.f.append((Item)this.si);
        this.f.append((Item)this.tf);
        this.f.addCommand(this.sendCommand);
        this.f.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.f);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.si.setText("Waiting for connection");
            DatagramConnection datagramConnection = (DatagramConnection)Connector.open((String)"datagram://:5555");
            this.sender = new Sender(datagramConnection);
            while (true) {
                Datagram datagram = datagramConnection.newDatagram(100);
                datagramConnection.receive(datagram);
                this.address = datagram.getAddress();
                this.si.setText("Message received - " + new String(datagram.getData(), 0, datagram.getLength()));
            }
        }
        catch (IOException iOException) {
            Alert alert = new Alert("Server", "Port 5000 is already taken.", null, AlertType.ERROR);
            alert.setTimeout(-2);
            alert.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)alert);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.sendCommand && !this.parent.isPaused()) {
            if (this.address == null) {
                this.si.setText("No destination address");
            } else {
                this.sender.send(this.address, this.tf.getString());
            }
        }
        if (command == Alert.DISMISS_COMMAND) {
            this.parent.destroyApp(true);
            this.parent.notifyDestroyed();
        }
    }

    public void stop() {
    }
}

