/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public final class CalculatorMIDlet
extends MIDlet
implements CommandListener {
    private static final int NUM_SIZE = 20;
    private final Command exitCmd = new Command("Exit", 7, 2);
    private final Command calcCmd = new Command("Calc", 1, 1);
    private final TextField t1 = new TextField(null, "", 20, 5);
    private final TextField t2 = new TextField(null, "", 20, 5);
    private final TextField tr = new TextField("Result", "", 20, 131072);
    private final ChoiceGroup cg = new ChoiceGroup("", 4, new String[]{"add", "subtract", "multiply", "divide"}, null);
    private final Alert alert = new Alert("Error", "", null, AlertType.ERROR);
    private boolean isInitialized = false;

    protected void startApp() {
        if (this.isInitialized) {
            return;
        }
        Form form = new Form("FP Calculator");
        form.append((Item)this.t1);
        form.append((Item)this.cg);
        form.append((Item)this.t2);
        form.append((Item)this.tr);
        form.addCommand(this.exitCmd);
        form.addCommand(this.calcCmd);
        form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
        this.alert.addCommand(new Command("Back", 1, 1));
        this.isInitialized = true;
    }

    protected void destroyApp(boolean bl) {
    }

    protected void pauseApp() {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCmd) {
            this.destroyApp(false);
            this.notifyDestroyed();
            return;
        }
        double d = 0.0;
        try {
            double d2 = this.getNumber(this.t1, "First");
            double d3 = this.getNumber(this.t2, "Second");
            switch (this.cg.getSelectedIndex()) {
                case 0: {
                    d = d2 + d3;
                    break;
                }
                case 1: {
                    d = d2 - d3;
                    break;
                }
                case 2: {
                    d = d2 * d3;
                    break;
                }
                case 3: {
                    d = d2 / d3;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        catch (ArithmeticException arithmeticException) {
            this.alert.setString("Divide by zero.");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.alert);
            return;
        }
        String string = Double.toString(d);
        if (string.length() > this.tr.getMaxSize()) {
            this.tr.setMaxSize(string.length());
        }
        this.tr.setString(string);
    }

    private double getNumber(TextField textField, String string) throws NumberFormatException {
        double d;
        String string2 = textField.getString();
        if (string2.length() == 0) {
            this.alert.setString("No " + string + " Argument");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.alert);
            throw new NumberFormatException();
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.alert.setString(string + " argument is out of range.");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.alert);
            throw numberFormatException;
        }
        return d;
    }
}

