/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.wsdl;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.processor.config.J2EEModelInfo;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralContentMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPAttributeMember;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.modeler.JavaSimpleTypeCreator;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.EnumerationFacet;
import com.sun.xml.rpc.processor.schema.Facet;
import com.sun.xml.rpc.processor.schema.InternalSchema;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Symbol;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.UnimplementedFeatureException;
import com.sun.xml.rpc.processor.schema.WildcardComponent;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPNamespaceConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.SOAPWSDLConstants;
import com.sun.xml.rpc.util.JAXRPCClassFactory;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class SchemaAnalyzerBase {
    private LocalizableMessageFactory _messageFactory;
    protected InternalSchema _schema;
    private ModelInfo _modelInfo;
    protected ProcessorEnvironment _env;
    private Set _typesBeingResolved;
    private Set _namePool;
    private Set _conflictingClassNames;
    private Map _componentToSOAPTypeMap;
    private Map _componentToLiteralTypeMap;
    private Map _typeNameToCustomSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToLiteralTypeMap;
    private boolean _noDataBinding;
    protected boolean _useDataHandlerOnly;
    private int _nextUniqueID;
    protected boolean _resolveIDREF;
    protected boolean _strictCompliance;
    protected boolean _jaxbEnumType;
    protected JavaSimpleTypeCreator javaTypes;
    private static SOAPNamespaceConstants soap11NamespaceConstants = null;
    protected static SOAPWSDLConstants soap11WSDLConstants = null;
    private static SOAPNamespaceConstants soap12NamespaceConstants = null;
    private static SOAPWSDLConstants soap12WSDLConstants = null;
    private static final String VALUE_MEMBER_NAME = "_value";
    private static final String ANY_MEMBER_NAME_PREFIX = "_any";
    protected Map _builtinSchemaTypeToJavaTypeMap;
    protected Map _builtinSchemaTypeToJavaWrapperTypeMap;
    protected Map _simpleTypeEncoderMap;

    protected int getUniqueID() {
        return this._nextUniqueID++;
    }

    private void init() {
        soap11NamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(SOAPVersion.SOAP_11);
        soap11WSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(SOAPVersion.SOAP_11);
        soap12NamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(SOAPVersion.SOAP_12);
        soap12WSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(SOAPVersion.SOAP_12);
    }

    protected abstract void initializeMaps();

    protected boolean doMakeMemberBoxedType() {
        return true;
    }

    protected boolean doWeHandleComplexSchemaTypeExtensionByComplexType() {
        return true;
    }

    protected boolean doWeHandleComplexSchemaTypeExtensionBySimpleContent() {
        return true;
    }

    protected boolean doWeHandleSimpleSchemaTypeDerivationByList() {
        return true;
    }

    protected boolean doWeHandleWildcard() {
        return true;
    }

    protected void resolveEnumerationNamingConflictsFor(JavaEnumerationType javaEnumType) {
        this.resolveNamingConflictsFor(javaEnumType, "_Enumeration");
    }

    protected void resolveNamingConflictsFor(JavaType javaType) {
        this.resolveNamingConflictsFor(javaType, "_Type");
    }

    protected boolean isAttributeEnumeration(LiteralType attributeType) {
        return attributeType instanceof LiteralEnumerationType;
    }

    protected void setReferenceable(SOAPSimpleType simpleType) {
        boolean referenceable = true;
        QName name = simpleType.getName();
        if (name.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !name.equals(BuiltInTypes.STRING) && !name.equals(BuiltInTypes.BASE64_BINARY) && !name.equals(BuiltInTypes.HEX_BINARY)) {
            referenceable = false;
        }
        simpleType.setReferenceable(referenceable);
    }

    private void setSOAPArrayHolderName(SOAPType type) {
        JavaType javaType;
        if (type instanceof SOAPArrayType && (javaType = type.getJavaType()) instanceof JavaArrayType) {
            ((JavaArrayType)javaType).setSOAPArrayHolderName(type.getName().getLocalPart());
        }
    }

    protected boolean isAttributeEnumeration(SOAPType attributeType) {
        return attributeType instanceof SOAPEnumerationType;
    }

    protected boolean isAttributeOptional(AttributeUseComponent attributeUse) {
        return !attributeUse.isRequired() && attributeUse.getValueKind() != Symbol.DEFAULT && attributeUse.getValueKind() != Symbol.FIXED;
    }

    protected boolean isParticleOptional(ParticleComponent memberParticle) {
        return memberParticle.occursZeroOrOne();
    }

    protected boolean isInvalidEnumerationLabel(String s) {
        if (s == null || s.equals("") || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return true;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return this._env.getNames().isJavaReservedWord(s);
    }

    protected boolean checkStrictCompliance(QName typeName) {
        boolean ret = true;
        if (this._strictCompliance && typeName != null && (typeName.equals(SchemaConstants.QNAME_TYPE_IDREF) || typeName.equals(SchemaConstants.QNAME_TYPE_URTYPE))) {
            this.fail("model.schema.unsupportedSchemaType", new Object[]{typeName});
            return false;
        }
        return true;
    }

    protected LiteralType handleIDIDREF(SimpleTypeDefinitionComponent component) {
        LiteralIDType baseType = new LiteralIDType(component.getName());
        baseType.setSchemaTypeRef(component.getName());
        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
        baseType.setJavaType(javaType);
        baseType.setResolveIDREF(this._resolveIDREF);
        return baseType;
    }

    public LiteralType schemaElementTypeToLiteralType(QName elementName) {
        try {
            ElementDeclarationComponent component = this._schema.findElementDeclaration(elementName);
            String mappingNameHint = null;
            mappingNameHint = component.getTypeDefinition().getName() == null ? ">" + elementName.getLocalPart() : component.getTypeDefinition().getName().getLocalPart();
            LiteralType literalType = this.schemaTypeToLiteralType(component.getTypeDefinition(), elementName, mappingNameHint);
            if (literalType.getName() == null) {
                literalType.setName(this.getUniqueTypeNameForElement(elementName));
            }
            if (component.isNillable()) {
                LiteralSimpleType result = (LiteralSimpleType)this._nillableSimpleTypeComponentToLiteralTypeMap.get(component.getTypeDefinition());
                if (result == null) {
                    JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(component.getTypeDefinition().getName());
                    if (javaType == null && literalType instanceof LiteralSimpleType) {
                        javaType = (JavaSimpleType)((LiteralSimpleType)literalType).getJavaType();
                    }
                    if (javaType != null) {
                        result = new LiteralSimpleType(component.getTypeDefinition().getName(), javaType, true);
                        result.setSchemaTypeRef(component.getTypeDefinition().getName());
                        this._nillableSimpleTypeComponentToLiteralTypeMap.put(component.getTypeDefinition(), result);
                        return result;
                    }
                } else {
                    literalType = result;
                }
            }
            return literalType;
        }
        catch (UnimplementedFeatureException e) {
            LiteralFragmentType literalType = new LiteralFragmentType();
            literalType.setName(elementName);
            literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalType;
        }
    }

    public LiteralType schemaTypeToLiteralType(QName typeName) {
        try {
            TypeDefinitionComponent component = this._schema.findTypeDefinition(typeName);
            return this.schemaTypeToLiteralType(component, typeName);
        }
        catch (UnimplementedFeatureException e) {
            LiteralFragmentType literalType = new LiteralFragmentType();
            literalType.setName(typeName);
            literalType.setSchemaTypeRef(typeName);
            literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalType;
        }
    }

    protected SOAPCustomType getCustomTypeFor(TypeDefinitionComponent component) {
        TypeMappingInfo tmi;
        QName typeName = component.getName();
        if (typeName == null) {
            return null;
        }
        SOAPCustomType customType = (SOAPCustomType)this._typeNameToCustomSOAPTypeMap.get(typeName);
        if (customType == null && this._modelInfo.getTypeMappingRegistry() != null && (tmi = this._modelInfo.getTypeMappingRegistry().getTypeMappingInfo(soap11NamespaceConstants.getEncoding(), typeName)) != null) {
            customType = new SOAPCustomType(typeName);
            JavaCustomType javaCustomType = new JavaCustomType(tmi.getJavaTypeName(), tmi);
            customType.setJavaType(javaCustomType);
            this._typeNameToCustomSOAPTypeMap.put(typeName, customType);
        }
        return customType;
    }

    protected SOAPCustomType mustGetCustomTypeFor(TypeDefinitionComponent component) {
        SOAPCustomType type = this.getCustomTypeFor(component);
        if (type == null) {
            this.fail("model.schema.unsupportedSchemaType", new Object[]{component.getName()});
        }
        return type;
    }

    protected SOAPSimpleType createSOAPSimpleType(SimpleTypeDefinitionComponent component) {
        SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
        simpleType.setSchemaTypeRef(component.getName());
        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
        if (javaType == null) {
            this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
        }
        simpleType.setJavaType(javaType);
        this.setReferenceable(simpleType);
        return simpleType;
    }

    protected SOAPType nillableSchemaTypeToSOAPType(TypeDefinitionComponent component) {
        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(component.getName());
        if (javaType == null) {
            return this.schemaTypeToSOAPType(component, component.getName());
        }
        SOAPSimpleType result = (SOAPSimpleType)this._nillableSimpleTypeComponentToSOAPTypeMap.get(component);
        if (result != null) {
            return result;
        }
        result = new SOAPSimpleType(component.getName(), javaType);
        result.setSchemaTypeRef(component.getName());
        this.setReferenceable(result);
        this._nillableSimpleTypeComponentToSOAPTypeMap.put(component, result);
        return result;
    }

    public SOAPType schemaTypeToSOAPType(QName typeName) {
        try {
            TypeDefinitionComponent component = this._schema.findTypeDefinition(typeName);
            return this.schemaTypeToSOAPType(component, typeName);
        }
        catch (UnimplementedFeatureException e) {
            this.fail("model.schema.unsupportedSchemaType", new Object[]{typeName});
            return null;
        }
    }

    protected void fail(String key, Object[] arg) {
        throw new ModelException(key, arg);
    }

    protected void warn(String key, Object[] args) {
        this._env.warn(this._messageFactory.getMessage(key, args));
    }

    protected void resolveNamingConflictsFor(JavaType javaType, String suffix) {
        if (this._conflictingClassNames != null && this._conflictingClassNames.contains(javaType.getName()) && javaType.getName().equals(javaType.getRealName())) {
            javaType.doSetName(javaType.getName() + suffix);
        }
    }

    protected String getUniqueNCNameFor(TypeDefinitionComponent component) {
        if (component.getName() != null) {
            return component.getName().getLocalPart();
        }
        return "genType-" + this.getUniqueID();
    }

    private String getJavaPackageName(QName name) {
        NamespaceMappingInfo i;
        String packageName = null;
        if (this._modelInfo.getNamespaceMappingRegistry() != null && (i = this._modelInfo.getNamespaceMappingRegistry().getNamespaceMappingInfo(name)) != null) {
            return i.getJavaPackageName();
        }
        return packageName;
    }

    protected void failUnsupported(String code, QName arg) {
        this.fail("model.schema.unsupportedType", code, arg);
    }

    protected QName getUniqueTypeNameForElement(QName elementName) {
        return new QName(elementName.getNamespaceURI(), elementName.getLocalPart() + "-AnonType-" + this.getUniqueID());
    }

    protected QName makePackageQualified(QName name) {
        return new QName(name.getNamespaceURI(), this.makePackageQualified(name.getLocalPart(), name));
    }

    protected J2EEModelInfo.JavaMemberInfo getJavaMemberInfo(TypeDefinitionComponent component, ElementDeclarationComponent element) {
        return new J2EEModelInfo.JavaMemberInfo(element.getName().getLocalPart(), false);
    }

    protected J2EEModelInfo.JavaMemberInfo getJavaMemberOfElementInfo(QName typeName, String memberName) {
        return new J2EEModelInfo.JavaMemberInfo(this._env.getNames().validJavaMemberName(memberName), false);
    }

    private void processSuperType(LiteralStructuredType parentType, LiteralStructuredType structureType, JavaStructureType javaStructureType) {
        if (parentType != null) {
            Iterator iter = parentType.getElementMembers();
            while (iter.hasNext()) {
                LiteralElementMember member = (LiteralElementMember)iter.next();
                LiteralElementMember inheritedMember = new LiteralElementMember(member.getName(), member.getType());
                inheritedMember.setNillable(member.isNillable());
                inheritedMember.setInherited(true);
                inheritedMember.setRepeated(member.isRepeated());
                JavaStructureMember javaMember = member.getJavaStructureMember();
                JavaStructureMember inheritedJavaMember = new JavaStructureMember(javaMember.getName(), javaMember.getType(), inheritedMember, false);
                inheritedJavaMember.setInherited(true);
                inheritedJavaMember.setReadMethod(javaMember.getReadMethod());
                inheritedJavaMember.setWriteMethod(javaMember.getWriteMethod());
                inheritedMember.setJavaStructureMember(inheritedJavaMember);
                structureType.add(inheritedMember);
                javaStructureType.add(inheritedJavaMember);
            }
            parentType.addSubtype(structureType);
            ((JavaStructureType)parentType.getJavaType()).addSubclass(javaStructureType);
        }
    }

    protected LiteralFragmentType getLiteralFragmentTypeFor(TypeDefinitionComponent component, QName nameHint) {
        LiteralFragmentType literalType = new LiteralFragmentType();
        literalType.setName(this.getUniqueQNameFor(component, nameHint));
        literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
        return literalType;
    }

    protected LiteralType complexSchemaTypeSimpleContentExtensionToLiteralType(ComplexTypeDefinitionComponent component, QName nameHint) {
        LiteralType baseType = this.schemaTypeToLiteralType(component.getBaseTypeDefinition(), nameHint);
        if (SimpleTypeSerializerWriter.getTypeEncoder(baseType) == null) {
            return this.getLiteralFragmentTypeFor(component, nameHint);
        }
        LiteralSequenceType structureType = new LiteralSequenceType(this.getUniqueQNameFor(component, nameHint));
        JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
        this.resolveNamingConflictsFor(javaStructureType);
        structureType.setJavaType(javaStructureType);
        this._componentToLiteralTypeMap.put(component, structureType);
        Iterator iter = component.attributeUses();
        while (iter.hasNext()) {
            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
            LiteralType attributeType = this.schemaTypeToLiteralType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
            if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null && !(attributeType instanceof LiteralEnumerationType)) {
                return this.getLiteralFragmentTypeFor(component, nameHint);
            }
            if (attributeDeclaration.getName().getLocalPart().equals(VALUE_MEMBER_NAME)) {
                throw new ModelException("model.complexType.simpleContent.reservedName", structureType.getName().getLocalPart());
            }
            LiteralAttributeMember member = new LiteralAttributeMember(attributeDeclaration.getName(), attributeType);
            if (attributeUse.isRequired()) {
                member.setRequired(true);
            }
            JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(attributeDeclaration.getName().getLocalPart()), attributeType.getJavaType(), member, false);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaStructureType.add(javaMember);
            structureType.add(member);
        }
        LiteralContentMember member = new LiteralContentMember(baseType);
        JavaStructureMember javaMember = new JavaStructureMember(VALUE_MEMBER_NAME, baseType.getJavaType(), member, false);
        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
        member.setJavaStructureMember(javaMember);
        javaStructureType.add(javaMember);
        structureType.setContentMember(member);
        return structureType;
    }

    protected LiteralType getIDREFLiteralType(SimpleTypeDefinitionComponent component, QName nameHint) {
        LiteralIDType baseType = new LiteralIDType(component.getName());
        baseType.setSchemaTypeRef(component.getName());
        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
        baseType.setJavaType(javaType);
        baseType.setResolveIDREF(this._resolveIDREF);
        if (!this._resolveIDREF) {
            return baseType;
        }
        LiteralSequenceType structureType = new LiteralSequenceType(this.getUniqueQNameFor(new SimpleTypeDefinitionComponent(), nameHint));
        LiteralContentMember member = new LiteralContentMember(baseType);
        JavaStructureMember javaMember = new JavaStructureMember(VALUE_MEMBER_NAME, baseType.getJavaType(), member, false);
        JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
        this.resolveNamingConflictsFor(javaStructureType);
        structureType.setJavaType(javaStructureType);
        this._componentToLiteralTypeMap.put(component, structureType);
        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
        member.setJavaStructureMember(javaMember);
        javaStructureType.add(javaMember);
        structureType.setContentMember(member);
        return structureType;
    }

    protected LiteralType listToLiteralType(SimpleTypeDefinitionComponent component, QName nameHint) {
        LiteralType itemLiteralType = null;
        SimpleTypeDefinitionComponent itemType = component.getItemTypeDefinition();
        if (component.getName() != null && itemType.getName() != null && component.getName().equals(itemType.getName())) {
            this.fail("model.schema.invalidSimpleType.invalidItemType", new Object[]{component.getName(), itemType.getName()});
        }
        if ((itemLiteralType = this.schemaTypeToLiteralType(itemType.getName() == null ? itemType.getBaseTypeDefinition().getName() : itemType.getName())) != null) {
            JavaArrayType javaArrayType = new JavaArrayType(itemLiteralType.getJavaType().getName() + "[]");
            javaArrayType.setElementType(itemLiteralType.getJavaType());
            JavaArrayType javaMemberType = javaArrayType;
            QName componentName = component.getName();
            if (componentName == null) {
                componentName = new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "_Type");
            }
            return new LiteralListType(componentName, itemLiteralType, javaMemberType);
        }
        this.fail("model.schema.invalidSimpleType.noItemLiteralType", new Object[]{component.getName(), itemType.getName()});
        return null;
    }

    protected LiteralType simpleSchemaTypeToLiteralType(SimpleTypeDefinitionComponent component, QName nameHint) {
        return this.simpleSchemaTypeToLiteralType(component, nameHint, null);
    }

    protected LiteralType getLiteralSimpleStringTypeFor(TypeDefinitionComponent component, QName nameHint) {
        LiteralSimpleType literalType = new LiteralSimpleType(this.getUniqueQNameFor(component, nameHint));
        literalType.setJavaType(this.javaTypes.STRING_JAVATYPE);
        return literalType;
    }

    protected LiteralType schemaTypeToLiteralType(TypeDefinitionComponent component, QName nameHint) {
        return this.schemaTypeToLiteralType(component, nameHint, null);
    }

    protected SOAPType complexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component, QName nameHint) {
        JavaSimpleType javaType;
        SOAPCustomType userDefinedType = this.getCustomTypeFor(component);
        if (userDefinedType != null) {
            return userDefinedType;
        }
        if (component == this._schema.getUrType()) {
            if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                if (this._strictCompliance && !this.checkStrictCompliance(component.getName())) {
                    return null;
                }
                SOAPAnyType anyType = new SOAPAnyType(component.getName());
                JavaSimpleType javaType2 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                if (javaType2 == null) {
                    this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
                }
                anyType.setJavaType(javaType2);
                return anyType;
            }
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            JavaSimpleType javaType3 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType3 == null) {
                this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
            }
            simpleType.setJavaType(javaType3);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getName() != null && component.getName().equals(soap11WSDLConstants.getQNameTypeArray())) {
            SOAPType anyType = this.schemaTypeToSOAPType(SchemaConstants.QNAME_TYPE_URTYPE);
            SOAPArrayType arrayType = new SOAPArrayType(component.getName());
            arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
            arrayType.setElementType(anyType);
            arrayType.setRank(1);
            arrayType.setSize(null);
            JavaArrayType javaArrayType = new JavaArrayType(anyType.getJavaType().getName() + "[]");
            javaArrayType.setElementType(anyType.getJavaType());
            arrayType.setJavaType(javaArrayType);
            return arrayType;
        }
        if (component.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToSOAPType(component, nameHint);
        }
        if (component.getBaseTypeDefinition().getName() != null && component.getBaseTypeDefinition().getName().equals(soap11WSDLConstants.getQNameTypeArray())) {
            return this.soapArrayBasedComplexSchemaTypeToSOAPType(component, nameHint);
        }
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getDerivationMethod() == Symbol.EXTENSION) {
            SOAPType parentType = this.schemaTypeToSOAPType(component.getBaseTypeDefinition(), nameHint);
            if (parentType instanceof SOAPStructureType) {
                return this.soapStructureExtensionComplexSchemaTypeToSOAPType(component, (SOAPStructureType)parentType, nameHint);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType soapArrayBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component, QName nameHint) {
        JavaSimpleType javaType;
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        boolean found = false;
        Iterator iter = component.attributeUses();
        while (iter.hasNext()) {
            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
            if (attributeDeclaration.getName() == null || !attributeDeclaration.getName().equals(soap11WSDLConstants.getQNameAttrArrayType())) continue;
            if (found) {
                return this.mustGetCustomTypeFor(component);
            }
            found = true;
            Iterator iter2 = attributeUse.getAnnotation().attributes();
            while (iter2.hasNext()) {
                SchemaAttribute attr = (SchemaAttribute)iter2.next();
                if (!attr.getQName().equals(WSDLConstants.QNAME_ATTR_ARRAY_TYPE)) continue;
                String typeSpecifier = attr.getValue();
                if (typeSpecifier == null) {
                    throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"}));
                }
                return this.processSOAPArrayType(component, attr.getParent(), attr.getValue());
            }
        }
        if (component.getContentTag() == 4) {
            ParticleComponent particle = component.getParticleContent();
            if (particle.occursOnce()) {
                if (particle.getTermTag() == 1) {
                    ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                    if (modelGroup.getCompositor() == Symbol.SEQUENCE) {
                        SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                        found = false;
                        Iterator iter2 = modelGroup.particles();
                        while (iter2.hasNext()) {
                            ParticleComponent memberParticle = (ParticleComponent)iter2.next();
                            if (found) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            found = true;
                            if (memberParticle.mayOccurMoreThanOnce()) {
                                if (memberParticle.getTermTag() == 3) {
                                    ElementDeclarationComponent element = memberParticle.getElementTerm();
                                    SOAPType arrayElementType = this.schemaTypeToSOAPType(element.getTypeDefinition(), nameHint);
                                    arrayType.setElementName(element.getName());
                                    arrayType.setElementType(arrayElementType);
                                    arrayType.setRank(1);
                                    if (arrayElementType.getJavaType() == null) continue;
                                    JavaArrayType javaArrayType = new JavaArrayType(arrayElementType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(arrayElementType.getJavaType());
                                    arrayType.setJavaType(javaArrayType);
                                    continue;
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            return this.mustGetCustomTypeFor(component);
                        }
                        if (found) {
                            return arrayType;
                        }
                        return this.mustGetCustomTypeFor(component);
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType urTypeBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component, QName nameHint) {
        JavaSimpleType javaType;
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getContentTag() == 4) {
            ParticleComponent particle = component.getParticleContent();
            if (particle.occursOnce()) {
                if (particle.getTermTag() == 1) {
                    ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                    if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                        SOAPStructureType structureType = null;
                        structureType = modelGroup.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(this.getUniqueQNameFor(component, nameHint)) : new SOAPOrderedStructureType(this.getUniqueQNameFor(component, nameHint));
                        String javaTypeName = this.getJavaNameOfSOAPStructureType(structureType, component, nameHint);
                        JavaStructureType javaStructureType = new JavaStructureType(javaTypeName, false, structureType);
                        this.resolveNamingConflictsFor(javaStructureType);
                        structureType.setJavaType(javaStructureType);
                        this._componentToSOAPTypeMap.put(component, structureType);
                        Iterator iter = component.attributeUses();
                        while (iter.hasNext()) {
                            JavaSimpleType javaType2;
                            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                            if (attributeDeclaration.getTypeDefinition().getName() != null && this._strictCompliance && attributeDeclaration.getTypeDefinition().getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            SOAPType attributeType = this.schemaTypeToSOAPType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                            if (this.isAttributeOptional(attributeUse) && (javaType2 = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(attributeDeclaration.getTypeDefinition().getName())) != null) {
                                SOAPSimpleType result = (SOAPSimpleType)this._nillableSimpleTypeComponentToSOAPTypeMap.get(attributeDeclaration.getTypeDefinition());
                                if (result == null) {
                                    result = new SOAPSimpleType(attributeDeclaration.getTypeDefinition().getName(), javaType2, true);
                                    result.setSchemaTypeRef(attributeDeclaration.getTypeDefinition().getName());
                                    this._nillableSimpleTypeComponentToSOAPTypeMap.put(attributeDeclaration.getTypeDefinition(), result);
                                }
                                if (result != null) {
                                    attributeType = result;
                                }
                            }
                            if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null && !this.isAttributeEnumeration(attributeType)) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            SOAPAttributeMember member = new SOAPAttributeMember(attributeDeclaration.getName(), attributeType);
                            if (attributeUse.isRequired()) {
                                member.setRequired(true);
                            }
                            J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberOfElementInfo(nameHint, attributeDeclaration.getName().getLocalPart());
                            JavaStructureMember javaMember = new JavaStructureMember(memberInfo.javaMemberName, attributeType.getJavaType(), member, memberInfo.isDataMember);
                            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                            member.setJavaStructureMember(javaMember);
                            javaStructureType.add(javaMember);
                            structureType.add(member);
                        }
                        Iterator iter2 = modelGroup.particles();
                        while (iter2.hasNext()) {
                            ParticleComponent memberParticle = (ParticleComponent)iter2.next();
                            if (memberParticle.occursOnce() || memberParticle.occursAtMostOnce()) {
                                if (memberParticle.getTermTag() == 3) {
                                    ElementDeclarationComponent element = memberParticle.getElementTerm();
                                    SOAPType memberType = this.getSOAPMemberType(component, structureType, element, nameHint, memberParticle.occursZeroOrOne());
                                    SOAPStructureMember member = new SOAPStructureMember(element.getName(), memberType);
                                    J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberInfo(component, element);
                                    JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(memberInfo.javaMemberName), memberType.getJavaType(), member, memberInfo.isDataMember);
                                    javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                    javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                    member.setJavaStructureMember(javaMember);
                                    javaStructureType.add(javaMember);
                                    structureType.add(member);
                                    continue;
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            return this.mustGetCustomTypeFor(component);
                        }
                        structureType.setJavaType(javaStructureType);
                        return structureType;
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 1) {
            SOAPOrderedStructureType structureType = new SOAPOrderedStructureType(component.getName());
            String javaName = this.getJavaNameOfType(component, component.getName());
            JavaStructureType javaStructureType = new JavaStructureType(javaName, false, structureType);
            structureType.setJavaType(javaStructureType);
            this._componentToLiteralTypeMap.put(component, structureType);
            Iterator iter = component.attributeUses();
            while (iter.hasNext()) {
                AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                SOAPType attributeType = this.schemaTypeToSOAPType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null) {
                    return this.mustGetCustomTypeFor(component);
                }
                SOAPAttributeMember member = new SOAPAttributeMember(attributeDeclaration.getName(), attributeType);
                if (attributeUse.isRequired()) {
                    member.setRequired(true);
                }
                J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberOfElementInfo(nameHint, attributeDeclaration.getName().getLocalPart());
                JavaStructureMember javaMember = new JavaStructureMember(memberInfo.javaMemberName, attributeType.getJavaType(), member, memberInfo.isDataMember);
                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                member.setJavaStructureMember(javaMember);
                javaStructureType.add(javaMember);
                structureType.add(member);
            }
            return structureType;
        }
        if (component.getContentTag() == 2) {
            if (component.hasNoAttributeUses()) {
                if (component.getName().getNamespaceURI().equals(soap11WSDLConstants.getSOAPEncodingNamespace())) {
                    SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                    simpleType.setSchemaTypeRef(component.getName());
                    JavaSimpleType javaType3 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                    if (javaType3 == null) {
                        this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
                    }
                    simpleType.setJavaType(javaType3);
                    this.setReferenceable(simpleType);
                    return simpleType;
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType listToSOAPType(SimpleTypeDefinitionComponent component, QName nameHint) {
        SOAPType itemSOAPType = null;
        SimpleTypeDefinitionComponent itemType = component.getItemTypeDefinition();
        if (component.getName() != null && itemType.getName() != null && component.getName().equals(itemType.getName())) {
            this.fail("model.schema.invalidSimpleType.invalidItemType", new Object[]{component.getName(), itemType.getName()});
        }
        if ((itemSOAPType = this.schemaTypeToSOAPType(itemType.getName() == null ? itemType.getBaseTypeDefinition().getName() : itemType.getName())) != null) {
            JavaArrayType javaArrayType = new JavaArrayType(itemSOAPType.getJavaType().getName() + "[]");
            javaArrayType.setElementType(itemSOAPType.getJavaType());
            JavaArrayType javaMemberType = javaArrayType;
            QName componentName = component.getName();
            if (componentName == null) {
                componentName = new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "_Type");
            }
            return new SOAPListType(componentName, itemSOAPType, javaMemberType);
        }
        this.fail("model.schema.invalidSimpleType.noItemLiteralType", new Object[]{component.getName(), itemType.getName()});
        return null;
    }

    protected SOAPType simpleSchemaTypeToSOAPType(SimpleTypeDefinitionComponent component, QName nameHint) {
        if (component.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (component.getVarietyTag() == 1) {
                String nsURI = component.getName().getNamespaceURI();
                if (nsURI != null && (nsURI.equals("http://www.w3.org/2001/XMLSchema") || nsURI.equals(soap11WSDLConstants.getSOAPEncodingNamespace()))) {
                    if (!component.facets().hasNext()) {
                        if (this._strictCompliance && (component.getName().equals(SchemaConstants.QNAME_TYPE_IDREF) || component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) && !this.checkStrictCompliance(component.getName())) {
                            return null;
                        }
                        if (!this._strictCompliance && component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            SOAPAnyType anyType = new SOAPAnyType(component.getName());
                            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                            if (javaType == null) {
                                this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
                            }
                            anyType.setJavaType(javaType);
                            return anyType;
                        }
                        return this.createSOAPSimpleType(component);
                    }
                    this.fail("model.schema.simpleTypeWithFacets", new Object[]{component.getName(), component.facets().next()});
                } else {
                    this.fail("model.schema.invalidSimpleType", new Object[]{component.getName()});
                }
            } else if (component.getVarietyTag() == 2) {
                if (this.doWeHandleSimpleSchemaTypeDerivationByList()) {
                    return this.listToSOAPType(component, nameHint);
                }
                this.fail("model.schema.listNotSupported", new Object[]{component.getName()});
            } else if (component.getVarietyTag() == 3) {
                this.fail("model.schema.unionNotSupported", new Object[]{component.getName()});
            } else {
                if (component.getName().equals(SchemaConstants.QNAME_TYPE_SIMPLE_URTYPE)) {
                    return this.createSOAPSimpleType(component);
                }
                this.fail("model.schema.invalidSimpleType", new Object[]{component.getName()});
            }
        } else {
            Iterator values;
            Facet facet;
            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType != null) {
                SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                simpleType.setSchemaTypeRef(component.getName());
                simpleType.setJavaType(javaType);
                this.setReferenceable(simpleType);
                return simpleType;
            }
            SimpleTypeDefinitionComponent baseTypeComponent = component.getBaseTypeDefinition();
            Iterator iter = component.facets();
            if (iter.hasNext() && component.getVarietyTag() == 1 && (facet = (Facet)iter.next()) instanceof EnumerationFacet && (values = ((EnumerationFacet)facet).values()).hasNext()) {
                if (this._jaxbEnumType && component.getName() == null) {
                    String nsURI = baseTypeComponent.getName().getNamespaceURI();
                    if (nsURI != null) {
                        return this.schemaTypeToSOAPType(baseTypeComponent, nameHint);
                    }
                    this.fail("model.schema.invalidSimpleType.noNamespaceURI", new Object[]{component.getName()});
                }
                return this.enumerationToSOAPType(component, (EnumerationFacet)facet, nameHint);
            }
            if (component.getVarietyTag() == 1) {
                String nsURI = baseTypeComponent.getName().getNamespaceURI();
                if (nsURI != null) {
                    SOAPType baseType = this.schemaTypeToSOAPType(baseTypeComponent, nameHint);
                    return baseType;
                }
                this.fail("model.schema.invalidSimpleType.noNamespaceURI", new Object[]{component.getName()});
            } else if (component.getVarietyTag() == 2) {
                if (this.doWeHandleSimpleSchemaTypeDerivationByList()) {
                    return this.listToSOAPType(component, nameHint);
                }
                this.fail("model.schema.listNotSupported", new Object[]{component.getName()});
            } else {
                this.fail("model.schema.unionNotSupported", new Object[]{component.getName()});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOAPType schemaTypeToSOAPType(TypeDefinitionComponent component, QName nameHint) {
        SOAPType result = (SOAPType)this._componentToSOAPTypeMap.get(component);
        if (result == null) {
            try {
                if (component.isSimple()) {
                    result = this.simpleSchemaTypeToSOAPType((SimpleTypeDefinitionComponent)component, nameHint);
                } else if (component.isComplex()) {
                    result = this.complexSchemaTypeToSOAPType((ComplexTypeDefinitionComponent)component, nameHint);
                } else {
                    throw new IllegalArgumentException();
                }
                this._componentToSOAPTypeMap.put(component, result);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        return result;
    }

    protected String getUniqueMemberName(JavaStructureType javaStructureType, String prefix) {
        String name;
        JavaStructureMember member = javaStructureType.getMemberByName(prefix);
        if (member == null) {
            return prefix;
        }
        int i = 2;
        while (javaStructureType.getMemberByName(name = prefix + Integer.toString(i)) != null) {
        }
        return name;
    }

    protected String getElementMappingNameHint(ElementDeclarationComponent component, String mappingNameHint) {
        String hint = mappingNameHint + ">" + component.getName().getLocalPart();
        if (component.getTypeDefinition().getName() == null) {
            hint = ">" + hint;
        }
        return hint;
    }

    protected String getJavaNameOfType(TypeDefinitionComponent component, QName nameHint) {
        QName componentName = component.getName();
        if (componentName == null) {
            componentName = new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart());
        }
        return this.makePackageQualified(this._env.getNames().validJavaClassName(componentName.getLocalPart()), componentName);
    }

    protected String makePackageQualified(String s, QName name) {
        String javaPackageName = this.getJavaPackageName(name);
        if (javaPackageName != null) {
            return javaPackageName + "." + s;
        }
        if (this._modelInfo.getJavaPackageName() != null && !this._modelInfo.getJavaPackageName().equals("")) {
            return this._modelInfo.getJavaPackageName() + "." + s;
        }
        return s;
    }

    protected void fail(String key, String code, QName arg) {
        if (arg == null) {
            throw new ModelException(key + ".anonymous", code);
        }
        throw new ModelException(key, new Object[]{code, arg.getLocalPart(), arg.getNamespaceURI()});
    }

    private QName valueToQName(String str, Map prefixes) throws Exception {
        if (str == null) {
            return null;
        }
        String uri = "";
        String prefix = XmlUtil.getPrefix(str = EncoderUtils.collapseWhitespace(str));
        if (prefix != null && (uri = (String)prefixes.get(prefix)) == null) {
            throw new DeserializationException("xsd.unknownPrefix", prefix);
        }
        String localPart = XmlUtil.getLocalPart(str);
        return new QName(uri, localPart);
    }

    protected QName getAttributeQNameHint(AttributeDeclarationComponent component, QName nameHint) {
        return new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-" + component.getName().getLocalPart());
    }

    protected QName getElementQNameHint(ElementDeclarationComponent component, QName nameHint) {
        QName componentName = component.getName();
        if (!componentName.getNamespaceURI().equals("")) {
            return componentName;
        }
        return new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-" + componentName.getLocalPart());
    }

    protected QName getUniqueQNameFor(TypeDefinitionComponent component, QName nameHint) {
        if (component.getName() != null) {
            return component.getName();
        }
        QName result = null;
        if (nameHint != null) {
            result = !this._namePool.contains(nameHint) ? nameHint : new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-gen-" + this.getUniqueID());
        }
        this._namePool.add(result);
        return result;
    }

    protected QName getUniqueLiteralArrayTypeQNameFor(QName subTypeName, QName nameHint) {
        return new QName(subTypeName.getNamespaceURI(), subTypeName.getLocalPart() + "-Array-" + this.getUniqueID());
    }

    protected LiteralType complexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent component, QName nameHint, String mappingNameHint) {
        if (component == this._schema.getUrType()) {
            if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                if (this._strictCompliance && !this.checkStrictCompliance(component.getName())) {
                    return null;
                }
                LiteralFragmentType literalType = new LiteralFragmentType();
                literalType.setName(component.getName());
                literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
                return literalType;
            }
            LiteralSimpleType simpleType = new LiteralSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType == null) {
                return this.getLiteralFragmentTypeFor(component, nameHint);
            }
            simpleType.setJavaType(javaType);
            return simpleType;
        }
        if (component.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToLiteralType(component, nameHint, mappingNameHint);
        }
        if (this.doWeHandleComplexSchemaTypeExtensionBySimpleContent() && component.getContentTag() == 2 && component.getDerivationMethod() == Symbol.EXTENSION) {
            return this.complexSchemaTypeSimpleContentExtensionToLiteralType(component, nameHint);
        }
        if (this.doWeHandleComplexSchemaTypeExtensionByComplexType() && component.getContentTag() == 4 && component.getDerivationMethod() == Symbol.EXTENSION) {
            return this.urTypeBasedComplexSchemaTypeToLiteralType(component, nameHint, mappingNameHint);
        }
        return this.getLiteralFragmentTypeFor(component, nameHint);
    }

    protected LiteralType urTypeBasedComplexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent component, QName nameHint, String mappingNameHint) {
        if (component.getContentTag() == 4) {
            ParticleComponent particle = component.getParticleContent();
            if (particle.occursOnce()) {
                if (particle.getTermTag() == 1) {
                    ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                    if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                        LiteralType parentType;
                        LiteralStructuredType structureType = null;
                        structureType = modelGroup.getCompositor() == Symbol.ALL ? new LiteralAllType(this.getUniqueQNameFor(component, nameHint)) : new LiteralSequenceType(this.getUniqueQNameFor(component, nameHint));
                        if (component.getName() == null) {
                            structureType.setProperty("com.sun.xml.rpc.processor.model.AnonymousTypeName", mappingNameHint);
                        }
                        String javaName = this.getJavaNameOfElementType(structureType, component, nameHint);
                        JavaStructureType javaStructureType = new JavaStructureType(javaName, false, structureType);
                        this.resolveNamingConflictsFor(javaStructureType);
                        structureType.setJavaType(javaStructureType);
                        this._componentToLiteralTypeMap.put(component, structureType);
                        if (this.doWeHandleComplexSchemaTypeExtensionByComplexType() && component.getContentTag() == 4 && component.getDerivationMethod() == Symbol.EXTENSION && (parentType = this.schemaTypeToLiteralType(component.getBaseTypeDefinition(), new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "_Base"))) instanceof LiteralStructuredType) {
                            this.processSuperType((LiteralStructuredType)parentType, structureType, javaStructureType);
                        }
                        Iterator iter = component.attributeUses();
                        while (iter.hasNext()) {
                            JavaSimpleType javaType;
                            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                            if (attributeDeclaration.getTypeDefinition().getName() != null && this._strictCompliance && attributeDeclaration.getTypeDefinition().getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) {
                                return this.getLiteralFragmentTypeFor(attributeDeclaration.getTypeDefinition(), SchemaConstants.QNAME_TYPE_IDREF);
                            }
                            LiteralType attributeType = this.schemaTypeToLiteralType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                            if (this.isAttributeOptional(attributeUse) && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(attributeDeclaration.getTypeDefinition().getName())) != null) {
                                LiteralSimpleType result = (LiteralSimpleType)this._nillableSimpleTypeComponentToLiteralTypeMap.get(attributeDeclaration.getTypeDefinition());
                                if (result == null) {
                                    result = new LiteralSimpleType(attributeDeclaration.getTypeDefinition().getName(), javaType, true);
                                    result.setSchemaTypeRef(attributeDeclaration.getTypeDefinition().getName());
                                    this._nillableSimpleTypeComponentToLiteralTypeMap.put(attributeDeclaration.getTypeDefinition(), result);
                                }
                                if (result != null) {
                                    attributeType = result;
                                }
                            }
                            if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null && !this.isAttributeEnumeration(attributeType)) {
                                return this.getLiteralFragmentTypeFor(component, nameHint);
                            }
                            LiteralAttributeMember member = new LiteralAttributeMember(attributeDeclaration.getName(), attributeType);
                            if (attributeUse.isRequired()) {
                                member.setRequired(true);
                            }
                            J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberOfElementInfo(nameHint, attributeDeclaration.getName().getLocalPart());
                            JavaStructureMember javaMember = new JavaStructureMember(memberInfo.javaMemberName, attributeType.getJavaType(), member, memberInfo.isDataMember);
                            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                            member.setJavaStructureMember(javaMember);
                            javaStructureType.add(javaMember);
                            structureType.add(member);
                        }
                        Iterator iter2 = modelGroup.particles();
                        while (iter2.hasNext()) {
                            JavaStructureMember javaMember;
                            ParticleComponent memberParticle = (ParticleComponent)iter2.next();
                            if (memberParticle.doesNotOccur()) continue;
                            if (memberParticle.getTermTag() == 3) {
                                JavaSimpleType javaType;
                                ElementDeclarationComponent element = memberParticle.getElementTerm();
                                if (element.getTypeDefinition().getName() != null && this._strictCompliance && (element.getTypeDefinition().getName().equals(SchemaConstants.QNAME_TYPE_IDREF) || element.getTypeDefinition().getName().equals(SchemaConstants.QNAME_TYPE_URTYPE))) {
                                    return this.getLiteralFragmentTypeFor(element.getTypeDefinition(), SchemaConstants.QNAME_TYPE_IDREF);
                                }
                                LiteralType memberType = null;
                                memberType = element.getTypeDefinition().getName() != null ? this.schemaTypeToLiteralType(element.getTypeDefinition(), this.getElementQNameHint(element, nameHint)) : this.schemaTypeToLiteralType(element.getTypeDefinition(), this.getElementQNameHint(element, nameHint), this.getElementMappingNameHint(element, mappingNameHint));
                                memberType = this.getLiteralMemberType(component, memberType, element, structureType);
                                LiteralElementMember member = new LiteralElementMember(element.getName(), memberType);
                                JavaType javaMemberType = null;
                                if ((element.isNillable() || this.isParticleOptional(memberParticle)) && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(element.getTypeDefinition().getName())) != null) {
                                    LiteralSimpleType result = (LiteralSimpleType)this._nillableSimpleTypeComponentToLiteralTypeMap.get(element.getTypeDefinition());
                                    if (result == null) {
                                        result = new LiteralSimpleType(element.getTypeDefinition().getName(), javaType, true);
                                        result.setSchemaTypeRef(element.getTypeDefinition().getName());
                                        this._nillableSimpleTypeComponentToLiteralTypeMap.put(element.getTypeDefinition(), result);
                                    }
                                    memberType = result;
                                    if (this.doMakeMemberBoxedType()) {
                                        member.setType(memberType);
                                    }
                                }
                                if (element.isNillable()) {
                                    member.setNillable(true);
                                }
                                if (memberParticle.occursAtLeastOnce()) {
                                    member.setRequired(true);
                                }
                                if (memberParticle.mayOccurMoreThanOnce()) {
                                    member.setRepeated(true);
                                    JavaArrayType javaArrayType = new JavaArrayType(memberType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(memberType.getJavaType());
                                    javaMemberType = javaArrayType;
                                    String n = this.getJ2EEAnonymousArrayTypeName(memberParticle, element, mappingNameHint);
                                    structureType.setProperty("com.sun.xml.rpc.processor.model.AnonymousArrayTypeName", n);
                                    structureType.setProperty("com.sun.xml.rpc.processor.model.AnonymousArrayJavaType", javaMemberType.getName());
                                } else {
                                    javaMemberType = memberType.getJavaType();
                                }
                                J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberOfElementInfo(nameHint, element.getName().getLocalPart());
                                javaMember = new JavaStructureMember(memberInfo.javaMemberName, javaMemberType, member, memberInfo.isDataMember);
                                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                member.setJavaStructureMember(javaMember);
                                javaStructureType.add(javaMember);
                                structureType.add(member);
                                continue;
                            }
                            if (memberParticle.getTermTag() == 2 && this.doWeHandleWildcard()) {
                                WildcardComponent wildcard = memberParticle.getWildcardTerm();
                                if (modelGroup.getCompositor() == Symbol.ALL) {
                                    this.fail("model.schema.invalidWildcard.allCompositor", new Object[]{component.getName()});
                                }
                                TypeDefinitionComponent anyURIcomponent = this._schema.findTypeDefinition(SchemaConstants.QNAME_TYPE_URTYPE);
                                LiteralFragmentType memberType = this.getLiteralFragmentTypeFor(anyURIcomponent, SchemaConstants.QNAME_TYPE_URTYPE);
                                LiteralWildcardMember member = new LiteralWildcardMember(memberType);
                                if (wildcard.getNamespaceConstraintTag() == 2) {
                                    member.setExcludedNamespaceName(wildcard.getNamespaceName());
                                } else if (wildcard.getNamespaceConstraintTag() != 1) {
                                    return this.getLiteralFragmentTypeFor(component, nameHint);
                                }
                                JavaType javaMemberType = null;
                                if (memberParticle.occursAtLeastOnce()) {
                                    member.setRequired(true);
                                }
                                if (memberParticle.mayOccurMoreThanOnce()) {
                                    member.setRepeated(true);
                                    JavaArrayType javaArrayType = new JavaArrayType(memberType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(memberType.getJavaType());
                                    javaMemberType = javaArrayType;
                                } else {
                                    javaMemberType = memberType.getJavaType();
                                }
                                javaMember = new JavaStructureMember(this.getUniqueMemberName(javaStructureType, ANY_MEMBER_NAME_PREFIX), javaMemberType, member, false);
                                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                member.setJavaStructureMember(javaMember);
                                javaStructureType.add(javaMember);
                                structureType.add(member);
                                continue;
                            }
                            if (memberParticle.getModelGroupTerm() != null && memberParticle.getModelGroupTerm().getCompositor() == Symbol.CHOICE) {
                                this.warn("model.schema.notImplemented.generatingSOAPElement", new Object[]{"xsd:choice", nameHint});
                            }
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        return structureType;
                    }
                    if (modelGroup.getCompositor() == Symbol.CHOICE) {
                        this.warn("model.schema.notImplemented.generatingSOAPElement", new Object[]{"xsd:choice", this.getUniqueQNameFor(component, nameHint)});
                    }
                    return this.getLiteralFragmentTypeFor(component, nameHint);
                }
                return this.getLiteralFragmentTypeFor(component, nameHint);
            }
            return this.getLiteralFragmentTypeFor(component, nameHint);
        }
        if (component.getContentTag() == 1) {
            LiteralSequenceType structureType = new LiteralSequenceType(this.getUniqueQNameFor(component, nameHint));
            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
            this.resolveNamingConflictsFor(javaStructureType);
            structureType.setJavaType(javaStructureType);
            this._componentToLiteralTypeMap.put(component, structureType);
            Iterator iter = component.attributeUses();
            while (iter.hasNext()) {
                AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                LiteralType attributeType = this.schemaTypeToLiteralType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null) {
                    return this.getLiteralFragmentTypeFor(component, nameHint);
                }
                LiteralAttributeMember member = new LiteralAttributeMember(attributeDeclaration.getName(), attributeType);
                if (attributeUse.isRequired()) {
                    member.setRequired(true);
                }
                J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberOfElementInfo(nameHint, attributeDeclaration.getName().getLocalPart());
                JavaStructureMember javaMember = new JavaStructureMember(memberInfo.javaMemberName, attributeType.getJavaType(), member, memberInfo.isDataMember);
                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                member.setJavaStructureMember(javaMember);
                javaStructureType.add(javaMember);
                structureType.add(member);
            }
            return structureType;
        }
        return this.getLiteralFragmentTypeFor(component, nameHint);
    }

    protected LiteralType anonymousSimpleSchemaTypeToLiteralType(SimpleTypeDefinitionComponent component, QName nameHint, String mappingNameHint) {
        Iterator values;
        Facet facet;
        Iterator iter = component.facets();
        SimpleTypeDefinitionComponent baseTypeComponent = component.getBaseTypeDefinition();
        if (iter.hasNext() && component.getVarietyTag() == 1 && (facet = (Facet)iter.next()) instanceof EnumerationFacet && (values = ((EnumerationFacet)facet).values()).hasNext()) {
            if (this._jaxbEnumType && component.getName() == null) {
                String nsURI = baseTypeComponent.getName().getNamespaceURI();
                if (nsURI != null && nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    return this.schemaTypeToLiteralType(baseTypeComponent, nameHint);
                }
                this.fail("model.schema.invalidSimpleType.noNamespaceURI", new Object[]{component.getName()});
            }
            return this.enumerationToLiteralType(component, (EnumerationFacet)facet, nameHint, mappingNameHint);
        }
        if (component.getVarietyTag() == 1) {
            String nsURI = baseTypeComponent.getName().getNamespaceURI();
            if (nsURI != null && nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                LiteralType baseType = this.schemaTypeToLiteralType(baseTypeComponent, nameHint, mappingNameHint);
                return baseType;
            }
            SimpleTypeEncoder encoder = null;
            SimpleTypeDefinitionComponent _baseType = null;
            while (encoder == null) {
                if (baseTypeComponent.getVarietyTag() == 1) {
                    _baseType = baseTypeComponent.getBaseTypeDefinition();
                } else if (baseTypeComponent.getVarietyTag() == 2) {
                    _baseType = baseTypeComponent.getItemTypeDefinition().getName() == null ? baseTypeComponent.getBaseTypeDefinition() : baseTypeComponent.getItemTypeDefinition();
                }
                encoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(_baseType.getName());
                if (baseTypeComponent.getName().equals(_baseType.getName())) break;
                baseTypeComponent = _baseType;
            }
            return this.simpleSchemaTypeToLiteralType(baseTypeComponent, baseTypeComponent.getName(), mappingNameHint);
        }
        if (component.getVarietyTag() == 2) {
            if (this.doWeHandleSimpleSchemaTypeDerivationByList()) {
                return this.listToLiteralType(component, nameHint);
            }
            return this.getLiteralSimpleStringTypeFor(component, nameHint);
        }
        return this.getLiteralSimpleStringTypeFor(component, nameHint);
    }

    protected LiteralType simpleSchemaTypeToLiteralType(SimpleTypeDefinitionComponent component, QName nameHint, String mappingNameHint) {
        if (component.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (component.getVarietyTag() == 1) {
                String nsURI = component.getName().getNamespaceURI();
                if (nsURI != null && nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (!component.facets().hasNext()) {
                        if (this._strictCompliance && (component.getName().equals(SchemaConstants.QNAME_TYPE_IDREF) || component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) && !this.checkStrictCompliance(component.getName())) {
                            return null;
                        }
                        if (!this._strictCompliance && component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        if (component.getName().equals(SchemaConstants.QNAME_TYPE_ID) || component.getName().equals(SchemaConstants.QNAME_TYPE_IDREF)) {
                            return this.handleIDIDREF(component);
                        }
                        LiteralSimpleType simpleType = new LiteralSimpleType(component.getName());
                        simpleType.setSchemaTypeRef(component.getName());
                        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                        if (javaType == null) {
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        simpleType.setJavaType(javaType);
                        return simpleType;
                    }
                    return this.getLiteralSimpleStringTypeFor(component, nameHint);
                }
                return this.getLiteralSimpleStringTypeFor(component, nameHint);
            }
            if (component.getVarietyTag() == 2) {
                if (this.doWeHandleSimpleSchemaTypeDerivationByList()) {
                    return this.listToLiteralType(component, nameHint);
                }
                return this.getLiteralSimpleStringTypeFor(component, nameHint);
            }
            if (component.getVarietyTag() == 3) {
                this.fail("model.schema.unionNotSupported", new Object[]{component.getName()});
            } else {
                if (component.getName().equals(SchemaConstants.QNAME_TYPE_SIMPLE_URTYPE)) {
                    return this.getLiteralSimpleStringTypeFor(component, nameHint);
                }
                this.fail("model.schema.invalidSimpleType", new Object[]{component.getName()});
            }
            this.fail("model.schema.invalidSimpleType", new Object[]{component.getName()});
            return null;
        }
        return this.anonymousSimpleSchemaTypeToLiteralType(component, nameHint, mappingNameHint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LiteralType schemaTypeToLiteralType(TypeDefinitionComponent component, QName nameHint, String mappingNameHint) {
        LiteralType result = (LiteralType)this._componentToLiteralTypeMap.get(component);
        if (result == null) {
            try {
                if (this._noDataBinding) {
                    result = this.getLiteralFragmentTypeFor(component, nameHint);
                } else if (component.isSimple()) {
                    result = this.simpleSchemaTypeToLiteralType((SimpleTypeDefinitionComponent)component, nameHint, mappingNameHint);
                } else if (component.isComplex()) {
                    result = this.complexSchemaTypeToLiteralType((ComplexTypeDefinitionComponent)component, nameHint, mappingNameHint);
                } else {
                    throw new IllegalArgumentException();
                }
                this._componentToLiteralTypeMap.put(component, result);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
        return result;
    }

    protected SOAPType processSOAPArrayType(TypeDefinitionComponent component, SchemaElement element, String typeSpecifier) {
        try {
            int closingBracketIndex;
            int openingBracketIndex = typeSpecifier.indexOf(91);
            if (openingBracketIndex == -1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
            }
            int currentRank = 0;
            String typeName = typeSpecifier.substring(0, openingBracketIndex).trim();
            QName typeQName = element.asQName(typeName);
            SOAPType elementType = this.schemaTypeToSOAPType(typeQName);
            if (elementType instanceof SOAPArrayType) {
                currentRank = ((SOAPArrayType)elementType).getRank();
            }
            do {
                if ((closingBracketIndex = typeSpecifier.indexOf(93, openingBracketIndex)) == -1) {
                    throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                }
                int commaIndex = typeSpecifier.indexOf(44, openingBracketIndex + 1);
                if (commaIndex == -1 || commaIndex > closingBracketIndex) {
                    int[] size = null;
                    if (closingBracketIndex - openingBracketIndex > 1) {
                        int i = Integer.parseInt(typeSpecifier.substring(openingBracketIndex + 1, closingBracketIndex));
                        size = new int[]{i};
                    }
                    SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                    arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                    arrayType.setElementType(elementType);
                    arrayType.setRank(++currentRank);
                    arrayType.setSize(size);
                    if (elementType.getJavaType() != null) {
                        JavaArrayType javaArrayType = new JavaArrayType(elementType.getJavaType().getName() + "[]");
                        javaArrayType.setElementType(elementType.getJavaType());
                        arrayType.setJavaType(javaArrayType);
                    }
                    elementType = arrayType;
                    continue;
                }
                ArrayList<Integer> sizeList = null;
                boolean allowSizeSpecifiers = true;
                boolean timeToGo = false;
                int rank = 0;
                int contentIndex = openingBracketIndex + 1;
                while (true) {
                    ++rank;
                    if (commaIndex - contentIndex > 0) {
                        if (!allowSizeSpecifiers) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                        }
                        int i = Integer.parseInt(typeSpecifier.substring(contentIndex, commaIndex));
                        if (sizeList == null) {
                            sizeList = new ArrayList<Integer>();
                        }
                        sizeList.add(new Integer(i));
                    } else {
                        if (sizeList != null) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                        }
                        allowSizeSpecifiers = false;
                    }
                    if (timeToGo) break;
                    contentIndex = commaIndex + 1;
                    if ((commaIndex = typeSpecifier.indexOf(44, contentIndex)) != -1 && commaIndex <= closingBracketIndex) continue;
                    commaIndex = closingBracketIndex;
                    timeToGo = true;
                }
                SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                arrayType.setElementType(elementType);
                arrayType.setRank(currentRank += rank);
                int[] size = null;
                if (allowSizeSpecifiers && sizeList != null) {
                    size = new int[sizeList.size()];
                    int i = 0;
                    while (i < size.length) {
                        size[i] = (Integer)sizeList.get(i);
                        ++i;
                    }
                }
                arrayType.setSize(size);
                if (elementType.getJavaType() != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(elementType.getJavaType().getName());
                    int i = 0;
                    while (i < rank) {
                        sb.append("[]");
                        ++i;
                    }
                    String javaArrayTypeName = sb.toString();
                    JavaArrayType javaArrayType = new JavaArrayType(javaArrayTypeName);
                    javaArrayType.setElementType(elementType.getJavaType());
                    arrayType.setJavaType(javaArrayType);
                }
                elementType = arrayType;
            } while ((openingBracketIndex = typeSpecifier.indexOf(91, closingBracketIndex + 1)) != -1);
            if (closingBracketIndex != typeSpecifier.length() - 1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
            }
            this.setSOAPArrayHolderName(elementType);
            return elementType;
        }
        catch (NumberFormatException e) {
            throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"}));
        }
        catch (ValidationException e) {
            throw new ModelException(e);
        }
    }

    protected SOAPType soapStructureExtensionComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component, SOAPStructureType parentType, QName nameHint) {
        if (component.getContentTag() == 4) {
            if (component.hasNoAttributeUses()) {
                ParticleComponent particle = component.getParticleContent();
                if (particle.occursOnce()) {
                    if (particle.getTermTag() == 1) {
                        ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                        if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                            Iterator iter;
                            SOAPStructureType structureType = null;
                            structureType = modelGroup.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(component.getName()) : new SOAPOrderedStructureType(component.getName());
                            if (parentType != null && parentType.getClass() != structureType.getClass()) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            String javaName = this.getJavaNameOfType(component, component.getName());
                            JavaStructureType javaStructureType = new JavaStructureType(javaName, false, structureType);
                            this.resolveNamingConflictsFor(javaStructureType);
                            structureType.setJavaType(javaStructureType);
                            this._componentToSOAPTypeMap.put(component, structureType);
                            if (parentType != null) {
                                iter = parentType.getMembers();
                                while (iter.hasNext()) {
                                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                                    SOAPStructureMember inheritedMember = new SOAPStructureMember(member.getName(), member.getType());
                                    inheritedMember.setInherited(true);
                                    JavaStructureMember javaMember = member.getJavaStructureMember();
                                    JavaStructureMember inheritedJavaMember = new JavaStructureMember(javaMember.getName(), javaMember.getType(), inheritedMember, false);
                                    inheritedJavaMember.setInherited(true);
                                    inheritedJavaMember.setReadMethod(javaMember.getReadMethod());
                                    inheritedJavaMember.setWriteMethod(javaMember.getWriteMethod());
                                    inheritedMember.setJavaStructureMember(inheritedJavaMember);
                                    structureType.add(inheritedMember);
                                    javaStructureType.add(inheritedJavaMember);
                                }
                                parentType.addSubtype(structureType);
                                ((JavaStructureType)parentType.getJavaType()).addSubclass(javaStructureType);
                            }
                            iter = modelGroup.particles();
                            while (iter.hasNext()) {
                                ParticleComponent memberParticle = (ParticleComponent)iter.next();
                                if (memberParticle.occursOnce() || memberParticle.occursAtMostOnce()) {
                                    if (memberParticle.getTermTag() == 3) {
                                        ElementDeclarationComponent element = memberParticle.getElementTerm();
                                        SOAPType memberType = element.isNillable() ? (element.getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(element.getTypeDefinition()) : this.schemaTypeToSOAPType(element.getTypeDefinition(), nameHint)) : this.schemaTypeToSOAPType(element.getTypeDefinition(), nameHint);
                                        SOAPStructureMember member = new SOAPStructureMember(element.getName(), memberType);
                                        J2EEModelInfo.JavaMemberInfo memberInfo = this.getJavaMemberInfo(component, element);
                                        JavaStructureMember javaMember = new JavaStructureMember(memberInfo.javaMemberName, memberType.getJavaType(), member, memberInfo.isDataMember);
                                        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                        member.setJavaStructureMember(javaMember);
                                        javaStructureType.add(javaMember);
                                        structureType.add(member);
                                        continue;
                                    }
                                    return this.mustGetCustomTypeFor(component);
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            structureType.setJavaType(javaStructureType);
                            return structureType;
                        }
                        return this.mustGetCustomTypeFor(component);
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 1) {
            if (component.hasNoAttributeUses()) {
                SOAPStructureType structureType = null;
                structureType = parentType != null ? (parentType instanceof SOAPOrderedStructureType ? new SOAPOrderedStructureType(component.getName()) : new SOAPUnorderedStructureType(component.getName())) : new SOAPOrderedStructureType(component.getName());
                String javaTypeName = this.getJavaNameOfType(component, component.getName());
                JavaStructureType javaStructureType = new JavaStructureType(javaTypeName, false, structureType);
                structureType.setJavaType(javaStructureType);
                if (parentType != null && parentType.getClass() != structureType.getClass()) {
                    return this.mustGetCustomTypeFor(component);
                }
                if (parentType != null) {
                    Iterator iter = parentType.getMembers();
                    while (iter.hasNext()) {
                        SOAPStructureMember member = (SOAPStructureMember)iter.next();
                        SOAPStructureMember inheritedMember = new SOAPStructureMember(member.getName(), member.getType());
                        inheritedMember.setInherited(true);
                        JavaStructureMember javaMember = member.getJavaStructureMember();
                        JavaStructureMember inheritedJavaMember = new JavaStructureMember(javaMember.getName(), javaMember.getType(), inheritedMember, false);
                        inheritedJavaMember.setInherited(true);
                        inheritedJavaMember.setReadMethod(javaMember.getReadMethod());
                        inheritedJavaMember.setWriteMethod(javaMember.getWriteMethod());
                        inheritedMember.setJavaStructureMember(inheritedJavaMember);
                        structureType.add(inheritedMember);
                    }
                    parentType.addSubtype(structureType);
                    ((JavaStructureType)parentType.getJavaType()).addSubclass(javaStructureType);
                }
                return structureType;
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 2) {
            if (component.hasNoAttributeUses()) {
                if (component.getName().getNamespaceURI().equals(soap11WSDLConstants.getSOAPEncodingNamespace())) {
                    SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                    simpleType.setSchemaTypeRef(component.getName());
                    JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                    if (javaType == null) {
                        this.fail("model.schema.invalidSimpleType.noJavaType", new Object[]{component.getName()});
                    }
                    simpleType.setJavaType(javaType);
                    this.setReferenceable(simpleType);
                    return simpleType;
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType enumerationToSOAPType(SimpleTypeDefinitionComponent component, EnumerationFacet facet, QName nameHint) {
        SimpleTypeDefinitionComponent baseType = component.getBaseTypeDefinition();
        SimpleTypeEncoder encoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(baseType.getName());
        SimpleTypeDefinitionComponent tempComponent = component;
        while (encoder == null && !baseType.getName().equals(SchemaConstants.QNAME_TYPE_BOOLEAN)) {
            baseType = component.getBaseTypeDefinition();
            encoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(baseType.getName());
            component = baseType;
        }
        component = tempComponent;
        if (encoder != null) {
            QName componentName = component.getName();
            if (componentName == null && componentName == null) {
                componentName = new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart());
            }
            JavaType javaEntryType = (JavaType)this._builtinSchemaTypeToJavaTypeMap.get(baseType.getName());
            String javaEnumName = this.getJavaNameOfType(component, nameHint);
            JavaEnumerationType javaEnumType = new JavaEnumerationType(javaEnumName, javaEntryType, false);
            this.resolveEnumerationNamingConflictsFor(javaEnumType);
            SOAPEnumerationType soapEnumType = new SOAPEnumerationType(componentName, this.schemaTypeToSOAPType(baseType, nameHint), javaEnumType);
            boolean mustRename = false;
            Iterator values = facet.values();
            while (values.hasNext()) {
                String value = (String)values.next();
                try {
                    JavaEnumerationEntry entry = null;
                    entry = baseType.getName().equals(SchemaConstants.QNAME_TYPE_QNAME) ? new JavaEnumerationEntry(value, this.valueToQName(value, facet.getPrefixes()), value) : new JavaEnumerationEntry(value, encoder.stringToObject(value, null), value);
                    if (!mustRename && this.isInvalidEnumerationLabel(value)) {
                        mustRename = true;
                    }
                    javaEnumType.add(entry);
                }
                catch (Exception e) {
                    this.fail("model.schema.invalidLiteralInEnumeration", value, componentName);
                }
            }
            if (mustRename) {
                int index = 1;
                Iterator iter = javaEnumType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    entry.setName("value" + Integer.toString(index));
                    ++index;
                }
            }
            return soapEnumType;
        }
        this.fail("model.schema.encoderNotFound", new Object[]{component.getName()});
        return null;
    }

    protected String getJ2EEAnonymousArrayTypeName(ParticleComponent memberParticle, ElementDeclarationComponent element, String mappingNameHint) {
        String upperBound = memberParticle.isMaxOccursUnbounded() ? "unbounded" : String.valueOf(memberParticle.getMaxOccurs());
        String lowerBound = String.valueOf(memberParticle.getMinOccurs());
        String name = mappingNameHint + ">" + element.getName().getLocalPart();
        String boundary = "[" + lowerBound + "," + upperBound + "]";
        return name + boundary;
    }

    protected String getJavaNameOfElementType(LiteralStructuredType structureType, TypeDefinitionComponent component, QName nameHint) {
        return this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName());
    }

    protected String getJavaNameOfSOAPStructureType(SOAPStructureType structureType, TypeDefinitionComponent component, QName nameHint) {
        return this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName());
    }

    protected LiteralType getLiteralMemberType(ComplexTypeDefinitionComponent component, LiteralType memberType, ElementDeclarationComponent element, LiteralStructuredType structureType) {
        return memberType;
    }

    protected LiteralType enumerationToLiteralType(SimpleTypeDefinitionComponent component, EnumerationFacet facet, QName nameHint, String mappingNameHint) {
        SimpleTypeDefinitionComponent baseType = component.getBaseTypeDefinition();
        SimpleTypeEncoder encoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(baseType.getName());
        if (encoder != null && !baseType.getName().equals(SchemaConstants.QNAME_TYPE_BOOLEAN)) {
            JavaType javaEntryType = (JavaType)this._builtinSchemaTypeToJavaTypeMap.get(baseType.getName());
            QName componentName = component.getName();
            if (componentName == null) {
                componentName = new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart());
            }
            JavaEnumerationType javaEnumType = new JavaEnumerationType(this.makePackageQualified(this._env.getNames().validJavaClassName(componentName.getLocalPart()), componentName), javaEntryType, false);
            this.resolveEnumerationNamingConflictsFor(javaEnumType);
            LiteralEnumerationType literalEnumType = new LiteralEnumerationType(componentName, this.schemaTypeToLiteralType(baseType, new QName("value")), javaEnumType);
            if (component.getName() == null) {
                literalEnumType.setProperty("com.sun.xml.rpc.processor.model.AnonymousTypeName", mappingNameHint);
            }
            boolean mustRename = false;
            Iterator values = facet.values();
            while (values.hasNext()) {
                String value = (String)values.next();
                try {
                    JavaEnumerationEntry entry = null;
                    entry = baseType.getName().equals(SchemaConstants.QNAME_TYPE_QNAME) ? new JavaEnumerationEntry(value, this.valueToQName(value, facet.getPrefixes()), value) : new JavaEnumerationEntry(value, encoder.stringToObject(value, null), value);
                    if (!mustRename && this.isInvalidEnumerationLabel(value)) {
                        mustRename = true;
                    }
                    javaEnumType.add(entry);
                }
                catch (Exception e) {
                    this.fail("model.schema.invalidLiteralInEnumeration", value, component.getName());
                }
            }
            if (mustRename) {
                int index = 1;
                Iterator iter = javaEnumType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    entry.setName("value" + Integer.toString(index));
                    ++index;
                }
            }
            return literalEnumType;
        }
        this.fail("model.schema.encoderNotFound", new Object[]{component.getName()});
        return null;
    }

    protected SOAPType getSOAPMemberType(ComplexTypeDefinitionComponent component, SOAPStructureType structureType, ElementDeclarationComponent element, QName nameHint, boolean occursZeroOrOne) {
        SOAPType memberType = null;
        memberType = element.isNillable() || occursZeroOrOne ? (element.getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(element.getTypeDefinition()) : this.schemaTypeToSOAPType(element.getTypeDefinition(), nameHint)) : this.schemaTypeToSOAPType(element.getTypeDefinition(), this.getElementQNameHint(element, nameHint));
        return memberType;
    }

    public SchemaAnalyzerBase(AbstractDocument document, ModelInfo modelInfo, Properties options, Set conflictingClassNames, JavaSimpleTypeCreator javaTypes) {
        this.init();
        this._messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.model");
        this._schema = JAXRPCClassFactory.newInstance().createInternalSchemaBuilder(document, options).getSchema();
        this._modelInfo = modelInfo;
        this._env = (ProcessorEnvironment)modelInfo.getParent().getEnvironment();
        this._conflictingClassNames = conflictingClassNames;
        this._typesBeingResolved = new HashSet();
        this._namePool = new HashSet();
        this._componentToSOAPTypeMap = new HashMap();
        this._componentToLiteralTypeMap = new HashMap();
        this._typeNameToCustomSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToLiteralTypeMap = new HashMap();
        this._nextUniqueID = 1;
        this._noDataBinding = Boolean.valueOf(options.getProperty("noDataBinding"));
        this._useDataHandlerOnly = Boolean.valueOf(options.getProperty("useDataHandlerOnly"));
        this._resolveIDREF = Boolean.valueOf(options.getProperty("resolveIDREF"));
        this._strictCompliance = Boolean.valueOf(options.getProperty("strictCompliance"));
        this._jaxbEnumType = Boolean.valueOf(options.getProperty("jaxbenum"));
        this.javaTypes = javaTypes;
        this.initializeMaps();
    }
}

