/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.literal;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeOwningType;
import com.sun.xml.rpc.processor.model.literal.LiteralContentMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class LiteralStructuredType
extends LiteralAttributeOwningType {
    private List _elementMembers = new ArrayList();
    private Map _elementMembersByName = new HashMap();
    private LiteralContentMember _contentMember;
    private Set _subtypes = null;
    private LiteralStructuredType _parentType = null;
    private boolean _rpcWrapper = false;

    public int getElementMembersCount() {
        return this._elementMembers.size();
    }

    protected LiteralStructuredType() {
    }

    private void initializeElementMembersByName() {
        this._elementMembersByName = new HashMap();
        if (this._elementMembers != null) {
            Iterator iter = this._elementMembers.iterator();
            while (iter.hasNext()) {
                LiteralElementMember m = (LiteralElementMember)iter.next();
                if (m.getName() != null && this._elementMembersByName.containsKey(m.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._elementMembersByName.put(m.getName(), m);
            }
        }
    }

    public boolean isRpcWrapper() {
        return this._rpcWrapper;
    }

    public void setRpcWrapper(boolean rpcWrapper) {
        this._rpcWrapper = rpcWrapper;
    }

    public LiteralContentMember getContentMember() {
        return this._contentMember;
    }

    public void setContentMember(LiteralContentMember t) {
        this._contentMember = t;
    }

    public void add(LiteralElementMember m) {
        if (this._elementMembersByName.containsKey(m.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._elementMembers.add(m);
        this._elementMembersByName.put(m.getName(), m);
    }

    public LiteralStructuredType getParentType() {
        return this._parentType;
    }

    public void addSubtype(LiteralStructuredType type) {
        if (this._subtypes == null) {
            this._subtypes = new HashSet();
        }
        this._subtypes.add(type);
        type.setParentType(this);
    }

    public void setParentType(LiteralStructuredType parent) {
        if (this._parentType != null && parent != null && !this._parentType.equals(parent)) {
            throw new ModelException("model.parent.type.already.set", new Object[]{this.getName().toString(), this._parentType.getName().toString(), parent.getName().toString()});
        }
        this._parentType = parent;
    }

    public Iterator getElementMembers() {
        return this._elementMembers.iterator();
    }

    public Iterator getSubtypes() {
        if (this._subtypes != null) {
            return this._subtypes.iterator();
        }
        return null;
    }

    public List getElementMembersList() {
        return this._elementMembers;
    }

    public void setElementMembersList(List l) {
        this._elementMembers = l;
    }

    public Set getSubtypesSet() {
        return this._subtypes;
    }

    public void setSubtypesSet(Set s) {
        this._subtypes = s;
    }

    protected LiteralStructuredType(QName name) {
        this(name, (JavaStructureType)null);
    }

    protected LiteralStructuredType(QName name, JavaStructureType javaType) {
        super(name, javaType);
    }

    public LiteralElementMember getElementMemberByName(String name) {
        if (this._elementMembersByName.size() != this._elementMembers.size()) {
            this.initializeElementMembersByName();
        }
        return (LiteralElementMember)this._elementMembersByName.get(name);
    }
}

