/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.exporter.ImporterBase;
import com.sun.xml.rpc.processor.model.exporter.PGraph;
import com.sun.xml.rpc.processor.model.exporter.PObject;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import java.io.InputStream;
import javax.xml.namespace.QName;

public class PGraphImporter
extends ImporterBase {
    public PGraph doImport() {
        return (PGraph)this.internalDoImport();
    }

    protected PObject createPObject() {
        return new PObject();
    }

    protected void failInvalidSyntax(XMLReader reader) {
        throw new ModelException("model.importer.syntaxError", Integer.toString(reader.getLineNumber()));
    }

    protected void parseDefineObject(XMLReader reader) {
        String idAttr = this.getRequiredAttribute(reader, "id");
        String typeAttr = this.getRequiredAttribute(reader, "type");
        Integer id = this.parseId(reader, idAttr);
        if (this.getObjectForId(id) != null) {
            this.failInvalidId(reader, id);
        }
        PObject obj = this.createPObject();
        obj.setType(typeAttr);
        this.id2obj.put(id, obj);
        this.verifyNoContent(reader);
    }

    public PGraphImporter(InputStream s) {
        super(s);
    }

    protected Object internalDoImport() {
        this.initialize();
        PGraph graph = new PGraph();
        this.reader.nextElementContent();
        if (this.reader.getState() != 1) {
            this.failInvalidSyntax(this.reader);
        }
        graph.setName(this.reader.getName());
        String versionAttr = this.getRequiredAttribute(this.reader, "version");
        graph.setVersion(versionAttr);
        while (this.reader.nextElementContent() != 2) {
            if (this.reader.getName().equals(this.getDefineImmediateObjectName())) {
                this.parseDefineImmediateObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getDefineObjectName())) {
                this.parseDefineObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getPropertyName())) {
                this.parseProperty(this.reader);
                continue;
            }
            this.failInvalidSyntax(this.reader);
        }
        XMLReaderUtil.verifyReaderState(this.reader, 2);
        graph.setRoot((PObject)this.id2obj.get(new Integer(1)));
        return graph;
    }

    protected QName getContainerName() {
        return null;
    }

    protected void failInvalidId(XMLReader reader, Integer id) {
        throw new ModelException("model.importer.invalidId", new Object[]{Integer.toString(reader.getLineNumber()), id.toString()});
    }

    protected void failInvalidClass(XMLReader reader, String className) {
        throw new ModelException("model.importer.invalidClass", new Object[]{Integer.toString(reader.getLineNumber()), className});
    }

    protected void failInvalidVersion(XMLReader reader, String version) {
        throw new ModelException("model.importer.invalidVersion", new Object[]{Integer.toString(reader.getLineNumber()), version});
    }

    protected void failInvalidLiteral(XMLReader reader, String type, String value) {
        throw new ModelException("model.importer.invalidLiteral", Integer.toString(reader.getLineNumber()));
    }

    protected void failInvalidProperty(XMLReader reader, Object subject, String name, Object value) {
        throw new ModelException("model.importer.invalidProperty", Integer.toString(reader.getLineNumber()));
    }

    protected void property(XMLReader reader, Object subject, String name, Object value) {
        if (subject instanceof PObject) {
            PObject obj = (PObject)subject;
            obj.setProperty(name, value);
        } else {
            super.property(reader, subject, name, value);
        }
    }
}

