/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPAttributeMember;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class SOAPObjectSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private static final String OBJECT_SERIALIZER_BASE = "ObjectSerializerBase";
    private static final String INTERFACE_SERIALIZER_BASE = "InterfaceSerializerBase";

    public SOAPObjectSerializerGenerator() {
    }

    public static boolean deserializeToDetail(AbstractType type) {
        JavaStructureType javaType = (JavaStructureType)type.getJavaType();
        if (!(javaType instanceof JavaException)) {
            return false;
        }
        Iterator members = javaType.getMembers();
        while (members.hasNext()) {
            JavaStructureMember member = (JavaStructureMember)members.next();
            if (member.getConstructorPos() >= 0 || member.getWriteMethod() != null) continue;
            return true;
        }
        return false;
    }

    protected void visitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        }
        JavaException exception = fault.getJavaException();
        Iterator members = exception.getMembers();
        AbstractType aType = (AbstractType)exception.getOwner();
        if (aType.isSOAPType()) {
            while (members.hasNext()) {
                SOAPType type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
                type.accept(this);
            }
        } else {
            LiteralType type = null;
            while (members.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)members.next();
                if (javaMember.getOwner() instanceof LiteralElementMember) {
                    type = ((LiteralElementMember)javaMember.getOwner()).getType();
                } else if (javaMember.getOwner() instanceof LiteralAttributeMember) {
                    type = ((LiteralAttributeMember)javaMember.getOwner()).getType();
                }
                type.accept(this);
            }
        }
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator types = model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isSOAPType()) continue;
            ((SOAPType)type).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void preVisitSOAPAnyType(SOAPAnyType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        try {
            this.writeObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    private void writeObjectSerializerForType(SOAPStructureType type) throws IOException {
        JavaType javaType = type.getJavaType();
        String className = this.env.getNames().typeObjectSerializerClassName(this.servicePackage, type);
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        GeneratedFileInfo fi = new GeneratedFileInfo();
        fi.setFile(classFile);
        fi.setType("SoapObjectSerializer");
        this.env.addGeneratedFile(fi);
        try {
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectSerializerCode(out, type);
            out.close();
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private void typeVisited(SOAPType type) {
        this.visitedTypes.add(type);
    }

    private boolean haveVisited(SOAPType type) {
        return this.visitedTypes.contains(type);
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAP12Constants;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
    }

    public static void writeDetailDoDeserializeMethod(IndentingWriter p, AbstractType type) throws IOException {
        if (type instanceof SOAPType) {
            p.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
            p.pln("SOAPDeserializationContext context) throws Exception {");
        } else if (type instanceof LiteralType) {
            p.plnI("public Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {");
        } else {
            GeneratorBase.fail("generator.unsupported.type.encountered", type.getName().getLocalPart(), type.getName().getNamespaceURI());
        }
        p.pln("Object detail;");
        p.pln("DetailFragmentDeserializer detailDeserializer = new DetailFragmentDeserializer(type, encodingStyle);");
        p.pln("detail = detailDeserializer.deserialize(reader.getName(), reader, context);");
        p.pln("return detail;");
        p.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        if (((JavaStructureType)type.getJavaType()).isAbstract()) {
            p.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
            p.pln("SOAPDeserializationContext context) throws Exception {");
            p.p("throw new DeserializationException(\"soap.unsupportedType\", ");
            GeneratorUtil.writeNewQName(p, type.getName());
            p.pln(".toString());");
            p.pOln("}");
        } else if (SOAPObjectSerializerGenerator.deserializeToDetail(type)) {
            SOAPObjectSerializerGenerator.writeDetailDoDeserializeMethod(p, type);
        } else {
            this.writeStandardDoDeserializeMethod(p, type);
        }
    }

    private void writeDoSerializeAttributesMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("public void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getName() + " instance = (" + type.getJavaType().getName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            SOAPAttributeMember member = (SOAPAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
            String serializer = writer.serializerMemberName();
            String valueStr = null;
            String javaName = javaMember.getType().getName();
            String encoder = member.getType() instanceof SOAPEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : SimpleTypeSerializerWriter.getTypeEncoder(member.getType());
            if (javaMember.isPublic()) {
                valueStr = "instance." + javaMember.getName();
            } else {
                String methName = javaMember.getReadMethod();
                valueStr = "instance." + methName + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
            }
            p.plnI("if (" + valueStr + " != null) {");
            p.pln("writer.writeAttribute(" + memberQName + ", " + encoder + ".getInstance().objectToString(" + valueStr + ", writer));");
            p.pOln("}");
            if (!member.isRequired()) continue;
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.requiredAttributeConstraint\", new Object[] {" + memberQName + "});");
            p.pOln("}");
        }
        p.pOln("}");
    }

    private void writeDoSerializeInstanceMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("public void doSerializeInstance(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getName() + " instance = (" + type.getJavaType().getName() + ")obj;");
        p.pln();
        boolean deserializeToDetail = SOAPObjectSerializerGenerator.deserializeToDetail(type);
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            if (!(javaMember.getOwner() instanceof SOAPAttributeMember)) {
                SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
                String memberConstName = member.getName().getLocalPart().toUpperCase();
                String memberQName = this.env.getNames().getQNameName(member.getName());
                SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
                String serializer = writer.serializerMemberName();
                String valueStr = null;
                String javaName = javaMember.getType().getName();
                if (i == 0 && type instanceof RPCResponseStructureType && this.curSOAPVersion.equals(SOAPVersion.SOAP_12)) {
                    p.pln("// SOAP 1.2 - add rpc namespace, and add rpc:result and result element qname");
                    p.pln("writer.startElement(SOAP12Constants.QNAME_SOAP_RESULT);");
                    p.pln("writer.writeChars(writer.getPrefix(" + memberQName + ".getNamespaceURI())+\":\"+" + memberQName + ".getLocalPart());");
                    p.pln("writer.endElement();//rpc:result");
                }
                if (javaMember.isPublic()) {
                    valueStr = "instance." + javaMember.getName();
                } else {
                    String methName = javaMember.getReadMethod();
                    valueStr = "instance." + methName + "()";
                }
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
                } else if (deserializeToDetail) {
                    p.plnI("if (" + valueStr + " != null) {");
                }
                p.pln(serializer + ".serialize(" + valueStr + ", " + memberQName + ", null, writer, context);");
                if (deserializeToDetail && !SimpleToBoxedUtil.isPrimitive(javaName)) {
                    p.pOln("}");
                }
            }
            ++i;
        }
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        HashSet<String> processedTypes = new HashSet<String>();
        while (iterator.hasNext()) {
            SOAPStructureMember member;
            SOAPType memType;
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            if (javaMember.getOwner() instanceof SOAPAttributeMember || processedTypes.contains((memType = (member = (SOAPStructureMember)javaMember.getOwner()).getType()).getName() + ";" + memType.getJavaType().getRealName())) continue;
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, memType);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(memType.getName()), "registry");
            processedTypes.add(member.getType().getName() + ";" + memType.getJavaType().getRealName());
        }
        p.pOln("}");
    }

    private void writeMembers(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureMember javaMember;
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        HashSet processedTypes = new HashSet();
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            SOAPAttributeMember attMember = (SOAPAttributeMember)iter.next();
            JavaStructureMember attJavaMember = attMember.getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(p, attMember.getName(), this.env.getNames());
        }
        while (iterator.hasNext()) {
            javaMember = (JavaStructureMember)iterator.next();
            if (javaMember.getOwner() instanceof SOAPAttributeMember) continue;
            SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
            GeneratorUtil.writeQNameDeclaration(p, member.getName(), this.env.getNames());
            SOAPEncoding.writeStaticSerializer(p, this.servicePackage, member.getType(), processedTypes, this.writerFactory, this.env.getNames());
        }
        iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            javaMember = (JavaStructureMember)iterator.next();
            p.p("private static final int ");
            p.pln(this.env.getNames().memberName(javaMember.getName().toUpperCase() + "_INDEX") + " = " + i + ";");
            ++i;
        }
    }

    private void writeObjectSerializerCode(IndentingWriter p, SOAPStructureType type) throws IOException {
        this.log("writing  serializer/deserializer for: " + type.getName());
        String className = this.env.getNames().typeObjectSerializerClassName(this.servicePackage, type);
        this.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className);
        p.pln();
        this.writeInitialize(p, type);
        p.pln();
        this.writeDoDeserializeMethod(p, type);
        p.pln();
        this.writeDoSerializeAttributesMethod(p, type);
        p.pln();
        this.writeDoSerializeInstanceMethod(p, type);
        if (type instanceof RPCResponseStructureType) {
            this.writeVerifyNameOverrideMethod(p, type);
        }
        p.pOln("}");
    }

    private void writeStandardDoDeserializeMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureType javaType = (JavaStructureType)type.getJavaType();
        JavaStructureMember[] constructorArgs = SOAPObjectBuilderGenerator.getConstructorArgs(javaType);
        boolean usesConstructor = constructorArgs.length > 0;
        p.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
        p.pln("SOAPDeserializationContext context) throws Exception {");
        if (usesConstructor) {
            p.pln(javaType.getName() + " instance = null;");
            Iterator members = javaType.getMembers();
            while (members.hasNext()) {
                JavaStructureMember member = (JavaStructureMember)members.next();
                String javaName = member.getType().getName();
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    javaName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    String initVal = member.getType().getInitString();
                    p.pln("Object " + member.getName() + "Temp = new " + javaName + "(" + initVal + ");");
                    continue;
                }
                p.pln("Object " + member.getName() + "Temp = null;");
            }
        } else {
            p.pln(javaType.getName() + " instance = new " + javaType.getName() + "();");
        }
        if (SOAPObjectBuilderGenerator.needBuilder(type)) {
            p.pln(this.env.getNames().typeObjectBuilderClassName(this.servicePackage, type) + " builder = null;");
        }
        p.pln("Object member;");
        p.pln("boolean isComplete = true;");
        p.pln("QName elementName;");
        p.pln();
        if (type.getAttributeMembersCount() > 0) {
            this.writeDeserializeAttributes(p, type, "reader", usesConstructor);
            p.pln();
        }
        p.pln("reader.nextElementContent();");
        if (type.getMembersCount() > 0) {
            if (type instanceof SOAPOrderedStructureType) {
                this.writeDeserializeElements(p, (SOAPOrderedStructureType)type, "reader", constructorArgs);
            } else if (type instanceof RPCResponseStructureType) {
                this.writeDeserializeElements(p, (RPCResponseStructureType)type, "reader");
            } else if (type instanceof SOAPUnorderedStructureType) {
                this.writeDeserializeElements(p, (SOAPUnorderedStructureType)type, "reader");
            }
            p.pln();
        }
        if (type.getSubtypes() == null || !(javaType instanceof JavaException) || !type.getSubtypes().hasNext()) {
            p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
        }
        p.pln("return (isComplete ? (Object)instance : (Object)state);");
        p.pOln("}");
    }

    private void writeVerifyNameOverrideMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("protected void verifyName(XMLReader reader, QName expectedName) throws Exception {");
        p.pOln("}");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        String baseClass = OBJECT_SERIALIZER_BASE;
        p.plnI("public class " + Names.stripQualifier(className) + " extends " + baseClass + " implements Initializable {");
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        p.plnI("public " + Names.stripQualifier(className) + "(QName type, boolean encodeType, " + "boolean isNullable, String encodingStyle) {");
        p.pln("super(type, encodeType, isNullable, encodingStyle);");
        p.pOln("}");
    }

    private void writeDeserializeElements(IndentingWriter p, RPCResponseStructureType type, String reader) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int memberCnt = javaStructure.getMembersCount();
        if (this.curSOAPVersion.equals(SOAPVersion.SOAP_12)) {
            p.pln("// SOAP 1.2 deserializer result element");
            p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
            p.plnI("if(reader.getName().equals(SOAP12Constants.QNAME_SOAP_RESULT)) {");
            p.pln("reader.skipElement();");
            p.pln("reader.nextElementContent();");
            p.pOln("}");
            p.pOln("}");
        }
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            this.writeMemberDeserializer(p, type, javaMember, reader, i > 0, i > 0, memberCnt > 2 && i > 0, !iterator.hasNext(), false);
            if (i == 0) {
                if (memberCnt > 2) {
                    p.plnI("for (int i=0; i<" + (memberCnt - 1) + "; i++) {");
                }
                p.pln("elementName = " + reader + ".getName();");
            }
            ++i;
        }
        if (memberCnt > 2) {
            p.pOln("}");
        }
    }

    private void writeDeserializeAttributes(IndentingWriter p, SOAPStructureType type, String reader, boolean usesConstructor) throws IOException {
        p.pln("Attributes attributes = reader.getAttributes();");
        p.pln("String attribute = null;");
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            SOAPAttributeMember member = (SOAPAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            p.pln("attribute = attributes.getValue(" + memberQName + ");");
            p.plnI("if (attribute != null) {");
            String encoder = member.getType() instanceof SOAPEnumerationType ? member.getType().getJavaType().getName() + "_Encoder" : SimpleTypeSerializerWriter.getTypeEncoder(member.getType());
            if (usesConstructor) {
                p.pln(javaMember.getName() + "Temp = " + encoder + ".getInstance().stringToObject(attribute, reader);");
            } else {
                String valueStr;
                p.pln("member = " + encoder + ".getInstance().stringToObject(attribute, reader);");
                String javaName = javaMember.getType().getName();
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
                } else {
                    valueStr = "(" + javaName + ")member";
                }
                if (javaMember.isPublic()) {
                    p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
                } else if (javaMember.getDeclaringClass() != null) {
                    p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                } else {
                    p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
                }
            }
            p.pOln("}");
            if (!member.isRequired()) continue;
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.missingRequiredAttribute\", new Object[] {" + memberQName + "});");
            p.pOln("}");
        }
    }

    private void writeDeserializeElements(IndentingWriter p, SOAPUnorderedStructureType type, String reader) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int memberCnt = javaStructure.getMembersCount();
        if (memberCnt > 1) {
            p.plnI("for (int i=0; i<" + memberCnt + "; i++) {");
            p.pln("elementName = " + reader + ".getName();");
            p.plnI("if (" + reader + ".getState() == XMLReader.END) {");
            p.pln("break;");
            p.pOln("}");
        } else {
            p.pln("elementName = " + reader + ".getName();");
        }
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            this.writeMemberDeserializer(p, type, javaMember, reader, true, true, memberCnt > 1, !iterator.hasNext(), false);
            ++i;
        }
        if (memberCnt > 1) {
            p.pOln("}");
        }
    }

    private SOAPObjectSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SOAPObjectSerializerGenerator(model, config, properties);
    }

    private void writeDeserializeElements(IndentingWriter p, SOAPOrderedStructureType type, String reader, JavaStructureMember[] constructorArgs) throws IOException {
        JavaStructureMember javaMember;
        boolean usesConstructor = constructorArgs.length > 0;
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        while (iterator.hasNext()) {
            javaMember = (JavaStructureMember)iterator.next();
            p.pln("elementName = " + reader + ".getName();");
            this.writeMemberDeserializer(p, type, javaMember, reader, true, true, false, false, usesConstructor);
        }
        if (usesConstructor) {
            String valueStr;
            String boxName;
            String javaName;
            p.plnI("if (isComplete) {");
            p.p("instance = new " + javaStructure.getName() + "(");
            int i = 0;
            while (i < constructorArgs.length) {
                if (i > 0) {
                    p.p(", ");
                }
                if (SimpleToBoxedUtil.isPrimitive(javaName = (javaMember = constructorArgs[i]).getType().getName())) {
                    boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + javaMember.getName() + "Temp", javaName);
                } else {
                    valueStr = "(" + javaName + ")" + javaMember.getName() + "Temp";
                }
                p.p(valueStr);
                ++i;
            }
            p.pln(");");
            p.pO("}");
            if (SOAPObjectBuilderGenerator.needBuilder(type)) {
                p.plnI(" else {");
                iterator = javaStructure.getMembers();
                while (iterator.hasNext()) {
                    javaMember = (JavaStructureMember)iterator.next();
                    javaName = javaMember.getType().getName();
                    if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                        boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                        valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + javaMember.getName() + "Temp", javaName);
                    } else {
                        valueStr = "(" + javaName + ")" + javaMember.getName() + "Temp";
                    }
                    String writeMethod = javaMember.getWriteMethod();
                    if (writeMethod == null) {
                        writeMethod = "set" + StringUtils.capitalize(javaMember.getName());
                    }
                    p.pln("builder." + writeMethod + "(" + valueStr + ");");
                }
                p.pOln("}");
            }
        }
    }

    private void writeMemberDeserializer(IndentingWriter p, SOAPStructureType type, JavaStructureMember javaMember, String reader, boolean preCheckElementName, boolean checkElementName, boolean unOrdered, boolean writeThrow, boolean usesConstructor) throws IOException {
        if (javaMember.getOwner() instanceof SOAPAttributeMember) {
            return;
        }
        SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
        String memberConstName = this.env.getNames().memberName(javaMember.getName().toUpperCase());
        String memberQName = this.env.getNames().getQNameName(member.getName());
        if (!checkElementName) {
            memberQName = "null";
        }
        if (!unOrdered) {
            p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
        }
        if (preCheckElementName && checkElementName) {
            p.plnI("if (elementName.equals(" + memberQName + ")) {");
        }
        SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, member.getType());
        String serializer = writer.deserializerMemberName();
        boolean referenceable = member.getType().isReferenceable();
        String memberName = "member";
        p.pln("member = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (referenceable) {
            p.plnI("if (member instanceof SOAPDeserializationState) {");
            p.plnI("if (builder == null) {");
            p.pln("builder = new " + this.env.getNames().typeObjectBuilderClassName(this.servicePackage, type) + "();");
            p.pOln("}");
            p.pln("state = registerWithMemberState(instance, state, member, " + memberConstName + "_INDEX, builder);");
            p.pln("isComplete = false;");
            p.pOlnI("} else {");
            if (usesConstructor) {
                p.pln(javaMember.getName() + "Temp = member;");
            } else if (javaMember.isPublic()) {
                p.pln("instance." + javaMember.getName() + " = (" + javaMember.getType().getName() + ")member;");
            } else if (javaMember.getDeclaringClass() != null) {
                p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "((" + javaMember.getType().getName() + ")member);");
            } else {
                p.pln("instance." + javaMember.getWriteMethod() + "((" + javaMember.getType().getName() + ")member);");
            }
            p.pOln("}");
        } else {
            String valueStr = null;
            String javaName = javaMember.getType().getName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
            } else {
                valueStr = "(" + javaName + ")member";
            }
            if (usesConstructor) {
                p.pln(javaMember.getName() + "Temp = member;");
            } else if (javaMember.isPublic()) {
                p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
            } else if (javaMember.getDeclaringClass() != null) {
                p.pln("((" + javaMember.getDeclaringClass().replace('$', '.') + ")instance)." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            } else {
                p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
        }
        p.pln(reader + ".nextElementContent();");
        if (unOrdered) {
            p.pln("continue;");
        }
        if (preCheckElementName && checkElementName) {
            p.pO("}");
            if (writeThrow) {
                p.plnI(" else {");
                p.pln("throw new DeserializationException(\"soap.unexpectedElementName\", new Object[] {" + memberQName + ", elementName});");
                p.pOln("}");
            } else {
                p.pln();
            }
        }
        if (!unOrdered) {
            p.pOln("}");
        }
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new SOAPObjectSerializerGenerator(model, config, properties);
    }
}

