/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class RemoteInterfaceGenerator
implements ProcessorAction {
    private boolean donotOverride;
    private File sourceDir;
    private ProcessorEnvironment env;
    private String JAXRPCVersion;

    private void generateClassFor(Port port) {
        JavaInterface intf = port.getJavaInterface();
        try {
            String className = this.env.getNames().customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("RemoteInterface");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className, this.JAXRPCVersion);
            out.plnI("public interface " + Names.stripQualifier(className) + " extends java.rmi.Remote {");
            Iterator iter = intf.getMethods();
            while (iter.hasNext()) {
                JavaMethod method = (JavaMethod)iter.next();
                out.p("public ");
                if (method.getReturnType() == null) {
                    out.p("void");
                } else {
                    out.p(method.getReturnType().getName());
                }
                out.p(" ");
                out.p(method.getName());
                out.p("(");
                boolean first = true;
                Iterator iter2 = method.getParameters();
                while (iter2.hasNext()) {
                    JavaParameter parameter = (JavaParameter)iter2.next();
                    if (!first) {
                        out.p(", ");
                    }
                    if (parameter.isHolder()) {
                        out.p(this.env.getNames().holderClassName(port, parameter.getType()));
                    } else {
                        out.p(this.env.getNames().typeClassName(parameter.getType()));
                    }
                    out.p(" ");
                    out.p(parameter.getName());
                    first = false;
                }
                out.plnI(") throws ");
                Iterator exceptions = method.getExceptions();
                while (exceptions.hasNext()) {
                    String exception = (String)exceptions.next();
                    out.p(exception + ", ");
                }
                out.pln(" java.rmi.RemoteException;");
                out.pO();
            }
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + msg + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Model model, Configuration config, Properties options) {
        try {
            this.env = (ProcessorEnvironment)config.getEnvironment();
            this.env.getNames().resetPrefixFactory();
            String key = "sourceDirectory";
            String dirPath = options.getProperty(key);
            key = "donotOverride";
            this.donotOverride = Boolean.valueOf(options.getProperty(key));
            this.sourceDir = new File(dirPath);
            HashSet<String> interfaceNames = new HashSet<String>();
            this.JAXRPCVersion = options.getProperty("JAXRPC Version");
            String modelerName = (String)model.getProperty("com.sun.xml.rpc.processor.model.ModelerName");
            if (modelerName != null && modelerName.equals("com.sun.xml.rpc.processor.modeler.rmi.RmiModeler")) {
                Object var14_8 = null;
                this.sourceDir = null;
                this.env = null;
                return;
            }
            Iterator iter = model.getServices();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                Iterator iter2 = service.getPorts();
                while (iter2.hasNext()) {
                    Port port = (Port)iter2.next();
                    JavaInterface intf = port.getJavaInterface();
                    if (interfaceNames.contains(intf.getName())) continue;
                    this.generateClassFor(port);
                    interfaceNames.add(intf.getName());
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            this.sourceDir = null;
            this.env = null;
            throw throwable;
        }
        Object var14_9 = null;
        this.sourceDir = null;
        this.env = null;
    }
}

