/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config;

import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.j2ee.J2EEModeler;
import com.sun.xml.rpc.processor.modeler.j2ee.JaxRpcMappingXml;
import com.sun.xml.rpc.processor.modeler.j2ee.NamespaceHelper;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.constructorParameterOrderType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.exceptionMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.javaWsdlMapping;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.javaXmlTypeMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.methodParamPartsMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.portMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.serviceEndpointInterfaceMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.serviceEndpointMethodMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.serviceInterfaceMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.variableMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.wsdlMessageMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.wsdlMessageType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.wsdlReturnValueMappingType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.xsdQNameType;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

public class J2EEModelInfo
extends WSDLModelInfo
implements com.sun.xml.rpc.spi.tools.J2EEModelInfo {
    private JaxRpcMappingXml mappingFileXml;
    HashMap serviceMap = new HashMap();
    HashMap serviceEndpointMap = new HashMap();
    HashMap portMap = new HashMap();
    HashMap elementMap = new HashMap();
    HashMap exceptionMap = new HashMap();
    HashMap complexTypeMap = new HashMap();
    HashMap simpleTypeMap = new HashMap();
    HashMap anonymousSimpleTypeMap = new HashMap();
    HashMap anonymousComplexTypeMap = new HashMap();
    HashMap anonymousElementMap = new HashMap();
    private static String DEBUG = System.getProperty("com.sun.xml.rpc.j2ee.debug");

    public J2EEModelInfo() {
    }

    private void init() {
        int j;
        NamespaceHelper nsHelper = new NamespaceHelper();
        javaWsdlMapping javaWsdlMap = this.mappingFileXml.getJavaWsdlMapping();
        nsHelper = nsHelper.push(javaWsdlMap);
        int numjavaXmlMap = javaWsdlMap.getJavaXmlTypeMappingCount();
        this.debug("----------- numcount = : " + numjavaXmlMap);
        int i = 0;
        while (i < numjavaXmlMap) {
            javaXmlTypeMappingType xmlMap = javaWsdlMap.getJavaXmlTypeMapping(i);
            nsHelper = nsHelper.push(xmlMap);
            String scope = xmlMap.getQnameScope().getElementValue();
            xsdQNameType rtQname = xmlMap.getRootTypeQname();
            if (rtQname != null) {
                nsHelper = nsHelper.push(rtQname);
                QName qName = nsHelper.getQName(rtQname.getElementValue());
                nsHelper = nsHelper.pop();
                this.debug("rootTypeQNameID = " + rtQname.getId() + "; scope = " + scope + "; qName = " + qName);
                if (scope.equals("simpleType")) {
                    this.simpleTypeMap.put(qName, xmlMap);
                } else if (scope.equals("complexType")) {
                    this.complexTypeMap.put(qName, xmlMap);
                } else if (scope.equals("element")) {
                    this.elementMap.put(qName, xmlMap);
                }
            } else {
                String anonymousTypeName = xmlMap.getAnonymousTypeQname().getElementValue();
                this.debug("anonymousTypeQName = " + anonymousTypeName + " scope = " + scope);
                if (scope.equals("simpleType")) {
                    this.anonymousSimpleTypeMap.put(anonymousTypeName, xmlMap);
                } else if (scope.equals("complexType")) {
                    this.anonymousComplexTypeMap.put(anonymousTypeName, xmlMap);
                } else if (scope.equals("element")) {
                    this.anonymousElementMap.put(anonymousTypeName, xmlMap);
                }
            }
            nsHelper = nsHelper.pop();
            ++i;
        }
        int numExceptions = javaWsdlMap.getExceptionMappingCount();
        int i2 = 0;
        while (i2 < numExceptions) {
            ExceptionInfo exInfo = new ExceptionInfo();
            exceptionMappingType exMap = javaWsdlMap.getExceptionMapping(i2);
            nsHelper = nsHelper.push(exMap);
            exInfo.exceptionType = exMap.getExceptionType().getElementValue();
            wsdlMessageType wsdlMsg = exMap.getWsdlMessage();
            nsHelper = nsHelper.push(wsdlMsg);
            QName qname = nsHelper.getQName(wsdlMsg.getElementValue());
            nsHelper = nsHelper.pop();
            exInfo.wsdlMessage = qname;
            String partName = null;
            if (exMap.getWsdlMessagePartName() != null) {
                exInfo.wsdlMessagePartName = partName = exMap.getWsdlMessagePartName().getElementValue();
            }
            exInfo.constructorOrder = new HashMap();
            constructorParameterOrderType ctorOrder = exMap.getConstructorParameterOrder();
            if (ctorOrder != null) {
                int numConstructorParams = ctorOrder.getElementNameCount();
                j = 0;
                while (j < numConstructorParams) {
                    String param = ctorOrder.getElementName(j).getElementValue();
                    exInfo.constructorOrder.put(param, new Integer(j));
                    ++j;
                }
            }
            this.exceptionMap.put(qname.toString() + partName, exInfo);
            this.debug("===> ADD EXCEPTION MAP = " + qname.toString() + partName);
            nsHelper = nsHelper.pop();
            ++i2;
        }
        int numServiceInterfaceMappings = javaWsdlMap.getServiceInterfaceMappingCount();
        this.debug("Retrieving " + numServiceInterfaceMappings + "serviceInterfaceMapping");
        int i3 = 0;
        while (i3 < numServiceInterfaceMappings) {
            serviceInterfaceMappingType serviceMapping = javaWsdlMap.getServiceInterfaceMapping(i3);
            nsHelper = nsHelper.push(serviceMapping);
            xsdQNameType wsdlSvcname = serviceMapping.getWsdlServiceName();
            nsHelper = nsHelper.push(wsdlSvcname);
            QName serviceQName = nsHelper.getQName(wsdlSvcname.getElementValue());
            nsHelper = nsHelper.pop();
            String serviceNS = serviceQName.getNamespaceURI();
            this.serviceMap.put(serviceQName, serviceMapping);
            int numPortMaps = serviceMapping.getPortMappingCount();
            j = 0;
            while (j < numPortMaps) {
                portMappingType portMapping = serviceMapping.getPortMapping(j);
                QName portQName = new QName(serviceNS, portMapping.getPortName().getElementValue());
                this.portMap.put(portQName, portMapping);
                ++j;
            }
            nsHelper = nsHelper.pop();
            ++i3;
        }
        int numSEIMapping = javaWsdlMap.getServiceEndpointInterfaceMappingCount();
        this.debug("Retrieving " + numSEIMapping + "serviceEndpointInterfaceMapping");
        int i4 = 0;
        while (i4 < numSEIMapping) {
            serviceEndpointInterfaceMappingType seiMap = javaWsdlMap.getServiceEndpointInterfaceMapping(i4);
            nsHelper = nsHelper.push(seiMap);
            MetadataSEIInfo seiInfo = new MetadataSEIInfo();
            xsdQNameType wsdlBnd = seiMap.getWsdlBinding();
            nsHelper = nsHelper.push(wsdlBnd);
            seiInfo.bindingQName = nsHelper.getQName(wsdlBnd.getElementValue());
            nsHelper = nsHelper.pop();
            xsdQNameType wsdlPT = seiMap.getWsdlPortType();
            nsHelper = nsHelper.push(wsdlPT);
            seiInfo.portTypeQName = nsHelper.getQName(wsdlPT.getElementValue());
            nsHelper = nsHelper.pop();
            seiInfo.javaName = seiMap.getServiceEndpointInterface().getElementValue();
            int numMethodMaps = seiMap.getServiceEndpointMethodMappingCount();
            this.debug("adding binding: " + seiInfo.bindingQName + " portType " + seiInfo.portTypeQName + " with " + numMethodMaps + " methods");
            int j2 = 0;
            while (j2 < numMethodMaps) {
                serviceEndpointMethodMappingType methodMap = seiMap.getServiceEndpointMethodMapping(j2);
                nsHelper = nsHelper.push(methodMap);
                MetadataOperationInfo opInfo = new MetadataOperationInfo();
                opInfo.wsdlOpName = methodMap.getWsdlOperation().getElementValue();
                opInfo.javaOpName = methodMap.getJavaMethodName().getElementValue();
                opInfo.isWrapped = methodMap.getWrappedElement() != null;
                int numParams = methodMap.getMethodParamPartsMappingCount();
                this.debug("adding wsdlOp " + opInfo.wsdlOpName + " javaOp " + opInfo.javaOpName + " with " + numParams + " parameters" + "; isWrapped = " + opInfo.isWrapped);
                int k = 0;
                while (k < numParams) {
                    methodParamPartsMappingType methodParamMap = methodMap.getMethodParamPartsMapping(k);
                    nsHelper = nsHelper.push(methodParamMap);
                    MetadataParamInfo paramInfo = new MetadataParamInfo();
                    paramInfo.position = new Integer(methodParamMap.getParamPosition().getElementValue());
                    paramInfo.javaType = methodParamMap.getParamType().getElementValue();
                    wsdlMessageMappingType wsdlMsgMap = methodParamMap.getWsdlMessageMapping();
                    paramInfo.partName = wsdlMsgMap.getWsdlMessagePartName().getElementValue();
                    paramInfo.mode = wsdlMsgMap.getParameterMode().getElementValue();
                    wsdlMessageType wsdlmsg = wsdlMsgMap.getWsdlMessage();
                    nsHelper = nsHelper.push(wsdlmsg);
                    QName msgQName = nsHelper.getQName(wsdlmsg.getElementValue());
                    nsHelper = nsHelper.pop();
                    boolean bl = paramInfo.isSoapHeader = wsdlMsgMap.getSoapHeader() != null;
                    if (paramInfo.mode.equals("IN")) {
                        if (paramInfo.isSoapHeader) {
                            paramInfo.headerMessage = msgQName;
                            opInfo.explicitcontext = true;
                        } else if (opInfo.inputMessage == null) {
                            opInfo.inputMessage = msgQName;
                        } else if (!opInfo.inputMessage.equals(msgQName)) {
                            throw new ModelerException("inconsistent input message QNames found: " + opInfo.inputMessage + " and " + msgQName + " for IN param of operation " + opInfo.wsdlOpName);
                        }
                        opInfo.inputParts.put(paramInfo.partName, paramInfo);
                    } else if (paramInfo.mode.equals("OUT")) {
                        if (paramInfo.isSoapHeader) {
                            paramInfo.headerMessage = msgQName;
                            opInfo.explicitcontext = true;
                        } else if (opInfo.outputMessage == null) {
                            opInfo.outputMessage = msgQName;
                        } else if (!opInfo.outputMessage.equals(msgQName)) {
                            throw new ModelerException("Inconsistent output message QNames found: " + opInfo.outputMessage + " and " + msgQName);
                        }
                        opInfo.outputParts.put(paramInfo.partName, paramInfo);
                    } else if (paramInfo.mode.equals("INOUT")) {
                        if (opInfo.inputMessage == null) {
                            opInfo.inputMessage = msgQName;
                        } else if (!opInfo.inputMessage.equals(msgQName)) {
                            throw new ModelerException("inconsistent input message QNames found: " + opInfo.inputMessage + " and " + msgQName + " for INOUT param of operation " + opInfo.wsdlOpName);
                        }
                        opInfo.inoutParts.put(paramInfo.partName, paramInfo);
                    } else {
                        throw new ModelerException("invalid jaxrpc mapping meta-data: found param mode " + paramInfo.mode);
                    }
                    nsHelper = nsHelper.pop();
                    this.debug("adding parameter: " + paramInfo.javaType + " from message: " + msgQName + " and part " + paramInfo.partName + "; input msg = " + opInfo.inputMessage + "; outputMsg = " + opInfo.outputMessage + "; is header = " + paramInfo.isSoapHeader);
                    ++k;
                }
                wsdlReturnValueMappingType retMap = methodMap.getWsdlReturnValueMapping();
                if (retMap != null) {
                    wsdlMessageType wsdlMsg = retMap.getWsdlMessage();
                    nsHelper = nsHelper.push(wsdlMsg);
                    QName msgQName = nsHelper.getQName(wsdlMsg.getElementValue());
                    nsHelper = nsHelper.pop();
                    if (opInfo.outputMessage == null) {
                        opInfo.outputMessage = msgQName;
                    } else if (!opInfo.outputMessage.equals(msgQName)) {
                        throw new ModelerException("inconsistent input message QNames found: " + opInfo.outputMessage + " and " + msgQName + " in return value of operation " + opInfo.wsdlOpName);
                    }
                    if (retMap.getWsdlMessagePartName() != null) {
                        MetadataParamInfo retParam = new MetadataParamInfo();
                        retParam.javaType = retMap.getMethodReturnValue().getElementValue();
                        retParam.partName = retMap.getWsdlMessagePartName().getElementValue();
                        opInfo.retPart = retParam;
                        this.debug("adding return value: " + retParam.javaType + " from message: " + msgQName + " and part " + retParam.partName);
                    }
                }
                this.debug("adding wsdlOp " + opInfo.wsdlOpName + " javaOp " + opInfo.javaOpName + " with " + numParams + " parameters" + "; isWrapped = " + opInfo.isWrapped + "; inputMsg = " + opInfo.inputMessage + "; outputMessage = " + opInfo.outputMessage);
                seiInfo.operationInfo.add(opInfo);
                nsHelper = nsHelper.pop();
                ++j2;
            }
            this.debug("putting " + seiInfo.bindingQName + " in serviceEndpointMap");
            this.serviceEndpointMap.put(seiInfo.bindingQName, seiInfo);
            nsHelper = nsHelper.pop();
            ++i4;
        }
        nsHelper = nsHelper.pop();
        this.debug("init complete");
    }

    private Names getNames() {
        return ((ProcessorEnvironment)this.getConfiguration().getEnvironment()).getNames();
    }

    public J2EEModelInfo(JaxRpcMappingXml mappingXml) {
        this.setJaxRcpMappingXml(mappingXml);
    }

    public void setJaxRcpMappingXml(JaxRpcMappingXml mappingXml) {
        this.mappingFileXml = mappingXml;
        NamespaceMappingRegistryInfo nsMapInfo = new NamespaceMappingRegistryInfo();
        HashMap nsMap = this.mappingFileXml.getNSToPkgMapping();
        Set keys = nsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            String pkg = (String)nsMap.get(ns);
            NamespaceMappingInfo map = new NamespaceMappingInfo(ns, pkg);
            nsMapInfo.addMapping(map);
        }
        this.setNamespaceMappingRegistry(nsMapInfo);
        this.init();
    }

    private void debug(String msg) {
        if (DEBUG != null) {
            System.out.println("[J2EEModelInfo] ==> " + msg);
        }
    }

    protected Modeler getModeler(Properties options) {
        return new J2EEModeler(this, options);
    }

    public String javaNameOfType(TypeDefinitionComponent component) {
        QName typeQName = component.getName();
        this.debug("javaNameOfType component.getName = " + component.getName());
        javaXmlTypeMappingType xmlMap = null;
        if (component.isSimple()) {
            xmlMap = (javaXmlTypeMappingType)this.simpleTypeMap.get(typeQName);
        } else if (component.isComplex()) {
            xmlMap = (javaXmlTypeMappingType)this.complexTypeMap.get(typeQName);
            if (xmlMap == null) {
                xmlMap = (javaXmlTypeMappingType)this.elementMap.get(typeQName);
            }
        } else {
            throw new IllegalArgumentException("type is neither simple nor complex");
        }
        if (xmlMap != null) {
            return xmlMap.getJavaType().getElementValue();
        }
        return this.makePackageQualified(this.getNames().validJavaClassName(typeQName.getLocalPart()), typeQName);
    }

    private String getJavaPackageName(QName qname) {
        NamespaceMappingInfo info;
        Object ret = null;
        NamespaceMappingRegistryInfo nsMap = this.getNamespaceMappingRegistry();
        if (nsMap != null && (info = nsMap.getNamespaceMappingInfo(qname)) != null) {
            return info.getJavaPackageName();
        }
        return null;
    }

    String getNonQualifiedNameFor(QName name) {
        return this.getNames().validJavaClassName(name.getLocalPart());
    }

    public String javaNameOfPort(QName port) {
        portMappingType portMapping = (portMappingType)this.portMap.get(port);
        if (portMapping != null) {
            return portMapping.getJavaPortName().getElementValue();
        }
        return null;
    }

    public String javaNameOfService(QName service) {
        String serviceInterface = null;
        serviceInterfaceMappingType serviceMapping = (serviceInterfaceMappingType)this.serviceMap.get(service);
        if (serviceMapping != null) {
            serviceInterface = serviceMapping.getServiceInterface().getElementValue();
        } else {
            serviceInterface = this.getNames().validJavaClassName(service.getLocalPart());
            String javaPackageName = this.getJavaPackageName(service);
            if (javaPackageName != null) {
                serviceInterface = javaPackageName + "." + serviceInterface;
            }
        }
        return serviceInterface;
    }

    public HashMap exceptionConstructorOrder(QName wsdlMessage) {
        ExceptionInfo exInfo = (ExceptionInfo)this.exceptionMap.get(wsdlMessage.toString());
        if (exInfo == null) {
            return null;
        }
        return exInfo.constructorOrder;
    }

    private QName stringToQName(String s) {
        return new QName(s);
    }

    public ExceptionInfo getExceptionInfo(QName wsdlMessage, String partName) {
        return (ExceptionInfo)this.exceptionMap.get(wsdlMessage.toString() + partName);
    }

    public JavaMemberInfo javaMemberInfo(TypeDefinitionComponent component, String member) {
        QName typeQName = component.getName();
        javaXmlTypeMappingType xmlMap = null;
        if (!component.isComplex()) {
            throw new IllegalArgumentException("type is neither simple nor complex");
        }
        xmlMap = (javaXmlTypeMappingType)this.complexTypeMap.get(typeQName);
        JavaMemberInfo ret = null;
        if (xmlMap != null) {
            int numVariableMappings = xmlMap.getVariableMappingCount();
            int i = 0;
            while (i < numVariableMappings) {
                variableMappingType variableMap = xmlMap.getVariableMapping(i);
                if (variableMap.getXmlElementName() != null && variableMap.getXmlElementName().getElementValue().equals(member)) {
                    ret = new JavaMemberInfo();
                    ret.javaMemberName = variableMap.getJavaVariableName().getElementValue();
                    ret.isDataMember = variableMap.getDataMember() != null;
                    break;
                }
                ++i;
            }
        }
        if (ret == null) {
            ret = new JavaMemberInfo();
            ret.javaMemberName = this.getNames().validJavaMemberName(member);
            ret.isDataMember = false;
        }
        return ret;
    }

    public JavaMemberInfo javaMemberOfElementInfo(QName typeQName, String member) {
        javaXmlTypeMappingType xmlMap = (javaXmlTypeMappingType)this.elementMap.get(typeQName);
        JavaMemberInfo ret = null;
        if (xmlMap != null) {
            int numVariableMappings = xmlMap.getVariableMappingCount();
            int i = 0;
            while (i < numVariableMappings) {
                variableMappingType variableMap = xmlMap.getVariableMapping(i);
                if (variableMap.getXmlElementName().getElementValue().equals(member)) {
                    ret = new JavaMemberInfo();
                    ret.javaMemberName = variableMap.getJavaVariableName().getElementValue();
                    ret.isDataMember = variableMap.getDataMember() != null;
                    break;
                }
                ++i;
            }
        }
        if (ret == null) {
            ret = new JavaMemberInfo();
            ret.javaMemberName = this.getNames().validJavaMemberName(member);
            ret.isDataMember = false;
        }
        return ret;
    }

    public String javaNameOfElementType(QName typeQName, String anonymousName) {
        javaXmlTypeMappingType xmlMap = null;
        this.debug("Looking for type = " + typeQName + "; anonymous = " + anonymousName);
        if (anonymousName != null) {
            String anonymousTypeName = typeQName.getNamespaceURI() + ":" + anonymousName;
            xmlMap = (javaXmlTypeMappingType)this.anonymousElementMap.get(anonymousTypeName);
            if (xmlMap == null) {
                xmlMap = (javaXmlTypeMappingType)this.anonymousComplexTypeMap.get(anonymousTypeName);
            }
        } else {
            xmlMap = (javaXmlTypeMappingType)this.elementMap.get(typeQName);
            if (xmlMap == null) {
                xmlMap = (javaXmlTypeMappingType)this.complexTypeMap.get(typeQName);
            }
        }
        this.debug("111 typeQName = " + typeQName + "; xmlMap = " + xmlMap);
        if (xmlMap != null) {
            return xmlMap.getJavaType().getElementValue();
        }
        return this.makePackageQualified(this.getNames().validJavaClassName(typeQName.getLocalPart()), typeQName);
    }

    private String makePackageQualified(String s, QName name) {
        String javaPackageName = this.getJavaPackageName(name);
        if (javaPackageName != null) {
            return javaPackageName + "." + s;
        }
        return s;
    }

    public String javaNameOfSEI(QName bindingQName, QName portTypeQName, QName portQName) {
        String sei = null;
        MetadataSEIInfo seiInfo = (MetadataSEIInfo)this.serviceEndpointMap.get(bindingQName);
        if (seiInfo != null) {
            sei = seiInfo.javaName;
        } else {
            this.debug("javaNameOfSEI: seiInfo is null");
            sei = portTypeQName != null ? this.makePackageQualified(this.getNonQualifiedNameFor(portTypeQName), portTypeQName) : this.makePackageQualified(this.getNonQualifiedNameFor(portQName), portQName);
        }
        this.debug("javaNameofSEI" + bindingQName + " is:" + sei);
        return sei;
    }

    public MetadataOperationInfo findOperationInfo(QName bindingQName, String operationName, Message inputMsg, Message outputMsg) {
        QName inputMsgQName = J2EEModeler.getQNameOf(inputMsg);
        QName outMsgQName = outputMsg != null ? J2EEModeler.getQNameOf(outputMsg) : null;
        this.debug("findOperationInfoRpcencoded for " + bindingQName + " operation: " + operationName + " inputMsg: " + inputMsgQName + " outputMsg: " + outMsgQName);
        MetadataSEIInfo seiInfo = (MetadataSEIInfo)this.serviceEndpointMap.get(bindingQName);
        if (seiInfo != null) {
            Iterator it = seiInfo.operationInfo.iterator();
            while (it.hasNext()) {
                int actualMatch;
                MetadataOperationInfo opInfo = (MetadataOperationInfo)it.next();
                this.debug("comparing wsdlOp: " + opInfo.wsdlOpName);
                this.debug("inputMsg: " + opInfo.inputMessage);
                this.debug("outputMsg: " + opInfo.outputMessage);
                if (!opInfo.wsdlOpName.equals(operationName) || opInfo.inputMessage != null && !opInfo.inputMessage.equals(inputMsgQName) || opInfo.outputMessage != null && !opInfo.outputMessage.equals(outMsgQName)) continue;
                this.debug("compatible input/output message");
                int numInputMatch = 0;
                int numOutputMatch = 0;
                int numInoutMatch = 0;
                int numRetMatch = 0;
                boolean match = true;
                Iterator inIterator = inputMsg.parts();
                while (inIterator.hasNext()) {
                    MessagePart msgPart = (MessagePart)inIterator.next();
                    String partName = msgPart.getName();
                    this.debug("comparing inmsg partName " + partName);
                    if (opInfo.inputParts.get(partName) != null) {
                        this.debug(partName + " matches IN");
                        ++numInputMatch;
                        continue;
                    }
                    if (opInfo.inoutParts.get(partName) != null) {
                        this.debug(partName + " matches INOUT");
                        ++numInoutMatch;
                        continue;
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                if (outputMsg != null) {
                    Iterator outIterator = outputMsg.parts();
                    while (outIterator != null && outIterator.hasNext()) {
                        MessagePart msgPart = (MessagePart)outIterator.next();
                        String partName = msgPart.getName();
                        this.debug("comparing outmsg partName " + partName);
                        if (opInfo.outputParts.get(partName) != null) {
                            this.debug(partName + " matches OUT");
                            ++numOutputMatch;
                            continue;
                        }
                        if (opInfo.inoutParts.get(partName) != null) {
                            this.debug(partName + " matches INOUT");
                            ++numInoutMatch;
                            continue;
                        }
                        if (opInfo.retPart != null && partName.equals(opInfo.retPart.partName)) {
                            this.debug(partName + " matches RET");
                            ++numRetMatch;
                            continue;
                        }
                        match = false;
                        break;
                    }
                }
                int expectedMatch = opInfo.inputParts.size() + opInfo.outputParts.size() + opInfo.inoutParts.size() * 2;
                if (opInfo.retPart != null) {
                    ++expectedMatch;
                }
                if ((actualMatch = numInputMatch + numOutputMatch + numInoutMatch + numRetMatch) == expectedMatch) {
                    return opInfo;
                }
                this.debug("actualmatch: " + actualMatch + ", expectedMatch:" + expectedMatch);
            }
            throw new ModelerException("Unable to locate jax-rpc mapping meta-data for wsdl operation " + operationName + " in binding " + bindingQName);
        }
        return null;
    }

    public class ExceptionInfo {
        public String exceptionType;
        public QName wsdlMessage;
        public String wsdlMessagePartName;
        public HashMap constructorOrder;
    }

    public static class JavaMemberInfo {
        public boolean isDataMember;
        public String javaMemberName;

        public JavaMemberInfo() {
        }

        public JavaMemberInfo(String javaMemberName, boolean isDataMember) {
            this.javaMemberName = javaMemberName;
            this.isDataMember = isDataMember;
        }
    }

    public class MetadataOperationInfo {
        public String wsdlOpName;
        public String javaOpName;
        public QName inputMessage;
        public QName outputMessage;
        public HashMap inputParts = new HashMap();
        public HashMap outputParts = new HashMap();
        public HashMap inoutParts = new HashMap();
        public boolean isWrapped;
        public boolean explicitcontext = false;
        MetadataParamInfo retPart;
    }

    public class MetadataParamInfo {
        public QName headerMessage;
        public int position;
        public String javaType;
        public String partName;
        public String mode;
        public boolean isSoapHeader;
    }

    public class MetadataSEIInfo {
        public String javaName;
        public QName bindingQName;
        public QName portTypeQName;
        List operationInfo = new Vector();
    }
}

