/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerBase;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;

public class ObjectArraySerializer
extends ArraySerializerBase
implements Initializable {
    protected JAXRPCSerializer elemSer;
    protected JAXRPCDeserializer elemDeser;

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.elemSer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.elemClass, this.elemType);
        this.elemDeser = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.elemClass, this.elemType);
    }

    public static void setElement(Object[] value, int[] position, Object elem) {
        Object[] arr = value;
        int i = 0;
        while (i < position.length - 1) {
            arr = (Object[])arr[position[i]];
            ++i;
        }
        arr[position[position.length - 1]] = elem;
    }

    protected void serializeArrayInstance(Object obj, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.serializeArrayElements((Object[])obj, 0, dims, writer, context);
    }

    protected void serializeArrayElements(Object[] arr, int level, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (arr == null || arr.length != dims[level]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean serializeLeaves = level == dims.length - 1;
        int i = 0;
        while (i < dims[level]) {
            Object elem = arr[i];
            if (serializeLeaves) {
                this.elemSer.serialize(elem, this.elemName, null, writer, context);
            } else {
                this.serializeArrayElements((Object[])elem, level + 1, dims, writer, context);
            }
            ++i;
        }
    }

    protected Object deserializeArrayInstance(XMLReader reader, SOAPDeserializationContext context, int[] dims) throws Exception {
        String id = this.getID(reader);
        SOAPDeserializationState state = id != null ? context.getStateFor(id) : null;
        boolean isComplete = true;
        boolean emptyDims = ArraySerializerBase.isEmptyDimensions(dims);
        int[] dimOffsets = ArraySerializerBase.getDimensionOffsets(dims);
        int[] offset = ArraySerializerBase.getArrayOffset(reader, dims);
        if (offset == null) {
            offset = new int[emptyDims ? 1 : dims.length];
        }
        Object[] value = null;
        int maxPosition = 0;
        int length = 0;
        if (reader.nextElementContent() != 2) {
            Object[] newValue;
            boolean isSparseArray;
            int[] position = ArraySerializerBase.getArrayElementPosition(reader, dims);
            boolean bl = isSparseArray = position != null;
            if (!isSparseArray) {
                position = offset;
            }
            if (emptyDims) {
                maxPosition = position[0];
                length = Math.max(maxPosition * 2, 1024);
                value = (Object[])Array.newInstance(this.elemClass, length);
            } else {
                value = (Object[])Array.newInstance(this.elemClass, dims);
            }
            while (true) {
                if (!emptyDims && !ArraySerializerBase.isPositionWithinBounds(position, dims)) {
                    if (isSparseArray) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(position));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (emptyDims && position[0] >= length) {
                    int newLength = length * 2;
                    while (position[0] >= newLength) {
                        newLength *= 2;
                    }
                    newValue = (Object[])Array.newInstance(this.elemClass, newLength);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                    length = newLength;
                }
                Object elem = null;
                elem = this.elemDeser.deserialize(null, reader, context);
                if (elem instanceof SOAPDeserializationState) {
                    SOAPDeserializationState elemState = (SOAPDeserializationState)elem;
                    isComplete = false;
                    if (state == null) {
                        state = new SOAPDeserializationState();
                    }
                    state.setInstance(value);
                    if (state.getBuilder() == null) {
                        state.setBuilder(new ObjectArrayInstanceBuilder(dimOffsets));
                    }
                    elemState.registerListener(state, ArraySerializerBase.indexFromPosition(position, dimOffsets));
                } else {
                    ObjectArraySerializer.setElement(value, position, elem);
                }
                if (reader.nextElementContent() == 2) break;
                if (isSparseArray) {
                    position = ArraySerializerBase.getArrayElementPosition(reader, dims);
                    if (position == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (emptyDims) {
                    position[0] = position[0] + 1;
                } else {
                    ArraySerializerBase.incrementPosition(position, dims);
                }
                if (!emptyDims) continue;
                maxPosition = Math.max(position[0], maxPosition);
            }
            if (emptyDims && length != maxPosition + 1) {
                int newLength = maxPosition + 1;
                newValue = (Object[])Array.newInstance(this.elemClass, newLength);
                System.arraycopy(value, 0, newValue, 0, newLength);
                value = newValue;
                length = newLength;
            }
        } else {
            value = emptyDims ? (Object[])Array.newInstance(this.elemClass, 0) : (Object[])Array.newInstance(this.elemClass, dims);
        }
        if (state != null) {
            state.setDeserializer(this);
            state.setInstance(value);
            state.doneReading();
        }
        if (isComplete) {
            return value;
        }
        return state;
    }

    public ObjectArraySerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims) {
        this(type, encodeType, isNullable, encodingStyle, elemName, elemType, elemClass, rank, dims, SOAPVersion.SOAP_11);
    }

    public ObjectArraySerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims, SOAPVersion version) {
        super(type, encodeType, isNullable, encodingStyle, elemName, elemType, elemClass, rank, dims, version);
    }

    private class ObjectArrayInstanceBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;
        int[] dimOffsets = null;

        public void construct() {
            throw new IllegalStateException();
        }

        public void initialize() {
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        ObjectArrayInstanceBuilder(int[] dimOffsets) {
            this.dimOffsets = dimOffsets;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setMember(int index, Object memberValue) {
            int[] position = ArraySerializerBase.positionFromIndex(index, this.dimOffsets);
            ObjectArraySerializer.setElement(this.instance, position, memberValue);
        }

        public void setInstance(Object instance) {
            this.instance = (Object[])instance;
        }
    }
}

