/*
 * Decompiled with CFR 0.152.
 */
package example.mmademo;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.media.MediaException;

public class Utils {
    public static boolean DEBUG = false;

    private Utils() {
    }

    public static void debugOut(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void debugOut(Throwable throwable) {
        if (DEBUG) {
            System.out.println(throwable.toString());
        }
        if (DEBUG) {
            throwable.printStackTrace();
        }
    }

    public static void error(Throwable throwable, BreadCrumbTrail breadCrumbTrail) {
        if (DEBUG) {
            throwable.printStackTrace();
        }
        Utils.error(Utils.friendlyException(throwable), breadCrumbTrail);
    }

    public static void error(String string, BreadCrumbTrail breadCrumbTrail) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        breadCrumbTrail.replaceCurrent((Displayable)alert);
    }

    public static void FYI(String string, BreadCrumbTrail breadCrumbTrail) {
        Alert alert = new Alert("FYI", string, null, AlertType.INFO);
        alert.setTimeout(-2);
        breadCrumbTrail.replaceCurrent((Displayable)alert);
    }

    public static String friendlyException(Throwable throwable) {
        if (throwable instanceof MediaException && throwable.getMessage().indexOf(" ") > 5) {
            return throwable.getMessage();
        }
        String string = throwable.toString();
        while (true) {
            int n;
            int n2 = string.indexOf(".");
            int n3 = string.indexOf(" ");
            if (n3 < 0) {
                n3 = string.length();
            }
            if ((n = string.indexOf(":")) < 0) {
                n = string.length();
            }
            if (n2 < 0 || n2 >= n3 || n2 >= n) break;
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public static void query(String string, String string2, int n, QueryListener queryListener, BreadCrumbTrail breadCrumbTrail) {
        Utils.query(string, string2, n, 0, queryListener, breadCrumbTrail);
    }

    public static void query(String string, String string2, int n, int n2, QueryListener queryListener, BreadCrumbTrail breadCrumbTrail) {
        TextBox textBox = new TextBox(string, string2, n, n2);
        textBox.addCommand(QueryTask.cancelCommand);
        textBox.addCommand(QueryTask.OKCommand);
        QueryTask queryTask = new QueryTask(queryListener, breadCrumbTrail);
        textBox.setCommandListener((CommandListener)queryTask);
        breadCrumbTrail.go((Displayable)textBox);
    }

    public static String[] splitURL(String string) throws Exception {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(string);
        String[] stringArray = new String[6];
        for (n3 = 0; n3 <= 5; ++n3) {
            stringArray[n3] = "";
        }
        n3 = 0;
        int n4 = string.indexOf(":");
        if (n4 > 0) {
            stringArray[0] = string.substring(0, n4);
            stringBuffer.delete(0, n4 + 1);
            n3 = 1;
        } else if (n4 == 0) {
            throw new Exception("url format error - protocol");
        }
        if (stringBuffer.length() > 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '/') {
            stringBuffer.delete(0, 2);
            n2 = stringBuffer.toString().indexOf(47);
            if (n2 < 0) {
                n2 = stringBuffer.length();
            }
            int n5 = stringBuffer.toString().indexOf(58);
            n = n2;
            if (n5 >= 0) {
                if (n5 > n2) {
                    throw new Exception("url format error - port");
                }
                n = n5;
                stringArray[2] = stringBuffer.toString().substring(n5 + 1, n2);
            }
            stringArray[1] = stringBuffer.toString().substring(0, n);
            stringBuffer.delete(0, n2);
        }
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
            n2 = string.lastIndexOf(47);
            if (n2 > 0) {
                stringArray[3] = string.substring(0, n2);
            }
            if (n2 < string.length() - 1) {
                String string2 = string.substring(n2 + 1, string.length());
                n = string2.indexOf("#");
                if (n >= 0) {
                    stringArray[4] = string2.substring(0, n);
                    stringArray[5] = string2.substring(n + 1);
                } else {
                    stringArray[4] = string2;
                }
            }
        }
        return stringArray;
    }

    public static String mergeURL(String[] stringArray) {
        return (stringArray[0] == "" ? "" : stringArray[0] + ":/") + (stringArray[1] == "" ? "" : "/" + stringArray[1]) + (stringArray[2] == "" ? "" : ":" + stringArray[2]) + stringArray[3] + "/" + stringArray[4] + (stringArray[5] == "" ? "" : "#" + stringArray[5]);
    }

    public static String guessContentType(String string) throws Exception {
        String[] stringArray = Utils.splitURL(string);
        String string2 = "";
        String string3 = "";
        int n = stringArray[4].lastIndexOf(46);
        if (n >= 0) {
            string2 = stringArray[4].substring(n + 1).toLowerCase();
        }
        if (string2.equals("mpg") || string.equals("avi")) {
            string3 = "video/mpeg";
        } else if (string2.equals("mid") || string2.equals("kar")) {
            string3 = "audio/midi";
        } else if (string2.equals("wav")) {
            string3 = "audio/x-wav";
        } else if (string2.equals("jts")) {
            string3 = "audio/x-tone-seq";
        } else if (string2.equals("txt")) {
            string3 = "audio/x-txt";
        } else if (string2.equals("amr")) {
            string3 = "audio/amr";
        } else if (string2.equals("awb")) {
            string3 = "audio/amr-wb";
        } else if (string2.equals("gif")) {
            string3 = "image/gif";
        }
        return string3;
    }

    private static void quickSort(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            String string = stringArray[(n + n2) / 2].toUpperCase();
            while (n3 <= n4) {
                while (n3 < n2 && stringArray[n3].toUpperCase().compareTo(string) < 0) {
                    ++n3;
                }
                while (n4 > n && stringArray[n4].toUpperCase().compareTo(string) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                String string2 = stringArray[n3];
                stringArray[n3] = stringArray[n4];
                stringArray[n4] = string2;
                ++n3;
                --n4;
            }
            if (n < n4) {
                Utils.quickSort(stringArray, n, n4);
            }
            if (n3 < n2) {
                Utils.quickSort(stringArray, n3, n2);
            }
        }
    }

    public static void sort(String[] stringArray) {
        Utils.quickSort(stringArray, 0, stringArray.length - 1);
    }

    static interface Interruptable {
        public void pauseApp();

        public void resumeApp();
    }

    static interface QueryListener {
        public void queryOK(String var1);

        public void queryCancelled();
    }

    static interface ContentHandler {
        public void close();

        public boolean canHandle(String var1);

        public void handle(String var1, String var2);
    }

    static interface BreadCrumbTrail {
        public Displayable go(Displayable var1);

        public Displayable goBack();

        public void handle(String var1, String var2);

        public Displayable replaceCurrent(Displayable var1);

        public Displayable getCurrentDisplayable();
    }

    private static class QueryTask
    implements CommandListener,
    Runnable {
        private static Command cancelCommand = new Command("Cancel", 3, 1);
        private static Command OKCommand = new Command("OK", 4, 1);
        private QueryListener queryListener;
        private BreadCrumbTrail queryBCT;
        private static String queryText = "";

        private QueryTask(QueryListener queryListener, BreadCrumbTrail breadCrumbTrail) {
            this.queryListener = queryListener;
            this.queryBCT = breadCrumbTrail;
        }

        public void commandAction(Command command, Displayable displayable) {
            if (this.queryBCT != null) {
                Utils.debugOut("Utils.commandAction: goBack()");
                this.queryBCT.goBack();
            }
            if (command == cancelCommand) {
                Utils.debugOut("Command: cancel");
                if (this.queryListener != null) {
                    this.queryListener.queryCancelled();
                }
            } else if (command == OKCommand) {
                Utils.debugOut("Command: OK");
                if (this.queryListener != null) {
                    queryText = "";
                    if (displayable instanceof TextBox) {
                        queryText = ((TextBox)displayable).getString();
                    }
                    new Thread(this).start();
                }
            }
        }

        public void run() {
            this.sendListenerEvent();
        }

        private void sendListenerEvent() {
            if (this.queryListener != null) {
                this.queryListener.queryOK(queryText);
            }
        }
    }
}

