/*
 * Decompiled with CFR 0.152.
 */
package example.mmademo;

import example.mmademo.BaseListMidlet;
import example.mmademo.DrummerCanvas;
import example.mmademo.Utils;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class SimpleTones
extends BaseListMidlet
implements Utils.BreadCrumbTrail {
    private static final boolean USE_LONG_MIDI = false;
    private Player mp;
    byte[] niceChord = new byte[]{43, 64, 68, 76, 83, 88, 35, 59, 50, 31};

    public SimpleTones() {
        super("MMAPI Simple Tones");
    }

    protected void fillList(List list) {
        list.append("Short Single Tone", null);
        list.append("Long Single Tone", null);
        list.append("Short MIDI event", null);
        list.append("MMAPI Drummer", null);
        list.addCommand(this.exitCommand);
        list.addCommand(this.playCommand);
    }

    protected void selectCommand(int n) {
        switch (n) {
            case 0: {
                this.simpleTone(60, 100);
                break;
            }
            case 1: {
                this.simpleTone(64, 1000);
                break;
            }
            case 2: {
                this.midiShort();
                break;
            }
            case 3: 
            case 4: {
                this.drummer();
            }
        }
    }

    public void destroyApp(boolean bl) {
        if (this.mp != null) {
            this.mp.close();
            this.mp = null;
        }
    }

    private void simpleTone(int n, int n2) {
        try {
            Manager.playTone((int)n, (int)n2, (int)80);
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this);
        }
    }

    MIDIControl getMIDIControl() throws Exception {
        if (this.mp == null) {
            this.mp = Manager.createPlayer((String)"device://midi");
            this.mp.prefetch();
        }
        return (MIDIControl)this.mp.getControl("javax.microedition.media.control.MIDIControl");
    }

    private void midiShort() {
        try {
            int n;
            MIDIControl mIDIControl = this.getMIDIControl();
            for (n = 0; n < this.niceChord.length; ++n) {
                mIDIControl.shortMidiEvent(144, (int)this.niceChord[n], 127);
            }
            mIDIControl.shortMidiEvent(153, 35, 127);
            mIDIControl.shortMidiEvent(153, 35, 0);
            mIDIControl.shortMidiEvent(153, 58, 127);
            mIDIControl.shortMidiEvent(153, 58, 0);
            mIDIControl.shortMidiEvent(153, 57, 127);
            mIDIControl.shortMidiEvent(153, 57, 0);
            Thread.sleep(200L);
            for (n = 0; n < this.niceChord.length; ++n) {
                mIDIControl.shortMidiEvent(144, (int)this.niceChord[n], 0);
            }
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this);
        }
    }

    private void midiLong() {
        try {
            int n;
            MIDIControl mIDIControl = this.getMIDIControl();
            int n2 = this.niceChord.length * 3;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            for (n = 0; n < n2 / 3; ++n) {
                byArray[n3++] = -112;
                byArray[n3++] = this.niceChord[n % this.niceChord.length];
                byArray[n3++] = 127;
            }
            n = mIDIControl.longMidiEvent(byArray, 0, n2);
            Thread.sleep(200L);
            for (int i = 2; i < n2; i += 3) {
                byArray[i] = 0;
            }
            n = mIDIControl.longMidiEvent(byArray, 0, n2);
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this);
        }
    }

    private synchronized void drummer() {
        DrummerCanvas drummerCanvas = new DrummerCanvas(this, this);
        this.go((Displayable)drummerCanvas);
        drummerCanvas.show();
    }

    public void handle(String string, String string2) {
        throw new RuntimeException("SimpleTones.handle() must not be called");
    }
}

