/*
 * Decompiled with CFR 0.152.
 */
package example.mmademo;

import example.mmademo.SimplePlayerCanvas;
import example.mmademo.Utils;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.RecordControl;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class SimplePlayerGUI
implements CommandListener,
PlayerListener,
ItemStateListener {
    private static final boolean USE_FORM_PLAYER_FOR_VIDEO = false;
    private static final int LIMIT_RATE = 300;
    private static final int LOOP_ONCE = 0;
    private static final int LOOP_3 = 1;
    private static final int LOOP_INF = 2;
    private int loopmode = 0;
    private static final int DEFAULT_TIMER_INTERVAL = 50;
    private int timerInterval = 50;
    private static final int GAUGE_NONE = -1;
    private static final int GAUGE_VOLUME = 0;
    private static final int GAUGE_RATE = 1;
    private static final int GAUGE_TEMPO = 2;
    private static final int GAUGE_PITCH = 3;
    private int gaugeMode = -1;
    private Gauge gauge = null;
    private StringItem gaugeLabel = null;
    private Form gaugeForm = null;
    private Timer guiTimer = null;
    private TimerTask timeDisplayTask = null;
    Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command stopCommand = new Command("Stop", 8, 1);
    private Command metaCommand = new Command("META data", 8, 3);
    private Command volCommand = new Command("Volume", 8, 2);
    private Command muteCommand = new Command("Mute", 8, 1);
    private Command unmuteCommand = new Command("Unmute", 8, 1);
    private Command loopCommand = new Command("Loopmode", 8, 4);
    private Command stcCommand = new Command("Stop in 5 sec", 8, 4);
    private Command selectCommand = new Command("Select", 8, 1);
    private Command skipFwCommand = new Command("Skip Forward", 8, 5);
    private Command skipBwCommand = new Command("Skip Backward", 8, 5);
    private Command rewindCommand = new Command("Rewind", 8, 5);
    private Command rateCommand = new Command("Rate", 8, 5);
    private Command tempoCommand = new Command("Tempo", 8, 5);
    private Command pitchCommand = new Command("Pitch", 8, 5);
    private Command fullScreenCommand = new Command("Full Screen: ON", 8, 5);
    private Command normalScreenCommand = new Command("Full Screen: OFF", 8, 5);
    private Command startRecordCommand = new Command("Start Recording", 8, 5);
    private Command stopRecordCommand = new Command("Stop Recording", 8, 5);
    private Command helpCommand = new Command("Quick Help", 8, 10);
    private Parent parent;
    private Displayable display;
    private static Image logo = null;
    private boolean fullScreen = false;
    private boolean isRecording = false;
    private String recordLocator = "file:///root1/recording.wav";
    private Player player = null;
    private String title;
    private InputStream songInputStream;
    private String durationStr;
    private String songContentType = "";
    private String songLocator = "";
    private String songName = "";
    private String[] songDisplayNames = new String[0];
    private int currSongDisplay = 0;
    private int changeSongDisplayCounter = 0;
    private static final int SONG_DISPLAY_COUNTER = 40;
    private static final int LYRICS_EVENT = 96;
    private static final String LYRICS_KEY = "lyrics";
    public static final int KARAOKE_LINE_COUNT = 0;
    public static final int KARAOKE_LINE = 1;
    public static final int KARAOKE_LINE_INDEX = 2;
    public static final int KARAOKE_SYLLABLE_LENGTH = 3;
    private boolean karaokeMode = false;
    private String karaokeLyrics = "";
    private int currKaraokeLine = 0;
    private int currKaraokeLinePos = 0;
    private int currKaraokeLength = 0;
    private String[] karaokeLines = null;
    private int[] karaokeLinePos = null;
    private int karaokeLineCount = 0;
    private int redisplayKaraokeCounter = 0;
    private int nextKaraokePos = 0;
    private boolean restartOnResume = false;

    private static void debugOut(String string) {
        Utils.debugOut("SimplePlayerGUI: " + string);
    }

    public void initialize(String string, Parent parent) {
        this.title = string;
        this.setParent(parent);
        this.initialize();
    }

    public void setParent(Parent parent) {
        this.parent = parent;
        if (!(parent instanceof Displayable)) {
            throw new RuntimeException("parent must be instanceof Displayable!");
        }
        this.display = (Displayable)parent;
        this.display.addCommand(this.backCommand);
        this.display.setCommandListener((CommandListener)this);
        this.updateTime();
        this.updateRate(null);
        this.updateTempo(null);
        this.durationUpdated();
        parent.updateKaraoke();
        parent.updateDisplay();
    }

    private void initialize() {
        this.karaokeMode = false;
        this.karaokeLyrics = "";
        this.currKaraokeLine = 0;
        this.currKaraokeLinePos = 0;
        this.currKaraokeLength = 0;
        this.karaokeLines = null;
        this.karaokeLinePos = null;
        this.karaokeLineCount = 0;
        this.redisplayKaraokeCounter = 0;
        this.removeCommands();
        this.setStatus("");
        this.durationStr = "";
        this.setSong("No song loaded", "");
        this.guiTimer = new Timer();
    }

    public void setSong(String string, String string2) {
        this.songLocator = string2;
        this.songInputStream = null;
        this.songContentType = "";
        this.doSetSong(string);
    }

    public void setSong(String string, InputStream inputStream, String string2) {
        this.songLocator = "";
        this.songInputStream = inputStream;
        this.songContentType = string2;
        this.doSetSong(string);
    }

    public void setSong(String string, Player player) {
        this.songLocator = "";
        this.songInputStream = null;
        this.songContentType = "";
        this.doSetSong(string);
        this.player = player;
    }

    private void doSetSong(String string) {
        this.songName = string;
        this.songDisplayNames = new String[1];
        this.songDisplayNames[0] = string;
        this.currSongDisplay = 0;
        this.closePlayer();
        this.setStatus("");
        this.setFeedback("");
        this.clearKaraoke();
        this.updateTempo(null);
        this.updateTime();
        this.updateSongDisplay();
    }

    public void setTimerInterval(int n) {
        this.timerInterval = n;
    }

    private void error(Throwable throwable) {
        this.error(Utils.friendlyException(throwable));
        if (Utils.DEBUG) {
            throwable.printStackTrace();
        }
    }

    private void error(String string) {
        this.setFeedback(string);
    }

    private void setStatus(String string) {
        this.parent.setStatus(string);
        if (Utils.DEBUG) {
            System.out.println("Status: " + string);
        }
    }

    private void setFeedback(String string) {
        this.parent.setFeedback(string);
        if (Utils.DEBUG) {
            System.out.println("Feedback: " + string);
        }
    }

    private void updateKaraoke() {
        this.parent.updateKaraoke();
    }

    private void updateTime() {
        this.parent.updateTime();
    }

    private void updateRate(RateControl rateControl) {
        this.parent.updateRate();
        if (this.gauge != null && this.gaugeMode == 1) {
            if (rateControl == null) {
                rateControl = this.getRateControl();
            }
            if (rateControl != null) {
                String string = this.getRateStr();
                this.gauge.setValue((rateControl.getRate() - rateControl.getMinRate()) / 1000);
                this.gaugeLabel.setLabel(string);
            }
        }
    }

    private void updateTempo(TempoControl tempoControl) {
        this.parent.updateRate();
        if (this.gauge != null && this.gaugeMode == 2) {
            if (tempoControl == null) {
                tempoControl = this.getTempoControl();
            }
            if (tempoControl != null) {
                String string = this.getTempoStr();
                this.gauge.setValue(tempoControl.getTempo() / 1000 - 1);
                this.gaugeLabel.setLabel(string);
            }
        }
    }

    private void updateVolume(VolumeControl volumeControl) {
        if (volumeControl == null) {
            volumeControl = this.getVolumeControl();
        }
        if (volumeControl != null) {
            int n = volumeControl.getLevel();
            String string = "Volume: " + String.valueOf(n);
            if (volumeControl.isMuted()) {
                string = string + " (muted)";
            }
            if (this.gauge != null && this.gaugeMode == 0) {
                this.gauge.setValue(n);
                this.gaugeLabel.setLabel(string);
            }
            this.setFeedback(string);
        }
    }

    private void updatePitch(PitchControl pitchControl) {
        if (pitchControl == null) {
            pitchControl = this.getPitchControl();
        }
        if (pitchControl != null) {
            String string = "Transpose: " + this.toFloatString(pitchControl.getPitch(), 3) + " semi tones";
            if (this.gauge != null && this.gaugeMode == 3) {
                this.gauge.setValue((pitchControl.getPitch() - pitchControl.getMinPitch()) / 1000);
                this.gaugeLabel.setLabel(string);
            }
            this.setFeedback(string);
        }
    }

    private void updateLoop() {
        if (this.player != null) {
            try {
                int n = 1;
                switch (this.loopmode) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 3;
                        break;
                    }
                    case 2: {
                        n = -1;
                    }
                }
                boolean bl = false;
                if (this.player.getState() == 400) {
                    this.player.stop();
                    bl = true;
                }
                this.player.setLoopCount(n);
                if (bl) {
                    this.player.start();
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
    }

    private void updateSongDisplay() {
        String string = "";
        if (this.currSongDisplay == 0) {
            string = this.durationStr;
        }
        this.parent.setFileTitle(this.songDisplayNames[this.currSongDisplay] + string);
    }

    private void durationUpdated() {
        if (this.player != null) {
            try {
                long l = this.player.getDuration();
                this.durationStr = l >= 0L ? " (" + this.timeDisplay(l) + ")" : "";
            }
            catch (IllegalStateException illegalStateException) {
                this.durationStr = "";
            }
            this.updateSongDisplay();
        }
    }

    private void clearKaraoke() {
        this.karaokeLineCount = 0;
        this.nextKaraokePos = -1;
        this.redisplayKaraokeCounter = 0;
        this.updateKaraoke();
    }

    public Image getLogo() {
        if (logo == null) {
            try {
                logo = Image.createImage((String)"/icons/logo.png");
            }
            catch (Exception exception) {
                logo = null;
            }
            if (logo == null) {
                SimplePlayerGUI.debugOut("can not load logo.png");
            }
        }
        return logo;
    }

    private String toFloatString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
        while (stringBuffer.length() < n2 + 1) {
            stringBuffer.insert(0, '0');
        }
        stringBuffer.insert(stringBuffer.length() - n2, '.');
        return stringBuffer.toString();
    }

    private String formatNumber(long l, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(l));
        if (bl) {
            while (stringBuffer.length() < n) {
                stringBuffer.insert(0, '0');
            }
        } else {
            while (stringBuffer.length() < n) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    private String timeDisplay(long l) {
        long l2 = l / 100000L;
        return this.formatNumber(l2 / 600L, 2, true) + ":" + this.formatNumber(l2 % 600L / 10L, 2, true) + "." + String.valueOf(l2 % 10L);
    }

    public String getMediaTimeStr() {
        try {
            if (this.player != null) {
                return this.timeDisplay(this.player.getMediaTime());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return "--:--:-";
    }

    public String getTempoStr() {
        TempoControl tempoControl;
        if (this.player != null && (tempoControl = this.getTempoControl()) != null) {
            int n = tempoControl.getTempo();
            return this.toFloatString((n + 50) / 100, 1) + "bpm (eff: " + this.toFloatString((int)(((long)tempoControl.getRate() * (long)n / 100000L + 50L) / 100L), 1) + ")";
        }
        return "";
    }

    public String getRateStr() {
        RateControl rateControl;
        if (this.player != null && (rateControl = this.getRateControl()) != null) {
            return "Rate: " + this.toFloatString(rateControl.getRate() / 100, 1) + "%";
        }
        return "";
    }

    private void displayNextKaraokePhrase() {
        if (this.karaokeLyrics != null && this.karaokeLineCount > 0 && this.karaokeLines != null && this.nextKaraokePos >= 0 && this.nextKaraokePos < this.karaokeLyrics.length() && this.nextKaraokePos > this.karaokeLinePos[this.currKaraokeLine]) {
            this.setupKaraokeLines(this.nextKaraokePos, 0);
            this.updateKaraoke();
        }
    }

    private void addKaraokeLine(int n, int n2) {
        if (this.karaokeLines == null || this.karaokeLines.length <= this.karaokeLineCount) {
            String[] stringArray = new String[this.karaokeLineCount + 4];
            if (this.karaokeLines != null) {
                System.arraycopy(this.karaokeLines, 0, stringArray, 0, this.karaokeLineCount);
            }
            this.karaokeLines = stringArray;
            int[] nArray = new int[this.karaokeLineCount + 5];
            if (this.karaokeLinePos != null) {
                System.arraycopy(this.karaokeLinePos, 0, nArray, 0, this.karaokeLineCount + 1);
            }
            this.karaokeLinePos = nArray;
        }
        this.karaokeLines[this.karaokeLineCount] = this.karaokeLyrics.substring(n, n2);
        this.karaokeLinePos[this.karaokeLineCount++] = n;
    }

    private void setupKaraokeLines(int n, int n2) {
        int n3;
        int n4;
        int n5 = n4 = this.karaokeLyrics == null ? 0 : this.karaokeLyrics.length();
        if (n4 == 0) {
            SimplePlayerGUI.debugOut("no karaoke lyrics");
            return;
        }
        this.nextKaraokePos = -1;
        if (n < 0 || n >= n4) {
            this.karaokeLineCount = 0;
            SimplePlayerGUI.debugOut("setupKaraokeLines: pos out of bounds!");
            return;
        }
        while (this.karaokeLyrics.charAt(n) == '\\' || this.karaokeLyrics.charAt(n) == '/') {
            ++n;
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.karaokeLinePos == null || this.karaokeLineCount == 0 || n < this.karaokeLinePos[0] || n >= this.karaokeLinePos[this.karaokeLineCount]) {
            int n6;
            for (n3 = n; this.karaokeLyrics.charAt(n3) != '\\' && n3 > 0; --n3) {
            }
            if (this.karaokeLyrics.charAt(n3) == '\\') {
                ++n3;
            }
            this.karaokeLineCount = 0;
            for (n6 = n3; n6 < n4; ++n6) {
                char c = this.karaokeLyrics.charAt(n6);
                if (c == '/') {
                    this.addKaraokeLine(n3, n6);
                    n3 = n6 + 1;
                    continue;
                }
                if (c == '\\') break;
            }
            this.addKaraokeLine(n3, n6);
            if (n6 < n4) {
                // empty if block
            }
            this.karaokeLinePos[this.karaokeLineCount] = --n6;
        }
        this.currKaraokeLength = 0;
        for (n3 = 0; n3 < this.karaokeLineCount; ++n3) {
            if (n < this.karaokeLinePos[n3] || n >= this.karaokeLinePos[n3 + 1]) continue;
            this.currKaraokeLine = n3;
            this.currKaraokeLinePos = n - this.karaokeLinePos[n3];
            this.currKaraokeLength = n2;
            if (this.currKaraokeLinePos + n2 < this.karaokeLines[n3].length()) break;
            this.nextKaraokePos = this.karaokeLinePos[n3 + 1] + 1;
            this.redisplayKaraokeCounter = 3;
            break;
        }
    }

    public String[] getKaraokeStr(int[] nArray) {
        nArray[0] = this.karaokeLineCount;
        nArray[1] = this.currKaraokeLine;
        nArray[2] = this.currKaraokeLinePos;
        nArray[3] = this.currKaraokeLength;
        return this.karaokeLines;
    }

    private void goBack() {
        Displayable displayable;
        if (this.parent.getCurrentDisplayable() == this.display) {
            this.closePlayer();
        }
        if ((displayable = this.parent.goBack()) == this.display) {
            this.setPlayerCommands();
        }
    }

    private void setPlayerCommands() {
        this.removeCommands();
        this.display.addCommand(this.backCommand);
        if (this.player != null) {
            VolumeControl volumeControl;
            if (this.getMetaDataControl() != null) {
                this.display.addCommand(this.metaCommand);
            }
            if (this.getStopTimeControl() != null) {
                this.display.addCommand(this.stcCommand);
            }
            if ((volumeControl = this.getVolumeControl()) != null) {
                this.display.addCommand(this.volCommand);
                if (volumeControl.isMuted()) {
                    this.display.addCommand(this.unmuteCommand);
                } else {
                    this.display.addCommand(this.muteCommand);
                }
            }
            if (this.getRateControl() != null) {
                this.display.addCommand(this.rateCommand);
            }
            if (this.getTempoControl() != null) {
                this.display.addCommand(this.tempoCommand);
            }
            if (this.getPitchControl() != null) {
                this.display.addCommand(this.pitchCommand);
            }
            if (this.getVideoControl() != null) {
                this.display.addCommand(this.normalScreenCommand);
                this.display.addCommand(this.fullScreenCommand);
            }
            if (this.getRecordControl() != null) {
                if (this.isRecording) {
                    this.display.addCommand(this.stopRecordCommand);
                } else {
                    this.display.addCommand(this.startRecordCommand);
                }
            }
            this.display.addCommand(this.loopCommand);
            if (this.player.getState() >= 400) {
                this.display.addCommand(this.stopCommand);
            } else {
                this.display.addCommand(this.playCommand);
            }
            this.display.addCommand(this.skipFwCommand);
            this.display.addCommand(this.skipBwCommand);
            this.display.addCommand(this.rewindCommand);
            if (this.parent instanceof SimplePlayerCanvas) {
                this.display.addCommand(this.helpCommand);
            }
        }
    }

    private void removeCommands() {
        this.display.removeCommand(this.muteCommand);
        this.display.removeCommand(this.unmuteCommand);
        this.display.removeCommand(this.metaCommand);
        this.display.removeCommand(this.volCommand);
        this.display.removeCommand(this.stcCommand);
        this.display.removeCommand(this.loopCommand);
        this.display.removeCommand(this.backCommand);
        this.display.removeCommand(this.playCommand);
        this.display.removeCommand(this.stopCommand);
        this.display.removeCommand(this.skipFwCommand);
        this.display.removeCommand(this.skipBwCommand);
        this.display.removeCommand(this.rewindCommand);
        this.display.removeCommand(this.rateCommand);
        this.display.removeCommand(this.tempoCommand);
        this.display.removeCommand(this.pitchCommand);
        this.display.removeCommand(this.fullScreenCommand);
        this.display.removeCommand(this.normalScreenCommand);
        this.display.removeCommand(this.startRecordCommand);
        this.display.removeCommand(this.stopRecordCommand);
        this.display.removeCommand(this.helpCommand);
    }

    private void mutePressed() {
        VolumeControl volumeControl = this.getVolumeControl();
        if (volumeControl != null) {
            if (volumeControl.isMuted()) {
                this.display.removeCommand(this.unmuteCommand);
                this.display.addCommand(this.muteCommand);
                volumeControl.setMute(false);
            } else {
                this.display.removeCommand(this.muteCommand);
                this.display.addCommand(this.unmuteCommand);
                volumeControl.setMute(true);
            }
            this.updateVolume(volumeControl);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    private void displayGauge(String string) {
        if (this.gaugeForm == null) {
            this.gaugeForm = new Form(string);
            this.gaugeForm.append((Item)this.gauge);
            this.gaugeForm.append((Item)this.gaugeLabel);
            this.gaugeForm.setItemStateListener((ItemStateListener)this);
            this.gaugeForm.addCommand(this.backCommand);
            this.gaugeForm.setCommandListener((CommandListener)this);
        }
        this.parent.go((Displayable)this.gaugeForm);
    }

    private void volPressed() {
        VolumeControl volumeControl = this.getVolumeControl();
        if (volumeControl != null) {
            if (this.gauge == null || this.gaugeMode != 0) {
                this.gauge = new Gauge("Volume", true, 100, volumeControl.getLevel());
                this.gaugeLabel = new StringItem("Volume", "");
                this.gaugeMode = 0;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Volume");
            this.updateVolume(volumeControl);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    private void ratePressed() {
        RateControl rateControl = this.getRateControl();
        if (rateControl != null) {
            if (this.gauge == null || this.gaugeMode != 1) {
                int n = rateControl.getMinRate() / 1000;
                int n2 = rateControl.getMaxRate() / 1000;
                if (n2 > 300) {
                    n2 = 300;
                }
                int n3 = rateControl.getRate() / 1000;
                this.gauge = new Gauge("Rate", true, n2 - n, n3 - n);
                this.gaugeLabel = new StringItem("Rate", "");
                this.gaugeMode = 1;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Rate");
            this.updateRate(rateControl);
        } else {
            this.setFeedback("No RateControl!");
        }
    }

    private void pitchPressed() {
        PitchControl pitchControl = this.getPitchControl();
        if (pitchControl != null) {
            if (this.gauge == null || this.gaugeMode != 3) {
                this.gauge = new Gauge("Pitch", true, (pitchControl.getMaxPitch() - pitchControl.getMinPitch()) / 1000, (pitchControl.getPitch() - pitchControl.getMinPitch()) / 1000);
                this.gaugeLabel = new StringItem("Pitch", "");
                this.gaugeMode = 3;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Pitch");
            this.updatePitch(pitchControl);
        } else {
            this.setFeedback("No PitchControl!");
        }
    }

    private void tempoPressed() {
        TempoControl tempoControl = this.getTempoControl();
        if (tempoControl != null) {
            if (this.gauge == null || this.gaugeMode != 2) {
                this.gauge = new Gauge("Tempo", true, 399, tempoControl.getTempo() / 1000 - 1);
                this.gaugeLabel = new StringItem("Tempo", "");
                this.gaugeMode = 2;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Tempo");
            this.updateTempo(tempoControl);
        } else {
            this.setFeedback("No TempoControl!");
        }
    }

    private void metaPressed() {
        MetaDataControl metaDataControl = this.getMetaDataControl();
        if (metaDataControl != null) {
            List list = new List("Meta Data", 3);
            String[] stringArray = metaDataControl.getKeys();
            Utils.sort(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    if (stringArray[i].equals(LYRICS_KEY)) continue;
                    list.append(stringArray[i] + " = " + metaDataControl.getKeyValue(stringArray[i]), null);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    list.append(stringArray[i] + ": " + Utils.friendlyException(illegalArgumentException), null);
                }
            }
            if (stringArray.length == 0) {
                list.append("No meta data", null);
            }
            list.addCommand(this.backCommand);
            list.setCommandListener((CommandListener)this);
            this.parent.go((Displayable)list);
        } else {
            this.setFeedback("No MetaDataControl!");
        }
    }

    private void loopPressed() {
        this.loopmode = (this.loopmode + 1) % 3;
        String string = "";
        switch (this.loopmode) {
            case 0: {
                string = "one time";
                break;
            }
            case 1: {
                string = "3 times";
                break;
            }
            case 2: {
                string = "infinite";
            }
        }
        this.setFeedback("Set loop mode to " + string);
        this.updateLoop();
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public boolean toggleFullScreen() {
        VideoControl videoControl = this.getVideoControl();
        Utils.debugOut("toggleFullScreen");
        if (videoControl != null) {
            try {
                videoControl.setDisplayFullScreen(!this.fullScreen);
                this.fullScreen = !this.fullScreen;
                this.parent.fullScreen(this.fullScreen);
                Utils.debugOut("Successfully set to " + (this.fullScreen ? "full screen" : "normal screen"));
            }
            catch (Exception exception) {
                this.fullScreen = false;
                this.display.removeCommand(this.fullScreenCommand);
                this.display.removeCommand(this.normalScreenCommand);
                this.error(exception);
            }
        } else {
            this.setFeedback("No VideoControl!");
        }
        return this.fullScreen;
    }

    private void fullScreenPressed() {
        this.fullScreen = false;
        this.toggleFullScreen();
    }

    private void normalScreenPressed() {
        this.fullScreen = true;
        this.toggleFullScreen();
    }

    public void stepFrame(int n) {
        FramePositioningControl framePositioningControl = this.getFramePositioningControl();
        if (framePositioningControl != null) {
            framePositioningControl.skip(n);
        } else {
            this.setFeedback("No FramePositioningControl!");
        }
    }

    public boolean hasRateControl() {
        return this.getRateControl() != null;
    }

    public boolean hasTempoControl() {
        return this.getTempoControl() != null;
    }

    public boolean hasGUIControls() {
        try {
            if (this.player != null) {
                return this.player.getControl("GUIControl") != null || this.player.getControl("VideoControl") != null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }

    public Control[] getControls() {
        try {
            if (this.player != null) {
                return this.player.getControls();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private VolumeControl getVolumeControl() {
        try {
            if (this.player != null) {
                return (VolumeControl)this.player.getControl("VolumeControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private TempoControl getTempoControl() {
        try {
            if (this.player != null) {
                return (TempoControl)this.player.getControl("TempoControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private RateControl getRateControl() {
        try {
            if (this.player != null) {
                return (RateControl)this.player.getControl("RateControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private PitchControl getPitchControl() {
        try {
            if (this.player != null) {
                return (PitchControl)this.player.getControl("PitchControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private MetaDataControl getMetaDataControl() {
        try {
            if (this.player != null) {
                return (MetaDataControl)this.player.getControl("MetaDataControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private FramePositioningControl getFramePositioningControl() {
        try {
            if (this.player != null) {
                return (FramePositioningControl)this.player.getControl("FramePositioningControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private StopTimeControl getStopTimeControl() {
        try {
            if (this.player != null) {
                return (StopTimeControl)this.player.getControl("StopTimeControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public VideoControl getVideoControl() {
        try {
            if (this.player != null) {
                return (VideoControl)this.player.getControl("VideoControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public RecordControl getRecordControl() {
        try {
            if (this.player != null) {
                return (RecordControl)this.player.getControl("RecordControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private void assertPlayer() throws Throwable {
        String string = "";
        try {
            SimplePlayerGUI.debugOut("assertPlayer");
            this.fullScreen = false;
            this.display.removeCommand(this.backCommand);
            this.display.addCommand(this.backCommand);
            if (this.player == null) {
                if (this.songInputStream == null) {
                    string = "Opening " + this.songLocator;
                    this.setStatus(string + "...");
                    this.player = Manager.createPlayer((String)this.songLocator);
                } else {
                    string = "Opening " + this.songName;
                    this.setStatus(string + "...");
                    this.player = Manager.createPlayer((InputStream)this.songInputStream, (String)this.songContentType);
                }
            }
            this.player.addPlayerListener((PlayerListener)this);
            string = "Realizing";
            this.setStatus(string + "...");
            this.player.realize();
            string = "Prefetching";
            this.setStatus(string + "...");
            this.player.prefetch();
            string = "Prefetched";
            this.setStatus(string);
            this.setPlayerCommands();
            this.parent.setupDisplay();
            MetaDataControl metaDataControl = this.getMetaDataControl();
            if (metaDataControl != null) {
                int n = 0;
                String string2 = "";
                try {
                    string2 = metaDataControl.getKeyValue("title");
                    if (string2 != null && string2 != "") {
                        String string3;
                        ++n;
                        while ((string3 = metaDataControl.getKeyValue("title" + (n + 1))) != null && string3 != "") {
                            ++n;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (n > 0) {
                    this.songDisplayNames = new String[n];
                    this.songDisplayNames[0] = string2;
                    try {
                        for (int i = 1; i < n; ++i) {
                            this.songDisplayNames[i] = metaDataControl.getKeyValue("title" + (i + 1));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    this.currSongDisplay = 0;
                }
                try {
                    String string4 = metaDataControl.getKeyValue(LYRICS_KEY);
                    if (string4 != null && string4 != "") {
                        this.karaokeMode = true;
                        this.karaokeLyrics = string4;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.durationUpdated();
        }
        catch (Throwable throwable) {
            this.player = null;
            this.setStatus("");
            throw new MediaException(Utils.friendlyException(throwable) + " at " + string);
        }
    }

    public void startPlayer() {
        try {
            SimplePlayerGUI.debugOut("startPlayer");
            if (this.player == null || this.player.getState() < 300) {
                this.assertPlayer();
            }
            if (this.player == null || this.player.getState() >= 400) {
                return;
            }
            this.updateLoop();
            try {
                long l = this.player.getDuration();
                if (l != -1L && this.player.getMediaTime() >= l) {
                    this.player.setMediaTime(0L);
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            if (this.player.getMediaTime() == 0L) {
                this.setupKaraokeLines(0, 0);
                this.updateKaraoke();
            } else {
                this.clearKaraoke();
            }
            this.setStatus("Starting...");
            this.player.start();
            this.setStatus("Playing");
            this.setFeedback("");
            this.updateTempo(null);
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    public void closePlayer() {
        if (this.player != null) {
            this.setStatus("Stopping...");
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStatus("Closing...");
            this.player.close();
            this.setStatus("Closed");
            this.player = null;
            this.initialize();
        }
    }

    public void pausePlayer() {
        if (this.player != null) {
            this.setStatus("Stopping...");
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clearKaraoke();
            this.setStatus("Stopped");
            this.setFeedback("");
        }
    }

    public void togglePlayer() {
        if (this.player != null) {
            if (this.player.getState() == 400) {
                this.pausePlayer();
            } else {
                this.startPlayer();
            }
        }
    }

    public void skip(boolean bl) {
        if (this.player != null) {
            try {
                long l = this.player.getMediaTime();
                long l2 = 10000000L;
                long l3 = this.player.getDuration();
                if (l3 >= 0L && (l2 = l3 / 20L) < 2000000L) {
                    l2 = 2000000L;
                }
                if (bl) {
                    this.setMediaTime(l - l2);
                } else {
                    this.setMediaTime(l + l2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.error(illegalStateException);
            }
        }
    }

    public void stopAfterTime() {
        int n = 5000000;
        StopTimeControl stopTimeControl = this.getStopTimeControl();
        if (stopTimeControl != null) {
            try {
                stopTimeControl.setStopTime(Long.MAX_VALUE);
                stopTimeControl.setStopTime(this.player.getMediaTime() + (long)n);
                this.setFeedback("Stop in " + n / 1000000 + " seconds.");
            }
            catch (IllegalStateException illegalStateException) {
                this.error(illegalStateException);
            }
        } else {
            this.setFeedback("No StopTimeControl!");
        }
    }

    public void changeRate(boolean bl) {
        RateControl rateControl;
        int n = 10000;
        if (bl) {
            n = -n;
        }
        if ((rateControl = this.getRateControl()) != null) {
            int n2 = rateControl.getRate();
            int n3 = n2 + n;
            int n4 = rateControl.getMaxRate();
            if (n4 > 300000) {
                n4 = 300000;
            }
            if (n3 >= rateControl.getMinRate() && n3 <= n4) {
                int n5 = rateControl.setRate(n3);
                this.setFeedback("New rate: " + this.toFloatString(n5, 3) + "%");
                this.updateRate(rateControl);
                this.updateTempo(null);
            }
        } else {
            this.setFeedback("No RateControl!");
        }
    }

    public void setMediaTime(long l) {
        if (this.player == null) {
            return;
        }
        try {
            this.setFeedback("Set MediaTime to " + this.timeDisplay(l));
            this.player.setMediaTime(l);
            this.updateTime();
            this.clearKaraoke();
            this.updateTempo(null);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void changeVolume(boolean bl) {
        VolumeControl volumeControl;
        int n = 10;
        if (bl) {
            n = -n;
        }
        if ((volumeControl = this.getVolumeControl()) != null) {
            int n2 = volumeControl.getLevel();
            volumeControl.setLevel(n2 += n);
            this.updateVolume(volumeControl);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    public void toggleMute() {
        VolumeControl volumeControl = this.getVolumeControl();
        if (volumeControl != null) {
            volumeControl.setMute(!volumeControl.isMuted());
            this.updateVolume(volumeControl);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    public void transpose(boolean bl) {
        PitchControl pitchControl;
        int n = 1000;
        if (bl) {
            n = -n;
        }
        if ((pitchControl = this.getPitchControl()) != null) {
            pitchControl.setPitch(pitchControl.getPitch() + n);
            this.updatePitch(pitchControl);
        } else if (this.getFramePositioningControl() != null) {
            this.skipFrame(bl);
        } else {
            this.setFeedback("No PitchControl!");
        }
    }

    public void skipFrame(boolean bl) {
        FramePositioningControl framePositioningControl;
        int n = 1;
        if (bl) {
            n = -n;
        }
        if ((framePositioningControl = this.getFramePositioningControl()) != null) {
            int n2 = framePositioningControl.skip(n);
            this.setFeedback("Skipped: " + n2 + " frames to " + framePositioningControl.mapTimeToFrame(this.player.getMediaTime()));
        } else {
            this.setFeedback("No FramePositioningControl!");
        }
    }

    private void queryRecording() {
        try {
            Utils.query("Enter a record locator", this.recordLocator, 200, 4, new RecordTask(), this.parent);
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this.parent);
        }
    }

    private void startRecording(String string) {
        block4: {
            try {
                if (string == null || string == "") {
                    Utils.error("No locator set!", (Utils.BreadCrumbTrail)this.parent);
                    break block4;
                }
                this.recordLocator = string;
                RecordControl recordControl = this.getRecordControl();
                if (recordControl != null) {
                    recordControl.stopRecord();
                    recordControl.reset();
                    recordControl.setRecordLocation(string);
                    recordControl.startRecord();
                    break block4;
                }
                throw new MediaException("Could not get RecordControl!");
            }
            catch (Exception exception) {
                Utils.error(exception, (Utils.BreadCrumbTrail)this.parent);
            }
        }
    }

    private void stopRecording() {
        try {
            final RecordControl recordControl = this.getRecordControl();
            if (recordControl == null) {
                throw new MediaException("Could not get RecordControl!");
            }
            recordControl.stopRecord();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        recordControl.commit();
                        Utils.FYI("Recorded " + SimplePlayerGUI.this.recordLocator + " successfully.", SimplePlayerGUI.this.parent);
                    }
                    catch (Exception exception) {
                        Utils.error(exception, (Utils.BreadCrumbTrail)SimplePlayerGUI.this.parent);
                    }
                }
            }).start();
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this.parent);
        }
    }

    private void showHelp() {
        if (this.parent instanceof SimplePlayerCanvas) {
            ((SimplePlayerCanvas)this.parent).showHelp();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.goBack();
        } else if (command == this.muteCommand || command == this.unmuteCommand) {
            this.mutePressed();
        } else if (command == this.volCommand) {
            this.volPressed();
        } else if (command == this.metaCommand) {
            this.metaPressed();
        } else if (command == this.loopCommand) {
            this.loopPressed();
        } else if (command == this.stcCommand) {
            this.stopAfterTime();
        } else if (command == this.playCommand || command == this.stopCommand) {
            this.togglePlayer();
        } else if (command == this.skipFwCommand) {
            this.skip(false);
        } else if (command == this.skipBwCommand) {
            this.skip(true);
        } else if (command == this.rewindCommand) {
            this.setMediaTime(0L);
        } else if (command == this.rateCommand) {
            this.ratePressed();
        } else if (command == this.tempoCommand) {
            this.tempoPressed();
        } else if (command == this.pitchCommand) {
            this.pitchPressed();
        } else if (command == this.fullScreenCommand) {
            this.fullScreenPressed();
        } else if (command == this.normalScreenCommand) {
            this.normalScreenPressed();
        } else if (command == this.startRecordCommand) {
            this.queryRecording();
        } else if (command == this.stopRecordCommand) {
            this.stopRecording();
        } else if (command == this.helpCommand) {
            this.showHelp();
        } else if (displayable != this.display) {
            this.goBack();
        }
    }

    private synchronized void startDisplayTimer() {
        if (this.timeDisplayTask == null) {
            this.timeDisplayTask = new SPTimerTask();
            this.guiTimer.scheduleAtFixedRate(this.timeDisplayTask, 0L, (long)this.timerInterval);
        }
    }

    private synchronized void stopDisplayTimer() {
        if (this.timeDisplayTask != null) {
            this.timeDisplayTask.cancel();
            this.timeDisplayTask = null;
            this.updateTime();
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        try {
            Object object2;
            if (string == "endOfMedia" && player.getState() == 400) {
                this.setFeedback("Looping");
                return;
            }
            if (string == "closed" || string == "error" || string == "endOfMedia" || string == "stoppedAtTime" || string == "stopped") {
                this.stopDisplayTimer();
            }
            if (string == "endOfMedia" || string == "stoppedAtTime" || string == "stopped" || string == "error") {
                this.display.removeCommand(this.stopCommand);
                this.display.addCommand(this.playCommand);
                this.changeSongDisplayCounter = 0;
                this.currSongDisplay = 0;
                this.updateSongDisplay();
            }
            if (string.equals("com.sun.midi.lyrics") && (object2 = (byte[])object) != null && object instanceof byte[] && ((byte[])object2).length > 0) {
                if (Utils.DEBUG) {
                    System.out.println("META event 0x" + Integer.toHexString(object2[0] & 0xFF));
                }
                switch (object2[0]) {
                    case 1: 
                    case 5: {
                        if (this.karaokeMode) break;
                    }
                    case 6: 
                    case 7: {
                        String string2 = new String((byte[])object2, 1, ((byte[])object2).length - 1);
                        this.setFeedback(string2);
                        if (!Utils.DEBUG) break;
                        System.out.println("META event 0x" + Integer.toHexString(object2[0] & 0xFF) + ": " + string2);
                        break;
                    }
                    case 81: {
                        this.updateTempo(null);
                        break;
                    }
                    case 96: {
                        int n = object2[1] << 16 | object2[2] << 8 | object2[3] & 0xFF;
                        int n2 = object2[4] << 16 | object2[5] << 8 | object2[6] & 0xFF;
                        this.setupKaraokeLines(n, n2);
                        this.updateKaraoke();
                    }
                }
            }
            if (string == "started") {
                if (this.songDisplayNames.length > 1) {
                    this.changeSongDisplayCounter = 80;
                }
                this.startDisplayTimer();
                this.display.addCommand(this.stopCommand);
                this.display.removeCommand(this.playCommand);
            } else if (string == "deviceUnavailable") {
                this.setFeedback("Audio device not available!");
            } else if (string == "bufferingStarted") {
                this.setFeedback("Buffering started");
            } else if (string == "bufferingStopped") {
                this.setFeedback("Buffering stopped");
            } else if (string == "closed") {
                this.setFeedback("Closed");
            } else if (string == "durationUpdated") {
                this.setFeedback("Duration updated");
                this.durationUpdated();
            } else if (string == "endOfMedia") {
                this.setStatus("End of media.");
                this.setFeedback("");
            } else if (string == "error") {
                this.setFeedback("Error: " + (String)object);
            } else if (string == "recordStarted") {
                this.isRecording = true;
                this.display.addCommand(this.stopRecordCommand);
                this.display.removeCommand(this.startRecordCommand);
                this.setFeedback("Recording Started");
            } else if (string == "recordStopped") {
                this.isRecording = false;
                this.display.addCommand(this.startRecordCommand);
                this.display.removeCommand(this.stopRecordCommand);
                this.setFeedback("Recording Stopped");
            } else if (string == "sizeChanged") {
                object2 = (int[])object;
                this.setFeedback("Resize to " + object2[0] + "x" + object2[1]);
            } else if (string == "stoppedAtTime") {
                this.setStatus("Stopped at time.");
                this.setFeedback("");
            } else if (string == "volumeChanged") {
                object2 = (VolumeControl)object;
                this.setFeedback("New volume: " + object2.getLevel());
                this.updateVolume((VolumeControl)object2);
            }
        }
        catch (Throwable throwable) {
            if (Utils.DEBUG) {
                System.out.println("Uncaught Exception in SimplePlayerGUI.playerUpdate()");
            }
            this.error(throwable);
        }
    }

    public void itemStateChanged(Item item) {
        if (item != null && item == this.gauge) {
            switch (this.gaugeMode) {
                case 0: {
                    VolumeControl volumeControl = this.getVolumeControl();
                    if (volumeControl == null) break;
                    volumeControl.setLevel(this.gauge.getValue());
                    this.updateVolume(volumeControl);
                    break;
                }
                case 1: {
                    RateControl rateControl = this.getRateControl();
                    if (rateControl == null) break;
                    rateControl.setRate(this.gauge.getValue() * 1000 + rateControl.getMinRate());
                    this.updateRate(rateControl);
                    break;
                }
                case 2: {
                    TempoControl tempoControl = this.getTempoControl();
                    if (tempoControl == null) break;
                    tempoControl.setTempo((this.gauge.getValue() + 1) * 1000);
                    this.updateTempo(tempoControl);
                    break;
                }
                case 3: {
                    PitchControl pitchControl = this.getPitchControl();
                    if (pitchControl == null) break;
                    pitchControl.setPitch(this.gauge.getValue() * 1000 + pitchControl.getMinPitch());
                    this.updatePitch(pitchControl);
                }
            }
        }
    }

    public synchronized void pauseApp() {
        if (this.player != null && this.player.getState() >= 400) {
            try {
                this.player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.stopDisplayTimer();
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void resumeApp() {
        if (this.player != null && this.restartOnResume) {
            try {
                this.player.start();
            }
            catch (MediaException mediaException) {
                this.error(mediaException);
            }
        }
        this.restartOnResume = false;
    }

    static interface Parent
    extends Utils.BreadCrumbTrail {
        public Utils.BreadCrumbTrail getParent();

        public String getTitle();

        public void setupDisplay();

        public void setStatus(String var1);

        public void setFeedback(String var1);

        public void setFileTitle(String var1);

        public void updateKaraoke();

        public void updateTime();

        public void updateRate();

        public void updateDisplay();

        public void fullScreen(boolean var1);
    }

    private class SPTimerTask
    extends TimerTask {
        private SPTimerTask() {
        }

        public void run() {
            SimplePlayerGUI.this.updateTime();
            if (SimplePlayerGUI.this.redisplayKaraokeCounter > 0) {
                SimplePlayerGUI.this.redisplayKaraokeCounter--;
                if (SimplePlayerGUI.this.redisplayKaraokeCounter == 0) {
                    SimplePlayerGUI.this.displayNextKaraokePhrase();
                }
            }
            if (SimplePlayerGUI.this.changeSongDisplayCounter > 0 && SimplePlayerGUI.this.songDisplayNames.length > 0) {
                SimplePlayerGUI.this.changeSongDisplayCounter--;
                if (SimplePlayerGUI.this.changeSongDisplayCounter == 0) {
                    SimplePlayerGUI.this.currSongDisplay = (SimplePlayerGUI.this.currSongDisplay + 1) % SimplePlayerGUI.this.songDisplayNames.length;
                    SimplePlayerGUI.this.updateSongDisplay();
                    SimplePlayerGUI.this.changeSongDisplayCounter = 40;
                    if (SimplePlayerGUI.this.currSongDisplay == 0) {
                        SimplePlayerGUI.this.changeSongDisplayCounter *= 2;
                    }
                }
            }
        }
    }

    private class RecordTask
    implements Utils.QueryListener {
        private RecordTask() {
        }

        public void start(String string) {
            SimplePlayerGUI.this.startRecording(string);
        }

        public void queryOK(String string) {
            this.start(string);
        }

        public void queryCancelled() {
        }
    }
}

