/*
 * Decompiled with CFR 0.152.
 */
package example.mmademo;

import example.mmademo.SimplePlayerGUI;
import example.mmademo.Utils;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.GUIControl;
import javax.microedition.media.control.VideoControl;

public class SimplePlayerForm
extends Form
implements SimplePlayerGUI.Parent,
Utils.ContentHandler,
Utils.Interruptable,
Runnable {
    private SimplePlayerGUI gui;
    private Utils.BreadCrumbTrail parent;
    private static Image spacerImage;
    private ImageItem iiLogo;
    private StringItem siFileTitle;
    private StringItem siTime;
    private StringItem siRate;
    private StringItem siKaraoke;
    private StringItem siFeedback;
    private StringItem siStatus;
    private boolean karaokeShowing;
    private static int maxKaraokeLines;

    private static void debugOut(String string) {
        Utils.debugOut("SimplePlayerForm: " + string);
    }

    public SimplePlayerForm(String string, Utils.BreadCrumbTrail breadCrumbTrail) {
        this(string, null, breadCrumbTrail);
    }

    public SimplePlayerForm(String string, SimplePlayerGUI simplePlayerGUI, Utils.BreadCrumbTrail breadCrumbTrail) {
        super(string);
        this.parent = breadCrumbTrail;
        this.gui = simplePlayerGUI;
        this.siFileTitle = new StringItem("", "");
        this.siTime = new StringItem("", "");
        this.siRate = new StringItem("", "");
        this.siKaraoke = new StringItem("", "");
        this.siFeedback = new StringItem("", "");
        this.siStatus = new StringItem("", "");
        SimplePlayerForm.debugOut("constructor finished");
    }

    private void appendNewLine(Item item) {
        this.insertNewLine(this.size(), item);
    }

    private void insertNewLine(int n, Item item) {
        this.insert(n, (Item)((StringItem)item));
        Spacer spacer = new Spacer(3, 10);
        spacer.setLayout(256);
        if (n < 8) {
            this.insert(n++, (Item)spacer);
        }
    }

    private void setUpItems() {
        Control[] controlArray;
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
        this.karaokeShowing = false;
        this.getGUI();
        if (!this.gui.hasGUIControls()) {
            this.makeImageItem();
        }
        this.appendNewLine((Item)this.siFileTitle);
        this.appendNewLine((Item)this.siTime);
        if (this.gui.hasRateControl() || this.gui.hasTempoControl()) {
            this.appendNewLine((Item)this.siRate);
        }
        if (this.gui.hasGUIControls() && (controlArray = this.gui.getControls()) != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                Object object;
                Control control = controlArray[i];
                if (!(control instanceof GUIControl) || !((object = ((GUIControl)control).initDisplayMode(0, null)) instanceof Item)) continue;
                this.append((Item)object);
                if (!(control instanceof VideoControl)) continue;
                try {
                    ((VideoControl)control).setDisplayFullScreen(false);
                    continue;
                }
                catch (MediaException mediaException) {
                    Utils.debugOut(mediaException);
                }
            }
        }
        this.appendNewLine((Item)this.siFeedback);
        this.appendNewLine((Item)this.siStatus);
    }

    private void makeImageItem() {
        if (this.gui != null && !this.gui.isFullScreen()) {
            Image image;
            if (this.iiLogo == null && (image = this.gui.getLogo()) != null) {
                this.iiLogo = new ImageItem("", image, 771, "MMAPI logo");
            }
            if (this.iiLogo != null) {
                this.insert(0, (Item)this.iiLogo);
            }
        }
    }

    public Displayable go(Displayable displayable) {
        return this.parent.go(displayable);
    }

    public Displayable goBack() {
        return this.parent.goBack();
    }

    public Displayable replaceCurrent(Displayable displayable) {
        return this.parent.replaceCurrent(displayable);
    }

    public Displayable getCurrentDisplayable() {
        return this.parent.getCurrentDisplayable();
    }

    public Utils.BreadCrumbTrail getParent() {
        return this.parent;
    }

    public void setupDisplay() {
        this.setUpItems();
    }

    public void setStatus(String string) {
        this.siStatus.setText(string);
    }

    public void setFeedback(String string) {
        this.siFeedback.setText(string);
    }

    public void setFileTitle(String string) {
        this.siFileTitle.setText(string);
    }

    public void updateKaraoke() {
        int[] nArray = new int[4];
        String[] stringArray = this.gui.getKaraokeStr(nArray);
        int n = nArray[1];
        int n2 = nArray[0];
        int n3 = nArray[3];
        int n4 = nArray[2];
        int n5 = 0;
        if (n2 > maxKaraokeLines) {
            n5 = n - 1;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 + maxKaraokeLines > n2) {
                n5 = n2 - maxKaraokeLines;
            } else if (n2 - n5 > maxKaraokeLines) {
                n2 = n5 + maxKaraokeLines;
            }
        }
        String string = "";
        while (n5 < n2) {
            string = string + stringArray[n5] + "\n";
            ++n5;
        }
        this.siKaraoke.setText(string);
        if (!this.karaokeShowing && !this.gui.isFullScreen()) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != this.siFeedback) continue;
                if (i > 0 && this.get(i - 1) instanceof ImageItem) {
                    --i;
                }
                this.insertNewLine(i, (Item)this.siKaraoke);
                break;
            }
            this.karaokeShowing = true;
        }
    }

    public void updateTime() {
        if (this.gui != null) {
            this.siTime.setText(this.gui.getMediaTimeStr());
        }
    }

    public void updateRate() {
        if (this.getGUI().hasTempoControl()) {
            this.siRate.setText(this.gui.getTempoStr());
        } else {
            this.siRate.setText(this.gui.getRateStr());
        }
    }

    public void updateDisplay() {
    }

    public void fullScreen(boolean bl) {
    }

    public synchronized void close() {
        if (this.gui != null) {
            this.gui.closePlayer();
            this.gui = null;
        }
    }

    public boolean canHandle(String string) {
        return true;
    }

    public void handle(String string, String string2) {
        Utils.debugOut("SimplePlayerForm: handle " + string2);
        this.getGUI().setParent(this);
        this.gui.setSong(string, string2);
        this.doHandle();
    }

    public void handle(String string, InputStream inputStream, String string2) {
        this.getGUI().setParent(this);
        this.gui.setSong(string, inputStream, string2);
        this.doHandle();
    }

    private synchronized SimplePlayerGUI getGUI() {
        if (this.gui == null) {
            SimplePlayerForm.debugOut("create GUI");
            this.gui = new SimplePlayerGUI();
            this.gui.initialize(this.getTitle(), this);
            this.gui.setTimerInterval(500);
            this.makeImageItem();
        }
        return this.gui;
    }

    private void doHandle() {
        SimplePlayerForm.debugOut("doHandle");
        this.setUpItems();
        new Thread(this).start();
    }

    public void run() {
        this.gui.startPlayer();
    }

    public synchronized void pauseApp() {
        if (this.gui != null) {
            this.gui.pauseApp();
        }
    }

    public synchronized void resumeApp() {
        if (this.gui != null) {
            this.gui.resumeApp();
        }
    }

    public String toString() {
        return "SimplePlayerForm";
    }

    static {
        maxKaraokeLines = 2;
    }
}

