/*
 * Decompiled with CFR 0.152.
 */
package example.mmademo;

import example.mmademo.BaseListMidlet;
import example.mmademo.RingToneConverter;
import example.mmademo.SimpleHttpBrowser;
import example.mmademo.SimplePlayerCanvas;
import example.mmademo.SimpleRmsBrowser;
import example.mmademo.Utils;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class SimplePlayer
extends BaseListMidlet
implements Utils.BreadCrumbTrail,
Utils.QueryListener {
    private static final String manualEnterURL = "manual";
    private static final String manualEnterTitle = "[enter URL]";
    private String lastManualURL = "";
    private Vector titles;
    private Vector urls;
    private static final String httpSupportedList = SimplePlayer.getSupportedList("http");
    private static final String allSupportedList = SimplePlayer.getSupportedList(null);
    private SimplePlayerCanvas simplePlayerCanvas = new SimplePlayerCanvas("MMAPI Player", this);
    private Utils.ContentHandler[] handlers = new Utils.ContentHandler[]{new SimpleHttpBrowser("MMAPI HTTP Browser", this), new SimpleRmsBrowser("MMAPI RMS Browser", this), this.simplePlayerCanvas};

    private static String getSupportedList(String string) {
        String[] stringArray = Manager.getSupportedContentTypes((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(",");
        }
        if (stringArray.length > 0) {
            return stringBuffer.toString();
        }
        return "";
    }

    public SimplePlayer() {
        super("MMAPI Player");
    }

    protected static final boolean isSupported(String string) {
        if (!string.startsWith("capture:")) {
            String string2;
            try {
                string2 = Utils.guessContentType(string);
            }
            catch (Exception exception) {
                string2 = "";
            }
            if (string2.equals("")) {
                return false;
            }
            if (string.startsWith("resource:") ? allSupportedList.indexOf(string2 + ",") == -1 : string.startsWith("http:") && httpSupportedList.indexOf(string2 + ",") == -1) {
                return false;
            }
        }
        return true;
    }

    protected void fillList(List list) {
        String string;
        String string2;
        this.titles = new Vector();
        this.urls = new Vector();
        for (int i = 1; i < 100 && (string2 = this.getAppProperty(string = "PlayerURL-" + i)) != null && string2.length() != 0; ++i) {
            if (!SimplePlayer.isSupported(string2)) continue;
            String string3 = "PlayerTitle-" + i;
            String string4 = this.getAppProperty(string3);
            if (string4 == null || string4.length() == 0) {
                string4 = string2;
            }
            this.titles.addElement(string4);
            this.urls.addElement(string2);
            list.append(string4, null);
        }
        this.titles.addElement(manualEnterTitle);
        this.urls.addElement(manualEnterURL);
        list.append(manualEnterTitle, null);
        list.addCommand(this.exitCommand);
        list.addCommand(this.selectCommand);
    }

    public void handle(String string, String string2) {
        try {
            InputStream inputStream = null;
            String string3 = "";
            if (string2.equals(manualEnterURL)) {
                this.enterURL();
                return;
            }
            if (string2.startsWith("resource:")) {
                inputStream = this.getClass().getResourceAsStream(string2.substring(9));
            } else if (SimpleRmsBrowser.isRmsFile(string2)) {
                inputStream = SimpleRmsBrowser.getRecordStoreStream(string2);
            }
            if (Utils.guessContentType(string2).equals("audio/x-txt")) {
                RingToneConverter ringToneConverter = inputStream != null ? new RingToneConverter(inputStream, string) : new RingToneConverter(string2, string);
                Player player = Manager.createPlayer((String)"device://tone");
                player.realize();
                ToneControl toneControl = (ToneControl)player.getControl("ToneControl");
                toneControl.setSequence(ringToneConverter.getSequence());
                this.go((Displayable)this.simplePlayerCanvas);
                this.simplePlayerCanvas.handle(ringToneConverter.getName(), player);
                return;
            }
            if (inputStream != null) {
                if (string3 == "") {
                    string3 = Utils.guessContentType(string2);
                }
                this.go((Displayable)this.simplePlayerCanvas);
                this.simplePlayerCanvas.handle(string, inputStream, string3);
                return;
            }
            for (int i = 0; i < this.handlers.length; ++i) {
                if (!this.handlers[i].canHandle(string2)) continue;
                this.go((Displayable)this.handlers[i]);
                this.handlers[i].handle(string, string2);
                return;
            }
            Utils.error("No handler available!", (Utils.BreadCrumbTrail)this);
        }
        catch (Exception exception) {
            Utils.error(exception, (Utils.BreadCrumbTrail)this);
        }
    }

    protected void selectCommand(int n) {
        if (n >= 0 && n < this.titles.size()) {
            this.handle((String)this.titles.elementAt(n), (String)this.urls.elementAt(n));
        }
    }

    private void enterURL() {
        Utils.query("Enter a URL", this.lastManualURL, 300, 4, this, this);
    }

    public void queryOK(String string) {
        this.handle(string, string);
        this.lastManualURL = string;
    }

    public void queryCancelled() {
    }

    public void destroyApp(boolean bl) {
        Utils.ContentHandler contentHandler = this.getCurrentHandler();
        if (contentHandler != null) {
            contentHandler.close();
        }
        super.destroyApp(bl);
    }

    private Utils.ContentHandler getCurrentHandler() {
        Displayable displayable = this.getDisplay().getCurrent();
        if (displayable instanceof Utils.ContentHandler) {
            return (Utils.ContentHandler)displayable;
        }
        return null;
    }

    public String toString() {
        return "SimplePlayer";
    }
}

