/*
 * Decompiled with CFR 0.152.
 */
package example.sms;

import example.sms.SMSSender;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class SMSReceive
extends MIDlet
implements CommandListener,
Runnable,
MessageListener {
    Command exitCommand = new Command("Exit", 7, 2);
    Command replyCommand = new Command("Reply", 4, 1);
    Alert content;
    Display display;
    Thread thread;
    String[] connections;
    boolean done;
    String smsPort = this.getAppProperty("SMS-Port");
    MessageConnection smsconn;
    Message msg;
    String senderAddress;
    Alert sendingMessageAlert;
    SMSSender sender;
    Displayable resumeScreen;

    public SMSReceive() {
        this.display = Display.getDisplay((MIDlet)this);
        this.content = new Alert("SMS Receive");
        this.content.setTimeout(-2);
        this.content.addCommand(this.exitCommand);
        this.content.setCommandListener((CommandListener)this);
        this.content.setString("Receiving...");
        this.sendingMessageAlert = new Alert("SMS", null, null, AlertType.INFO);
        this.sendingMessageAlert.setTimeout(5000);
        this.sendingMessageAlert.setCommandListener((CommandListener)this);
        this.sender = new SMSSender(this.smsPort, this.display, (Displayable)this.content, (Displayable)this.sendingMessageAlert);
        this.resumeScreen = this.content;
    }

    public void startApp() {
        String string = "sms://:" + this.smsPort;
        if (this.smsconn == null) {
            try {
                this.smsconn = (MessageConnection)Connector.open((String)string);
                this.smsconn.setMessageListener((MessageListener)this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.connections = PushRegistry.listConnections((boolean)true);
        if (this.connections == null || this.connections.length == 0) {
            this.content.setString("Waiting for SMS on port " + this.smsPort + "...");
        }
        this.done = false;
        this.thread = new Thread(this);
        this.thread.start();
        this.display.setCurrent(this.resumeScreen);
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        if (this.thread == null) {
            this.done = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            this.msg = this.smsconn.receive();
            if (this.msg != null) {
                this.senderAddress = this.msg.getAddress();
                this.content.setTitle("From: " + this.senderAddress);
                if (this.msg instanceof TextMessage) {
                    this.content.setString(((TextMessage)this.msg).getPayloadText());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = ((BinaryMessage)this.msg).getPayloadData();
                    for (int i = 0; i < byArray.length; ++i) {
                        int n = byArray[i] & 0xFF;
                        if (n < 16) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(Integer.toHexString(n));
                        stringBuffer.append(' ');
                    }
                    this.content.setString(stringBuffer.toString());
                }
                this.content.addCommand(this.replyCommand);
                this.display.setCurrent((Displayable)this.content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pauseApp() {
        this.done = true;
        this.thread = null;
        this.resumeScreen = this.display.getCurrent();
    }

    public void destroyApp(boolean bl) {
        this.done = true;
        this.thread = null;
        if (this.smsconn != null) {
            try {
                this.smsconn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.exitCommand || command == Alert.DISMISS_COMMAND) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (command == this.replyCommand) {
                this.reply();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reply() {
        String string = this.senderAddress.substring(6);
        String string2 = "Sending message to " + string + "...";
        this.sendingMessageAlert.setString(string2);
        this.sender.promptAndSend(this.senderAddress);
    }
}

