/*
 * Decompiled with CFR 0.152.
 */
package example.mms;

import example.mms.MMSMessage;
import example.mms.PartsDialog;
import example.mms.SenderThread;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class MMSSend
extends MIDlet
implements CommandListener {
    private static Command CMD_EXIT = new Command("Exit", 7, 2);
    private static Command CMD_SEND = new Command("Send", 8, 1);
    private static Command CMD_ADD_PART = new Command("Add Part", 8, 1);
    private Display display;
    private String appID = this.getAppProperty("MMS-ApplicationID");
    private TextField subjectField;
    private TextField destinationField;
    private StringItem partsLabel;
    private Alert errorMessageAlert;
    private Alert sendingMessageAlert;
    private Displayable resumeScreen = null;
    private MMSMessage message;
    private PartsDialog partsDialog;

    public MMSSend() {
        this.display = Display.getDisplay((MIDlet)this);
        Form form = new Form("New MMS");
        this.subjectField = new TextField("Subject:", null, 256, 0);
        form.append((Item)this.subjectField);
        this.destinationField = new TextField("Destination Address: ", "mms://", 256, 0);
        form.append((Item)this.destinationField);
        this.partsLabel = new StringItem("Parts:", "0");
        form.append((Item)this.partsLabel);
        form.addCommand(CMD_EXIT);
        form.addCommand(CMD_SEND);
        form.addCommand(CMD_ADD_PART);
        form.setCommandListener((CommandListener)this);
        this.errorMessageAlert = new Alert("MMS", null, null, AlertType.ERROR);
        this.errorMessageAlert.setTimeout(5000);
        this.sendingMessageAlert = new Alert("MMS", null, null, AlertType.INFO);
        this.sendingMessageAlert.setTimeout(5000);
        this.sendingMessageAlert.setCommandListener((CommandListener)this);
        this.resumeScreen = form;
        this.message = new MMSMessage();
    }

    public void startApp() {
        this.display.setCurrent(this.resumeScreen);
    }

    public void pauseApp() {
        this.resumeScreen = this.display.getCurrent();
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == CMD_EXIT || command == Alert.DISMISS_COMMAND) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (command == CMD_ADD_PART) {
                if (this.partsDialog == null) {
                    this.partsDialog = new PartsDialog(this);
                }
                this.partsDialog.show();
            } else if (command == CMD_SEND) {
                this.promptAndSend();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void show() {
        this.partsLabel.setText(Integer.toString(this.partsDialog.counter));
        this.display.setCurrent(this.resumeScreen);
    }

    Display getDisplay() {
        return this.display;
    }

    MMSMessage getMessage() {
        return this.message;
    }

    private void promptAndSend() {
        try {
            String string = this.destinationField.getString();
            this.message.setSubject(this.subjectField.getString());
            this.message.setDestination(string);
            String string2 = "Sending message to " + string + "...";
            this.sendingMessageAlert.setString(string2);
            new SenderThread(this.message, this.appID).start();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorMessageAlert.setString(illegalArgumentException.getMessage());
            this.display.setCurrent((Displayable)this.errorMessageAlert);
        }
    }
}

