/*
 * Decompiled with CFR 0.152.
 */
package example.cbs;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class CBSReceive
extends MIDlet
implements CommandListener,
Runnable,
MessageListener {
    Command exitCommand = new Command("Exit", 7, 2);
    Alert waiting;
    Display display;
    Thread thread;
    String[] connections;
    boolean done;
    String cbsMessageID = this.getAppProperty("CBS-Message-Identifier");
    MessageConnection cbsconn;
    Message msg;
    Alert receivedMessage;

    public CBSReceive() {
        this.display = Display.getDisplay((MIDlet)this);
        this.waiting = new Alert("CBS Receive", null, null, AlertType.INFO);
        this.waiting.addCommand(this.exitCommand);
        this.waiting.setCommandListener((CommandListener)this);
        this.waiting.setTimeout(-2);
        this.receivedMessage = new Alert("CBS Received", null, null, AlertType.INFO);
        this.receivedMessage.setTimeout(-2);
        this.receivedMessage.addCommand(this.exitCommand);
        this.receivedMessage.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        String string = "cbs://:" + this.cbsMessageID;
        if (this.cbsconn == null) {
            try {
                this.cbsconn = (MessageConnection)Connector.open((String)string);
                this.cbsconn.setMessageListener((MessageListener)this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.display.setCurrent((Displayable)this.waiting);
        this.connections = PushRegistry.listConnections((boolean)true);
        if (this.connections == null || this.connections.length == 0) {
            this.waiting.setString("Waiting for CBS with Message ID " + this.cbsMessageID + "...");
        } else {
            this.done = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        if (this.thread == null) {
            this.done = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            while (!this.done) {
                this.msg = this.cbsconn.receive();
                if (this.msg == null) continue;
                if (this.msg instanceof TextMessage) {
                    this.receivedMessage.setString(((TextMessage)this.msg).getPayloadText());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = ((BinaryMessage)this.msg).getPayloadData();
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(Integer.toHexString(byArray[i]));
                        stringBuffer.append(' ');
                    }
                    this.receivedMessage.setString(stringBuffer.toString());
                }
                this.display.setCurrent((Displayable)this.receivedMessage);
            }
            this.cbsconn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pauseApp() {
        this.done = true;
        this.thread = null;
    }

    public void destroyApp(boolean bl) {
        this.done = true;
        this.thread = null;
        if (this.cbsconn != null) {
            try {
                this.cbsconn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.exitCommand || command == Alert.DISMISS_COMMAND) {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

