/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandlerDataSource;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;
import javax.activation.URLDataSource;
import javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private DataSource dataSource;
    private DataSource objDataSource;
    private Object object;
    private String objectMimeType;
    private CommandMap currentCommandMap;
    private static final DataFlavor[] emptyFlavors = new DataFlavor[0];
    private DataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler;
    private DataContentHandler factoryDCH;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory;
    private String shortType;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (factory != this.oldFactory) {
            this.transferFlavors = emptyFlavors;
        }
        if (this.transferFlavors == emptyFlavors) {
            this.transferFlavors = this.getDataContentHandler().getTransferDataFlavors();
        }
        return this.transferFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.dataSource != null) {
            inputStream = this.dataSource.getInputStream();
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            if (dataContentHandler == null) {
                throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getBaseType());
            }
            if (dataContentHandler instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dataContentHandler).getDCH() == null) {
                throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getBaseType());
            }
            DataContentHandler dataContentHandler2 = dataContentHandler;
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            new Thread((Runnable)new 1(dataContentHandler2, pipedOutputStream, this), "DataHandler.getInputStream").start();
            inputStream = pipedInputStream;
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getOutputStream();
        }
        return null;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataSource != null) {
            int n;
            InputStream inputStream = null;
            byte[] byArray = new byte[8192];
            inputStream = this.dataSource.getInputStream();
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            return;
        }
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        dataContentHandler.writeTo(this.object, this.objectMimeType, outputStream);
    }

    public Object getContent() throws IOException {
        return this.getDataContentHandler().getContent(this.getDataSource());
    }

    private synchronized String getBaseType() {
        block2: {
            if (this.shortType != null) break block2;
            String string = this.getContentType();
            try {
                MimeType mimeType = new MimeType(string);
                this.shortType = mimeType.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = string;
            }
        }
        return this.shortType;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public DataHandler(URL uRL) {
        this.dataSource = new URLDataSource(uRL);
        this.oldFactory = factory;
    }

    public CommandInfo[] getAllCommands() {
        return this.getCommandMap().getAllCommands(this.getBaseType());
    }

    public CommandInfo[] getPreferredCommands() {
        return this.getCommandMap().getPreferredCommands(this.getBaseType());
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        if (commandMap != this.currentCommandMap || commandMap == null) {
            this.transferFlavors = emptyFlavors;
            this.dataContentHandler = null;
            this.currentCommandMap = commandMap;
        }
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String string = this.getBaseType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(string);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            this.dataContentHandler = this.getCommandMap().createDataContentHandler(string);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory dataContentHandlerFactory) {
        block4: {
            if (factory != null) {
                throw new Error("DataContentHandlerFactory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    if ((class$javax$activation$DataHandler != null ? class$javax$activation$DataHandler : (class$javax$activation$DataHandler = DataHandler.class$("javax.activation.DataHandler"))).getClassLoader() == dataContentHandlerFactory.getClass().getClassLoader()) break block4;
                    throw securityException;
                }
            }
        }
        factory = dataContentHandlerFactory;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (this.objDataSource == null) {
                this.objDataSource = new DataHandlerDataSource(this);
            }
            return this.objDataSource;
        }
        return this.dataSource;
    }

    public DataHandler(DataSource dataSource) {
        this.dataSource = dataSource;
        this.oldFactory = factory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.getDataContentHandler().getTransferData(dataFlavor, this.dataSource);
    }

    public Object getBean(CommandInfo commandInfo) {
        Object object = null;
        try {
            object = commandInfo.getCommandObject(this, this.getClass().getClassLoader());
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return object;
    }

    public DataHandler(Object object, String string) {
        this.object = object;
        this.objectMimeType = string;
        this.oldFactory = factory;
    }

    public CommandInfo getCommand(String string) {
        return this.getCommandMap().getCommand(this.getBaseType(), string);
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ PipedOutputStream val$pos;
        private final /* synthetic */ DataHandler this$0;
        private final /* synthetic */ DataContentHandler val$fdch;

        public void run() {
            try {
                try {
                    this.val$fdch.writeTo(this.this$0.object, this.this$0.objectMimeType, this.val$pos);
                }
                catch (IOException iOException) {
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.val$pos.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.val$pos.close();
            }
            catch (IOException iOException) {}
        }

        /* synthetic */ 1(DataContentHandler dataContentHandler, PipedOutputStream pipedOutputStream, DataHandler dataHandler) {
            this.val$fdch = dataContentHandler;
            this.val$pos = pipedOutputStream;
            this.this$0 = dataHandler;
        }
    }
}

