/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.MailcapEntry;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MailcapFile {
    private Hashtable type_hash;
    private static boolean debug;

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {}
    }

    public MailcapFile() {
        if (debug) {
            System.out.println("new MailcapFile: default");
        }
        this.type_hash = new Hashtable();
    }

    public MailcapFile(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("new MailcapFile: InputStream");
        }
        this.type_hash = this.createMailcapHash(new InputStreamReader(inputStream, "iso-8859-1"));
    }

    protected static void reportParseError(int n, int n2, int n3, int n4, String string) throws MailcapParseException {
        if (debug) {
            System.out.println("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token.");
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token.");
    }

    protected static void reportParseError(int n, int n2, int n3, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n3) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " or a " + MailcapTokenizer.nameForToken(n2) + " token.");
    }

    protected static void reportParseError(int n, int n2, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n2) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " token.");
    }

    public MailcapFile(String string) throws IOException {
        if (debug) {
            System.out.println("new MailcapFile: file " + string);
        }
        FileReader fileReader = null;
        fileReader = new FileReader(string);
        this.type_hash = this.createMailcapHash(fileReader);
    }

    public void appendToMailcap(String string) {
        if (debug) {
            System.out.println("appendToMailcap: " + string);
        }
        try {
            this.parse(new StringReader(string), this.type_hash);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public MailcapEntry getMailcapEntry(String string) {
        MailcapEntry mailcapEntry = null;
        return mailcapEntry;
    }

    private Hashtable createMailcapHash(Reader reader) throws IOException {
        Hashtable hashtable = new Hashtable();
        this.parse(reader, hashtable);
        return hashtable;
    }

    private void parse(Reader reader, Hashtable hashtable) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.charAt(0) == '#') continue;
                if (string.charAt(string.length() - 1) == '\\') {
                    if (string2 != null) {
                        string2 = String.valueOf(string2) + string.substring(0, string.length() - 1);
                        continue;
                    }
                    string2 = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string2 != null) {
                    string2 = String.valueOf(string2) + string;
                    try {
                        MailcapFile.parseLine(string2, hashtable);
                    }
                    catch (MailcapParseException mailcapParseException) {}
                    string2 = null;
                    continue;
                }
                try {
                    MailcapFile.parseLine(string, hashtable);
                }
                catch (MailcapParseException mailcapParseException) {}
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    public Hashtable getMailcapList(String string) {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        hashtable = (Hashtable)this.type_hash.get(string);
        int n = string.indexOf(47);
        String string2 = String.valueOf(string.substring(0, n + 1)) + "*";
        hashtable2 = (Hashtable)this.type_hash.get(string2);
        if (hashtable2 != null) {
            hashtable = hashtable != null ? this.mergeResults(hashtable, hashtable2) : hashtable2;
        }
        return hashtable;
    }

    protected static void parseLine(String string, Hashtable hashtable) throws MailcapParseException, IOException {
        Hashtable<String, Vector<String>> hashtable2;
        MailcapTokenizer mailcapTokenizer = new MailcapTokenizer(string);
        mailcapTokenizer.setIsAutoquoting(false);
        String string2 = "";
        String string3 = "*";
        String string4 = "";
        if (debug) {
            System.out.println("parse: " + string);
        }
        int n = mailcapTokenizer.nextToken();
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 2) {
            MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
        }
        string2 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
        n = mailcapTokenizer.nextToken();
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 47 && n != 59) {
            MailcapFile.reportParseError(47, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n == 47) {
            n = mailcapTokenizer.nextToken();
            string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
            if (n != 2) {
                MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
            }
            string3 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
            n = mailcapTokenizer.nextToken();
            string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        }
        if (debug) {
            System.out.println("  Type: " + string2 + "/" + string3);
        }
        if ((hashtable2 = (Hashtable<String, Vector<String>>)hashtable.get(String.valueOf(string2) + "/" + string3)) == null) {
            hashtable2 = new Hashtable<String, Vector<String>>();
            hashtable.put(String.valueOf(string2) + "/" + string3, hashtable2);
        }
        if (n != 59) {
            MailcapFile.reportParseError(59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        mailcapTokenizer.setIsAutoquoting(true);
        n = mailcapTokenizer.nextToken();
        mailcapTokenizer.setIsAutoquoting(false);
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 2 && n != 59) {
            MailcapFile.reportParseError(2, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n != 59) {
            n = mailcapTokenizer.nextToken();
        }
        if (n == 59) {
            do {
                if ((n = mailcapTokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                String string5 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
                n = mailcapTokenizer.nextToken();
                if (n != 61 && n != 59 && n != 5) {
                    MailcapFile.reportParseError(61, 59, 5, n, mailcapTokenizer.getCurrentTokenValue());
                }
                if (n != 61) continue;
                mailcapTokenizer.setIsAutoquoting(true);
                n = mailcapTokenizer.nextToken();
                mailcapTokenizer.setIsAutoquoting(false);
                if (n != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                String string6 = mailcapTokenizer.getCurrentTokenValue();
                if (string5.startsWith("x-java-")) {
                    Vector<String> vector;
                    String string7 = string5.substring(7);
                    if (debug) {
                        System.out.println("    Command: " + string7 + ", Class: " + string6);
                    }
                    if ((vector = (Vector<String>)hashtable2.get(string7)) == null) {
                        vector = new Vector<String>();
                        hashtable2.put(string7, vector);
                    }
                    vector.insertElementAt(string6, 0);
                }
                n = mailcapTokenizer.nextToken();
            } while (n == 59);
            return;
        }
        if (n != 5) {
            MailcapFile.reportParseError(5, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
    }

    private Hashtable mergeResults(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable3.get(string);
            if (vector == null) {
                hashtable3.put(string, hashtable2.get(string));
                continue;
            }
            Vector vector2 = (Vector)hashtable2.get(string);
            Enumeration enumeration2 = vector2.elements();
            vector = (Vector)vector.clone();
            hashtable3.put(string, vector);
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return hashtable3;
    }
}

