/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.sun.j2se.io.ConnectionBaseInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static final String DEFAULT_PLATFORM = "gcf";
    private static String platform;
    private static boolean j2me;
    private static String classRoot;

    private Connector() {
    }

    public static Connection open(String string) throws IOException {
        return Connector.open(string, 3);
    }

    public static Connection open(String string, int n) throws IOException {
        return Connector.open(string, n, false);
    }

    public static Connection open(String string, int n, boolean bl) throws IOException {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("illegal access mode: " + n);
        }
        if (platform != null) {
            try {
                return Connector.openPrim(string, n, bl, platform);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return Connector.openPrim(string, n, bl, j2me ? "j2me" : "j2se");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConnectionNotFoundException("The requested protocol does not exist " + string);
        }
    }

    private static Connection openPrim(String string, int n, boolean bl, String string2) throws IOException, ClassNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("Null URL");
        }
        int n2 = string.indexOf(58);
        if (n2 < 1) {
            throw new IllegalArgumentException("no ':' in URL");
        }
        try {
            String string3 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            string3 = string3.replace('-', '_');
            Class<?> clazz = Class.forName(classRoot + "." + string2 + "." + string3 + ".Protocol");
            ConnectionBaseInterface connectionBaseInterface = (ConnectionBaseInterface)clazz.newInstance();
            return connectionBaseInterface.openPrim(string, n, bl);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String string) throws IOException {
        DataInputStream dataInputStream;
        InputConnection inputConnection = (InputConnection)Connector.open(string, 1);
        try {
            dataInputStream = inputConnection.openDataInputStream();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputConnection.close();
            throw throwable;
        }
        inputConnection.close();
        return dataInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String string) throws IOException {
        DataOutputStream dataOutputStream;
        OutputConnection outputConnection = (OutputConnection)Connector.open(string, 2);
        try {
            dataOutputStream = outputConnection.openDataOutputStream();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            outputConnection.close();
            throw throwable;
        }
        outputConnection.close();
        return dataOutputStream;
    }

    public static InputStream openInputStream(String string) throws IOException {
        return Connector.openDataInputStream(string);
    }

    public static OutputStream openOutputStream(String string) throws IOException {
        return Connector.openDataOutputStream(string);
    }

    static {
        j2me = true;
        String string = null;
        try {
            if (System.getProperty("microedition.configuration") != null) {
                j2me = true;
            }
            platform = (string = System.getProperty("microedition.platform")) == null ? DEFAULT_PLATFORM : string;
            classRoot = System.getProperty("microedition.protocolpath");
            if (classRoot == null) {
                classRoot = "com.sun.j2se.io";
            }
        }
        catch (AccessControlException accessControlException) {
            j2me = false;
            platform = DEFAULT_PLATFORM;
            classRoot = "com.sun.j2se.io";
        }
    }
}

