/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.socket;

import com.sun.j2se.io.ConnectionBase;
import com.sun.j2se.io.gcf.UniversalFilterInputStream;
import com.sun.j2se.io.gcf.UniversalFilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements StreamConnection {
    Socket socket;
    int opens = 0;
    boolean closedFlag = false;
    int socket_mode;
    String nameOrIP = null;
    int port = 0;

    public void open(String string, int n, boolean bl) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    public Connection openPrim(String string, int n, boolean bl) throws IOException {
        if (string.charAt(0) != '/' || string.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + string);
        }
        string = string.substring(2);
        this.socket_mode = n;
        try {
            int n2 = string.indexOf(58);
            if (n2 == -1) {
                throw new IllegalArgumentException("Bad protocol specification in " + string);
            }
            this.nameOrIP = string.substring(0, n2);
            if (this.nameOrIP.length() == 0) {
                com.sun.j2se.io.gcf.serversocket.Protocol protocol = new com.sun.j2se.io.gcf.serversocket.Protocol();
                protocol.open("//" + string, n, bl);
                return protocol;
            }
            this.port = Integer.parseInt(string.substring(n2 + 1));
            this.socket = new Socket(this.nameOrIP, this.port);
            ++this.opens;
            this.closedFlag = false;
            return this;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port number in " + string);
        }
    }

    public void open(Socket socket) throws IOException {
        this.socket = socket;
        this.closedFlag = false;
    }

    public InputStream openInputStream() throws IOException {
        if (this.socket_mode == 2) {
            throw new IOException("Connection not open for reading");
        }
        UniversalFilterInputStream universalFilterInputStream = new UniversalFilterInputStream(this, this.socket.getInputStream());
        ++this.opens;
        return universalFilterInputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.socket_mode == 1) {
            throw new IOException("Connection not open for writing");
        }
        if (this.closedFlag) {
            throw new IOException("Connection has been closed");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.nameOrIP != null) {
                securityManager.checkConnect(this.nameOrIP, this.port);
            } else {
                securityManager.checkConnect("localhost", this.port);
            }
        }
        UniversalFilterOutputStream universalFilterOutputStream = new UniversalFilterOutputStream(this, this.socket.getOutputStream());
        ++this.opens;
        return universalFilterOutputStream;
    }

    public void close() throws IOException {
        if (--this.opens == 0) {
            this.socket.close();
            this.closedFlag = true;
        }
    }
}

