/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.file;

import com.sun.j2se.io.gcf.file.ProtocolBase;
import java.io.IOException;
import javax.microedition.io.Connection;

public abstract class ProtocolNative
extends ProtocolBase {
    public boolean reading;
    public boolean writing;
    boolean append = false;
    boolean needToOpen = true;

    public Connection open0(String string, String string2, int n) throws IOException {
        if (string.length() >= 2 && string.charAt(0) == '/' && string.charAt(1) == '/') {
            if (string.length() >= 3) {
                if (string.charAt(2) != '/') {
                    throw new IllegalArgumentException("Network format not implemented " + string);
                }
                string = string.substring(2);
            } else {
                throw new IllegalArgumentException("Invalid file name " + string);
            }
        }
        this.reading = (n & 1) != 0;
        boolean bl = this.writing = (n & 2) != 0;
        if (string2.length() > 0) {
            if (string2.equals("append=true")) {
                this.append = true;
            } else {
                throw new IllegalArgumentException("Unknown parameters " + string2);
            }
        }
        if (this.append && this.reading) {
            throw new IllegalArgumentException("Cannot open file for reading and appending");
        }
        return this.prim_openProtocol(string, string2, n);
    }

    public void close0() throws IOException {
        this.prim_closeProtocol();
    }

    void ensurePrimOpen() throws IOException {
        this.testSelection();
        if (this.needToOpen) {
            if (!this.prim_isDirectory()) {
                this.reallyOpen();
            }
            this.needToOpen = false;
        }
    }

    void reallyOpen() throws IOException {
        boolean bl = this.prim_exists();
        if (this.append) {
            if (this.reading) {
                throw new RuntimeException("Internal error - prim_open() append && reading");
            }
            if (!this.writing) {
                throw new RuntimeException("Internal error - prim_open() append && !writing");
            }
            this.prim_realOpen();
            this.prim_seek(this.prim_lengthOf());
            return;
        }
        if (this.reading && !this.writing) {
            if (!bl) {
                throw new RuntimeException("Internal error - prim_open() reading && !exists");
            }
            this.prim_realOpen();
            return;
        }
        if (this.writing && !this.reading) {
            if (bl) {
                this.prim_deleteItem();
            }
            return;
        }
        if (this.reading && this.writing) {
            this.prim_realOpen();
            return;
        }
        throw new RuntimeException("Internal error - prim_open() !writing && !reading");
    }

    public void clearSelection() throws IOException {
        this.needToOpen = true;
        this.prim_clearSelection();
    }

    public long getAvailableSpace0() throws IOException {
        return this.prim_availableSpace();
    }

    public int getItemCount0() throws IOException {
        return this.prim_countItems();
    }

    public boolean selectFirstItem0() throws IOException {
        this.clearSelection();
        this.prim_findFirstItemAndSelect();
        return this.isSelected0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectNextItem0() throws IOException {
        boolean bl = false;
        try {
            this.prim_findItemAfterSelectionAndSelect();
            bl = this.isSelected0();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearSelection();
            throw throwable;
        }
        this.clearSelection();
        return bl;
    }

    public boolean selectItem0(String string) throws IOException {
        this.clearSelection();
        this.prim_findItemAndSelect(string);
        return this.isSelected0();
    }

    public boolean selectItemByInt0(int n) throws IOException {
        this.clearSelection();
        this.prim_findItemAndSelectByInt(n);
        return this.isSelected0();
    }

    public void deselectItem0() throws IOException {
        this.clearSelection();
    }

    public boolean isSelected0() throws IOException {
        return this.prim_isSelected();
    }

    public void create0() throws IOException {
        this.clearSelection();
        this.prim_createAndSelect();
        if (!this.isSelected0()) {
            throw new IOException("Internal error - exception not thrown");
        }
    }

    public void createName0(String string) throws IOException {
        this.clearSelection();
        this.prim_createFileAndSelect(string);
        if (!this.isSelected0()) {
            throw new IOException("Internal error - exception not thrown");
        }
    }

    public void createNameByInt0(int n) throws IOException {
        this.clearSelection();
        this.prim_createFileAndSelectByInt(n);
        if (!this.isSelected0()) {
            throw new IOException("Internal error - exception not thrown");
        }
    }

    public void createDirectory0(String string) throws IOException {
        this.clearSelection();
        this.prim_createDirectoryAndSelect(string);
        if (!this.isSelected0()) {
            throw new IOException("Internal error - exception not thrown");
        }
    }

    void testSelection() throws IOException {
        if (!this.isSelected0()) {
            throw new IOException("Internal error - nothing selected");
        }
    }

    public void delete0() throws IOException {
        this.testSelection();
        this.prim_deleteItem();
    }

    public void rename0(String string) throws IOException {
        this.testSelection();
        this.prim_renameFile(string);
    }

    public void renameByInt0(int n) throws IOException {
        this.testSelection();
        this.prim_renameFileByInt(n);
    }

    public void renameDirectory0(String string) throws IOException {
        this.testSelection();
        this.prim_renameDirectory(string);
    }

    public long getLength0() throws IOException {
        this.testSelection();
        return this.prim_lengthOf();
    }

    public void setLength0(long l) throws IOException {
        this.testSelection();
        this.prim_setLength(l);
    }

    public long getModificationDate0() throws IOException {
        this.testSelection();
        return this.prim_timeOf();
    }

    public String getItemName0() throws IOException {
        this.testSelection();
        return this.prim_getSelectionName();
    }

    public int getItemNumber0() throws IOException {
        this.testSelection();
        return this.prim_getSelectionNumber();
    }

    public boolean isDirectory0() throws IOException {
        this.testSelection();
        return this.prim_isDirectory();
    }

    public boolean canRead0() throws IOException {
        this.testSelection();
        return this.prim_canRead();
    }

    public boolean canWrite0() throws IOException {
        this.testSelection();
        return this.prim_canWrite();
    }

    public void setReadable0(boolean bl) throws IOException {
        this.testSelection();
        if (!this.prim_setReadable(bl)) {
            throw new SecurityException();
        }
    }

    public void setWritable0(boolean bl) throws IOException {
        this.testSelection();
        if (!this.prim_setWritable(bl)) {
            throw new SecurityException();
        }
    }

    public int available0() throws IOException {
        this.ensurePrimOpen();
        return (int)(this.getLength0() - this.getPosition0());
    }

    public void seek0(long l) throws IOException {
        this.ensurePrimOpen();
        this.prim_seek(l);
    }

    public long getPosition0() throws IOException {
        this.ensurePrimOpen();
        return this.prim_getPosition();
    }

    public int read0() throws IOException {
        this.ensurePrimOpen();
        return this.prim_read();
    }

    public int readBytes0(byte[] byArray, int n, int n2) throws IOException {
        this.ensurePrimOpen();
        return this.prim_readBytes(byArray, n, n2);
    }

    public void write0(int n) throws IOException {
        this.ensurePrimOpen();
        this.prim_write(n);
    }

    public void writeBytes0(byte[] byArray, int n, int n2) throws IOException {
        this.ensurePrimOpen();
        this.prim_writeBytes(byArray, n, n2);
    }

    public abstract Connection prim_openProtocol(String var1, String var2, int var3) throws IOException;

    public abstract void prim_closeProtocol() throws IOException;

    public abstract void prim_realOpen() throws IOException;

    public abstract void prim_clearSelection() throws IOException;

    public abstract String prim_getSelectionName() throws IOException;

    public abstract int prim_getSelectionNumber() throws IOException;

    public abstract boolean prim_isSelected() throws IOException;

    public abstract void prim_findFirstItemAndSelect() throws IOException;

    public abstract void prim_findItemAndSelect(String var1) throws IOException;

    public abstract void prim_findItemAndSelectByInt(int var1) throws IOException;

    public abstract void prim_findItemAfterSelectionAndSelect() throws IOException;

    public abstract long prim_availableSpace() throws IOException;

    public abstract int prim_countItems() throws IOException;

    public abstract void prim_createAndSelect() throws IOException;

    public abstract void prim_createFileAndSelect(String var1) throws IOException;

    public abstract void prim_createFileAndSelectByInt(int var1) throws IOException;

    public abstract void prim_createDirectoryAndSelect(String var1) throws IOException;

    public abstract boolean prim_deleteItem() throws IOException;

    public abstract boolean prim_renameFile(String var1) throws IOException;

    public abstract boolean prim_renameFileByInt(int var1) throws IOException;

    public abstract boolean prim_renameDirectory(String var1) throws IOException;

    public abstract long prim_lengthOf() throws IOException;

    public abstract void prim_setLength(long var1) throws IOException;

    public abstract long prim_timeOf() throws IOException;

    public abstract boolean prim_exists() throws IOException;

    public abstract boolean prim_isDirectory() throws IOException;

    public abstract boolean prim_canRead() throws IOException;

    public abstract boolean prim_canWrite() throws IOException;

    public abstract boolean prim_setReadable(boolean var1) throws IOException;

    public abstract boolean prim_setWritable(boolean var1) throws IOException;

    public abstract void prim_seek(long var1) throws IOException;

    public abstract long prim_getPosition() throws IOException;

    public abstract int prim_read() throws IOException;

    public abstract int prim_readBytes(byte[] var1, int var2, int var3) throws IOException;

    public abstract void prim_write(int var1) throws IOException;

    public abstract void prim_writeBytes(byte[] var1, int var2, int var3) throws IOException;
}

